/*@@
   @file    Cactus_Parameters.c
   @author  Automatically generated by CreateParameterBindings.pl
   @desc
            Creates/extends parameters for this thorn
   @enddesc
 @@*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "cctk_Config.h"
#include "cctk_Constants.h"
#include "ParameterBindings.h"
#include "CParameterStructNames.h"

/* structure containing all private parameters of thorn Cactus */
struct
{
  const char * cctk_run_title;
  const char * cctk_timer_output;
  const char * info_format;
  const char * recovery_mode;
  const char * schedule_sort_mode;
  CCTK_INT allow_mixeddim_gfs;
  CCTK_INT cctk_brief_output;
  CCTK_INT cctk_full_warnings;
  CCTK_INT cctk_show_banners;
  CCTK_INT cctk_show_schedule;
  CCTK_INT cctk_strong_param_check;
  CCTK_INT highlight_warning_messages;
  CCTK_INT manual_cache_setup;
  CCTK_INT manual_cache_size;
  CCTK_INT manual_cacheline_bytes;
  CCTK_INT schedule_sort_warnings;
} PRIVATE_CACTUS_STRUCT;


/* structure containing all restricted parameters of thorn Cactus */
struct
{
  CCTK_REAL cctk_final_time;
  CCTK_REAL cctk_initial_time;
  CCTK_REAL max_runtime;
  const char * terminate;
  CCTK_INT cctk_itlast;
  CCTK_INT terminate_next;
} RESTRICTED_CACTUS_STRUCT;


int CCTKi_BindingsCreateCactusParameters(void);
int CCTKi_BindingsCreateCactusParameters(void)
{
  CCTKi_ParameterCreate("cctk_final_time",
                        "Cactus",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "Final time for evolution",
                        "-1.0",
                        &(RESTRICTED_CACTUS_STRUCT.cctk_final_time),
                        0,
                        NULL,
                        1,
                        ":", "Anything");

  CCTKi_ParameterCreate("cctk_initial_time",
                        "Cactus",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Initial time for evolution",
                        "0.0",
                        &(RESTRICTED_CACTUS_STRUCT.cctk_initial_time),
                        0,
                        NULL,
                        1,
                        ":", "Anything");

  CCTKi_ParameterCreate("cctk_itlast",
                        "Cactus",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "Final iteration number",
                        "10",
                        &(RESTRICTED_CACTUS_STRUCT.cctk_itlast),
                        0,
                        NULL,
                        1,
                        ":", "Any integer");

  CCTKi_ParameterCreate("max_runtime",
                        "Cactus",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "Terminate evolution loop after a certain elapsed runtime (in minutes)",
                        "0.0",
                        &(RESTRICTED_CACTUS_STRUCT.max_runtime),
                        0,
                        NULL,
                        1,
                        "0.0:", "Zero disables maximum runtime condition");

  CCTKi_ParameterCreate("terminate",
                        "Cactus",
                        "KEYWORD",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "Condition on which to terminate evolution loop",
                        "iteration",
                        &(RESTRICTED_CACTUS_STRUCT.terminate),
                        0,
                        NULL,
                        8,
                        "never", "Never terminate",
                        "iteration", "Take termination condition from iteration number",
                        "time", "Take termination condition from coordinate time",
                        "runtime", "Take termination condition from elapsed runtime",
                        "any", "Take termination condition from any of iteration number, coordinate time, or elapsed runtime",
                        "all", "Take termination condition from all of iteration number, coordinate time, and elapsed runtime",
                        "either", "Take termination condition from either iteration number or coordinate time (DEPRECATED IN BETA14)",
                        "both", "Take termination condition from both iteration number and coordinate time (DEPRECATED IN BETA14)");

  CCTKi_ParameterCreate("terminate_next",
                        "Cactus",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "Terminate on next iteration?",
                        "no",
                        &(RESTRICTED_CACTUS_STRUCT.terminate_next),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("allow_mixeddim_gfs",
                        "Cactus",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Allow use of GFs from different dimensions",
                        "no",
                        &(PRIVATE_CACTUS_STRUCT.allow_mixeddim_gfs),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("cctk_brief_output",
                        "Cactus",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Give only brief output",
                        "no",
                        &(PRIVATE_CACTUS_STRUCT.cctk_brief_output),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("cctk_full_warnings",
                        "Cactus",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Give detailed information for each warning statement",
                        "no",
                        &(PRIVATE_CACTUS_STRUCT.cctk_full_warnings),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("cctk_run_title",
                        "Cactus",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Description of this simulation",
                        "",
                        &(PRIVATE_CACTUS_STRUCT.cctk_run_title),
                        0,
                        NULL,
                        1,
                        ".*", "Any string");

  CCTKi_ParameterCreate("cctk_show_banners",
                        "Cactus",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Show any registered banners for the different thorns",
                        "yes",
                        &(PRIVATE_CACTUS_STRUCT.cctk_show_banners),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("cctk_show_schedule",
                        "Cactus",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Print the scheduling tree to standard output",
                        "yes",
                        &(PRIVATE_CACTUS_STRUCT.cctk_show_schedule),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("cctk_strong_param_check",
                        "Cactus",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Die on parameter errors in CCTK_PARAMCHECK",
                        "yes",
                        &(PRIVATE_CACTUS_STRUCT.cctk_strong_param_check),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("cctk_timer_output",
                        "Cactus",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Provide output from timers",
                        "off",
                        &(PRIVATE_CACTUS_STRUCT.cctk_timer_output),
                        0,
                        NULL,
                        2,
                        "off", "No timer output",
                        "full", "Detailed timer output");

  CCTKi_ParameterCreate("highlight_warning_messages",
                        "Cactus",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Highlight CCTK warning messages ?",
                        "yes",
                        &(PRIVATE_CACTUS_STRUCT.highlight_warning_messages),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("info_format",
                        "Cactus",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "What information do CCTK_INFO() and CCTK_VInfo() print?",
                        "basic",
                        &(PRIVATE_CACTUS_STRUCT.info_format),
                        0,
                        NULL,
                        4,
                        "basic", "INFO (ThornName): message",
                        "numeric time stamp", "numeric_timestamp\tINFO (ThornName): message",
                        "human-readable time stamp",     "human readable timestamp: INFO (ThornName): message",
                        "full time stamp",     "numeric_timestamp\thuman readable timestamp: INFO (ThornName): message");

  CCTKi_ParameterCreate("manual_cache_setup",
                        "Cactus",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Set the cache size manually",
                        "no",
                        &(PRIVATE_CACTUS_STRUCT.manual_cache_setup),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("manual_cache_size",
                        "Cactus",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The size to set the cache to if not done automatically (bytes)",
                        "0",
                        &(PRIVATE_CACTUS_STRUCT.manual_cache_size),
                        0,
                        NULL,
                        1,
                        "0:", "Any whole number");

  CCTKi_ParameterCreate("manual_cacheline_bytes",
                        "Cactus",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The size of a cacheline if not set automatically (bytes)",
                        "0",
                        &(PRIVATE_CACTUS_STRUCT.manual_cacheline_bytes),
                        0,
                        NULL,
                        1,
                        "0:", "Any whole number");

  CCTKi_ParameterCreate("recovery_mode",
                        "Cactus",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "How to behave when recovering from a checkpoint",
                        "strict",
                        &(PRIVATE_CACTUS_STRUCT.recovery_mode),
                        0,
                        NULL,
                        2,
                        "strict", "All CCTK variables must be recovered successfully, no INITIAL timebins will be scheduled",
                        "relaxed", "Recover variables if possible, after INITIAL timebins have been scheduled");

  CCTKi_ParameterCreate("schedule_sort_mode",
                        "Cactus",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "How to behave when no explicit ordering is prescribed between itemse",
                        "none",
                        &(PRIVATE_CACTUS_STRUCT.schedule_sort_mode),
                        0,
                        NULL,
                        3,
                        "none", "no special ordering is enforced",
                        "ascending", "sorted alphabetically by thorn name and item name",
                        "descending", "sorted in reverse alphabetical order by thorn name and item name");

  CCTKi_ParameterCreate("schedule_sort_warnings",
                        "Cactus",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Output warnings if a schedule item refers to a non-existing item for ordering",
                        "no",
                        &(PRIVATE_CACTUS_STRUCT.schedule_sort_warnings),
                        0,
                        NULL,
                        0);

  return 0;
}

int CCTKi_BindingsCactusParameterExtensions(void);
int CCTKi_BindingsCactusParameterExtensions(void)
{
  return 0;
}
