/*@@
   @file    CartGrid3D_Parameters.c
   @author  Automatically generated by CreateParameterBindings.pl
   @desc
            Creates/extends parameters for this thorn
   @enddesc
 @@*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "cctk_Config.h"
#include "cctk_Constants.h"
#include "ParameterBindings.h"
#include "CParameterStructNames.h"
#include "ParameterCRestrictedDRIVER.h"

/* structure containing all private parameters of thorn CartGrid3D */
struct
{
  const char * set_coordinate_ranges_on;
  CCTK_INT avoid_origin;
  CCTK_INT avoid_originx;
  CCTK_INT avoid_originy;
  CCTK_INT avoid_originz;
  CCTK_INT no_origin;
  CCTK_INT no_originx;
  CCTK_INT no_originy;
  CCTK_INT no_originz;
  CCTK_INT register_default_coordinate_systems;
} PRIVATE_CARTGRID3D_STRUCT;


/* structure containing all restricted parameters of thorn CartGrid3D */
struct
{
  CCTK_REAL dx;
  CCTK_REAL dxyz;
  CCTK_REAL dy;
  CCTK_REAL dz;
  CCTK_REAL xmax;
  CCTK_REAL xmin;
  CCTK_REAL xyzmax;
  CCTK_REAL xyzmin;
  CCTK_REAL ymax;
  CCTK_REAL ymin;
  CCTK_REAL zmax;
  CCTK_REAL zmin;
  const char * bitant_plane;
  const char * domain;
  const char * quadrant_direction;
  const char * rotation_axis;
  const char * type;
  CCTK_INT symmetry_xmax;
  CCTK_INT symmetry_xmin;
  CCTK_INT symmetry_ymax;
  CCTK_INT symmetry_ymin;
  CCTK_INT symmetry_zmax;
  CCTK_INT symmetry_zmin;
} RESTRICTED_GRID_STRUCT;


int CCTKi_BindingsCreateCartGrid3DParameters(void);
int CCTKi_BindingsCreateCartGrid3DParameters(void)
{
  CCTKi_ParameterCreate("bitant_plane",
                        "CartGrid3D",
                        "KEYWORD",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Plane defining bitant domain",
                        "xy",
                        &(RESTRICTED_GRID_STRUCT.bitant_plane),
                        0,
                        NULL,
                        3,
                        "xy", "xy-plane",
                        "xz", "xz-plane",
                        "yz", "yz-plane");

  CCTKi_ParameterCreate("domain",
                        "CartGrid3D",
                        "KEYWORD",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Domain type",
                        "full",
                        &(RESTRICTED_GRID_STRUCT.domain),
                        0,
                        NULL,
                        6,
                        "octant", "Use an octant about the origin",
                        "quadrant", "Use a quadrant in x-y plane",
                        "quadrant_reflect_rotate", "Use a quadrant with rotation symmetry about an axis",
                        "bitant", "Use a bitant about the x-y plane",
                        "bitant_rotate", "Use a bitant with rotation symmetry about an axis",
                        "full", "Use the full domain");

  CCTKi_ParameterCreate("dx",
                        "CartGrid3D",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Coarse grid spacing in x-direction",
                        "0.3",
                        &(RESTRICTED_GRID_STRUCT.dx),
                        0,
                        NULL,
                        1,
                        "0:*", "Positive");

  CCTKi_ParameterCreate("dxyz",
                        "CartGrid3D",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Coarse grid spacing in x,y,z-directions",
                        "0.0",
                        &(RESTRICTED_GRID_STRUCT.dxyz),
                        0,
                        NULL,
                        1,
                        "0:*", "Positive");

  CCTKi_ParameterCreate("dy",
                        "CartGrid3D",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Coarse grid spacing in y-direction",
                        "0.3",
                        &(RESTRICTED_GRID_STRUCT.dy),
                        0,
                        NULL,
                        1,
                        "0:*", "Positive");

  CCTKi_ParameterCreate("dz",
                        "CartGrid3D",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Coarse grid spacing in z-direction",
                        "0.3",
                        &(RESTRICTED_GRID_STRUCT.dz),
                        0,
                        NULL,
                        1,
                        "0:*", "Positive");

  CCTKi_ParameterCreate("quadrant_direction",
                        "CartGrid3D",
                        "KEYWORD",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Direction defining quadrant domain",
                        "z",
                        &(RESTRICTED_GRID_STRUCT.quadrant_direction),
                        0,
                        NULL,
                        3,
                        "x", "x-direction",
                        "y", "y-direction",
                        "z", "z-direction");

  CCTKi_ParameterCreate("rotation_axis",
                        "CartGrid3D",
                        "KEYWORD",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Axis about which the rotation symmetry is to be applied",
                        "z",
                        &(RESTRICTED_GRID_STRUCT.rotation_axis),
                        0,
                        NULL,
                        3,
                        "x", "x-axis",
                        "y", "y-axis",
                        "z", "z-axis");

  CCTKi_ParameterCreate("symmetry_xmax",
                        "CartGrid3D",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Symmetry boundary condition on upper x boundary",
                        "no",
                        &(RESTRICTED_GRID_STRUCT.symmetry_xmax),
                        0,
                        NULL,
                        1,
                        ":", "Logical");

  CCTKi_ParameterCreate("symmetry_xmin",
                        "CartGrid3D",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Symmetry boundary condition on lower x boundary",
                        "no",
                        &(RESTRICTED_GRID_STRUCT.symmetry_xmin),
                        0,
                        NULL,
                        1,
                        ":", "Logical");

  CCTKi_ParameterCreate("symmetry_ymax",
                        "CartGrid3D",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Symmetry boundary condition on upper y boundary",
                        "no",
                        &(RESTRICTED_GRID_STRUCT.symmetry_ymax),
                        0,
                        NULL,
                        1,
                        ":", "Logical");

  CCTKi_ParameterCreate("symmetry_ymin",
                        "CartGrid3D",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Symmetry boundary condition on lower y boundary",
                        "no",
                        &(RESTRICTED_GRID_STRUCT.symmetry_ymin),
                        0,
                        NULL,
                        1,
                        ":", "Logical");

  CCTKi_ParameterCreate("symmetry_zmax",
                        "CartGrid3D",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Symmetry boundary condition on upper z boundary",
                        "no",
                        &(RESTRICTED_GRID_STRUCT.symmetry_zmax),
                        0,
                        NULL,
                        1,
                        ":", "Logical");

  CCTKi_ParameterCreate("symmetry_zmin",
                        "CartGrid3D",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Symmetry boundary condition on lower z boundary",
                        "no",
                        &(RESTRICTED_GRID_STRUCT.symmetry_zmin),
                        0,
                        NULL,
                        1,
                        ":", "Logical");

  CCTKi_ParameterCreate("type",
                        "CartGrid3D",
                        "KEYWORD",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Grid type",
                        "box",
                        &(RESTRICTED_GRID_STRUCT.type),
                        0,
                        NULL,
                        5,
                        "box", "Box grid from -0.5 to 0.5",
                        "byrange", "Specify min and max values",
                        "byspacing", "Specify grid spacings",
                        "coordbase", "Get specification from CoordBase",
                        "multipatch", "Get specification from MultiPatch");

  CCTKi_ParameterCreate("xmax",
                        "CartGrid3D",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Coordinate maximum in x-direction",
                        "1.0",
                        &(RESTRICTED_GRID_STRUCT.xmax),
                        0,
                        NULL,
                        1,
                        ":", "Anything");

  CCTKi_ParameterCreate("xmin",
                        "CartGrid3D",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Coordinate minimum in x-direction",
                        "-1.0",
                        &(RESTRICTED_GRID_STRUCT.xmin),
                        0,
                        NULL,
                        1,
                        ":", "Anything");

  CCTKi_ParameterCreate("xyzmax",
                        "CartGrid3D",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Coordinate maximum in xyz-directions",
                        "-424242",
                        &(RESTRICTED_GRID_STRUCT.xyzmax),
                        0,
                        NULL,
                        1,
                        ":", "Anything");

  CCTKi_ParameterCreate("xyzmin",
                        "CartGrid3D",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Coordinate minimum in x,y,z-directions",
                        "-424242",
                        &(RESTRICTED_GRID_STRUCT.xyzmin),
                        0,
                        NULL,
                        1,
                        ":", "Anything");

  CCTKi_ParameterCreate("ymax",
                        "CartGrid3D",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Coordinate maximum in y-direction",
                        "1.0",
                        &(RESTRICTED_GRID_STRUCT.ymax),
                        0,
                        NULL,
                        1,
                        ":", "Anything");

  CCTKi_ParameterCreate("ymin",
                        "CartGrid3D",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Coordinate minimum in y-direction",
                        "-1.0",
                        &(RESTRICTED_GRID_STRUCT.ymin),
                        0,
                        NULL,
                        1,
                        ":", "Anything");

  CCTKi_ParameterCreate("zmax",
                        "CartGrid3D",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Coordinate maximum in z-direction",
                        "1.0",
                        &(RESTRICTED_GRID_STRUCT.zmax),
                        0,
                        NULL,
                        1,
                        ":", "Anything");

  CCTKi_ParameterCreate("zmin",
                        "CartGrid3D",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Coordinate minimum in z-direction",
                        "-1.0",
                        &(RESTRICTED_GRID_STRUCT.zmin),
                        0,
                        NULL,
                        1,
                        ":", "Anything");

  CCTKi_ParameterCreate("avoid_origin",
                        "CartGrid3D",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Don't place grid points on the coordinate origin/axes",
                        "yes",
                        &(PRIVATE_CARTGRID3D_STRUCT.avoid_origin),
                        0,
                        NULL,
                        1,
                        ":", "");

  CCTKi_ParameterCreate("avoid_originx",
                        "CartGrid3D",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Don't place grid points on the x-coordinate origin/axes",
                        "yes",
                        &(PRIVATE_CARTGRID3D_STRUCT.avoid_originx),
                        0,
                        NULL,
                        1,
                        ":", "");

  CCTKi_ParameterCreate("avoid_originy",
                        "CartGrid3D",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Don't place grid points on the y-coordinate origin/axes",
                        "yes",
                        &(PRIVATE_CARTGRID3D_STRUCT.avoid_originy),
                        0,
                        NULL,
                        1,
                        ":", "");

  CCTKi_ParameterCreate("avoid_originz",
                        "CartGrid3D",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Don't place grid points on the z-coordinate origin/axes",
                        "yes",
                        &(PRIVATE_CARTGRID3D_STRUCT.avoid_originz),
                        0,
                        NULL,
                        1,
                        ":", "");

  CCTKi_ParameterCreate("no_origin",
                        "CartGrid3D",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "DEPRECATED: Don't place grid points on the coordinate origin/axes",
                        "yes",
                        &(PRIVATE_CARTGRID3D_STRUCT.no_origin),
                        0,
                        NULL,
                        1,
                        ":", "");

  CCTKi_ParameterCreate("no_originx",
                        "CartGrid3D",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "DEPRECATED: Don't place grid points on the x-coordinate origin/axes",
                        "yes",
                        &(PRIVATE_CARTGRID3D_STRUCT.no_originx),
                        0,
                        NULL,
                        1,
                        ":", "");

  CCTKi_ParameterCreate("no_originy",
                        "CartGrid3D",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "DEPRECATED: Don't place grid points on the y-coordinate origin/axes",
                        "yes",
                        &(PRIVATE_CARTGRID3D_STRUCT.no_originy),
                        0,
                        NULL,
                        1,
                        ":", "");

  CCTKi_ParameterCreate("no_originz",
                        "CartGrid3D",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "DEPRECATED: Don't place grid points on the z-coordinate origin/axes",
                        "yes",
                        &(PRIVATE_CARTGRID3D_STRUCT.no_originz),
                        0,
                        NULL,
                        1,
                        ":", "");

  CCTKi_ParameterCreate("register_default_coordinate_systems",
                        "CartGrid3D",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "register cartnd as the default coordinate systems",
                        "yes",
                        &(PRIVATE_CARTGRID3D_STRUCT.register_default_coordinate_systems),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("set_coordinate_ranges_on",
                        "CartGrid3D",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "On which grids to set the coordinate ranges",
                        "all grids",
                        &(PRIVATE_CARTGRID3D_STRUCT.set_coordinate_ranges_on),
                        0,
                        NULL,
                        3,
                        "all grids", "set ranges in local mode, on the coarsest level",
                        "all maps", "set ranges in singlemap mode, on the coarsest level",
                        "first level", "set ranges in level mode, on the first level");

  return 0;
}

int CCTKi_BindingsCartGrid3DParameterExtensions(void);
int CCTKi_BindingsCartGrid3DParameterExtensions(void)
{
  return 0;
}
