/*@@
   @file    CoordGauge_Parameters.c
   @author  Automatically generated by CreateParameterBindings.pl
   @desc
            Creates/extends parameters for this thorn
   @enddesc
 @@*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "cctk_Config.h"
#include "cctk_Constants.h"
#include "ParameterBindings.h"
#include "CParameterStructNames.h"
#include "ParameterCRestrictedADMBASE.h"

/* structure containing all private parameters of thorn CoordGauge */
struct
{
  const char * slicing_verbose;
} PRIVATE_COORDGAUGE_STRUCT;


/* structure containing all restricted parameters of thorn CoordGauge */
struct
{
  const char * lapse_list;
  const char * shift_list;
} RESTRICTED_COORDGAUGE_STRUCT;


int CCTKi_BindingsCreateCoordGaugeParameters(void);
int CCTKi_BindingsCreateCoordGaugeParameters(void)
{
  CCTKi_ParameterCreate("lapse_list",
                        "CoordGauge",
                        "STRING",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "List of allowed lapses to use",
                        "",
                        &(RESTRICTED_COORDGAUGE_STRUCT.lapse_list),
                        0,
                        NULL,
                        1,
                        ".*", "Any string");

  CCTKi_ParameterCreate("shift_list",
                        "CoordGauge",
                        "STRING",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "List of allowed shifts to use",
                        "",
                        &(RESTRICTED_COORDGAUGE_STRUCT.shift_list),
                        0,
                        NULL,
                        1,
                        ".*", "Any string");

  CCTKi_ParameterCreate("slicing_verbose",
                        "CoordGauge",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Print information on current slicing",
                        "no",
                        &(PRIVATE_COORDGAUGE_STRUCT.slicing_verbose),
                        0,
                        NULL,
                        2,
                        "yes", "print slicing info",
                        "no", "do not print slicing info");

  return 0;
}

int CCTKi_BindingsCoordGaugeParameterExtensions(void);
int CCTKi_BindingsCoordGaugeParameterExtensions(void)
{
  CCTKi_ParameterAddRange("ADMBASE",
                          "lapse_evolution_method",
                          "CoordGauge",
                          "coordgauge",
                          "Use dynamic stuff from CoordGauge");

  CCTKi_ParameterAddRange("ADMBASE",
                          "shift_evolution_method",
                          "CoordGauge",
                          "coordgauge",
                          "Use dynamic stuff from CoordGauge");

  return 0;
}
