/*@@
   @file    GenericFD_Parameters.c
   @author  Automatically generated by CreateParameterBindings.pl
   @desc
            Creates/extends parameters for this thorn
   @enddesc
 @@*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "cctk_Config.h"
#include "cctk_Constants.h"
#include "ParameterBindings.h"
#include "CParameterStructNames.h"

/* structure containing all private parameters of thorn GenericFD */
struct
{
  int dummy_parameter;
} PRIVATE_GENERICFD_STRUCT;


/* structure containing all restricted parameters of thorn GenericFD */
struct
{
  const char * jacobian_derivative_group;
  const char * jacobian_determinant_group;
  const char * jacobian_group;
  const char * jacobian_inverse_group;
  CCTK_INT allocate_genericfd_jacobian;
  CCTK_INT assume_stress_energy_state;
  CCTK_INT assume_use_jacobian;
  CCTK_INT boundary_width;
  CCTK_INT jacobian_identity_map;
  CCTK_INT stencil_width;
  CCTK_INT stencil_width_x;
  CCTK_INT stencil_width_y;
  CCTK_INT stencil_width_z;
} RESTRICTED_GENERICFD_STRUCT;


int CCTKi_BindingsCreateGenericFDParameters(void);
int CCTKi_BindingsCreateGenericFDParameters(void)
{
  CCTKi_ParameterCreate("allocate_genericfd_jacobian",
                        "GenericFD",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Allocate memory for the GenericFD Jacobian (used for benchmarks)",
                        "no",
                        &(RESTRICTED_GENERICFD_STRUCT.allocate_genericfd_jacobian),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("assume_stress_energy_state",
                        "GenericFD",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Assume stress_energy_state has a particular value",
                        "-1",
                        &(RESTRICTED_GENERICFD_STRUCT.assume_stress_energy_state),
                        0,
                        NULL,
                        2,
                        "-1", "do not assume anything",
                        "0:1", "assume off or on");

  CCTKi_ParameterCreate("assume_use_jacobian",
                        "GenericFD",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Assume use_jacobian has a particular value",
                        "-1",
                        &(RESTRICTED_GENERICFD_STRUCT.assume_use_jacobian),
                        0,
                        NULL,
                        2,
                        "-1", "do not assume anything",
                        "0:1", "assume off or on");

  CCTKi_ParameterCreate("boundary_width",
                        "GenericFD",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "width of boundary (fix later to use Cactus boundary calls) DEPRECATED",
                        "1",
                        &(RESTRICTED_GENERICFD_STRUCT.boundary_width),
                        0,
                        NULL,
                        1,
                        "-1:*", "Any integer");

  CCTKi_ParameterCreate("jacobian_derivative_group",
                        "GenericFD",
                        "STRING",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Name of group containing Jacobian derivative",
                        "",
                        &(RESTRICTED_GENERICFD_STRUCT.jacobian_derivative_group),
                        0,
                        NULL,
                        1,
                        "", "String of the form <implementation>::<groupname>");

  CCTKi_ParameterCreate("jacobian_determinant_group",
                        "GenericFD",
                        "STRING",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Name of group containing Jacobian determinant",
                        "",
                        &(RESTRICTED_GENERICFD_STRUCT.jacobian_determinant_group),
                        0,
                        NULL,
                        1,
                        "", "String of the form <implementation>::<groupname>");

  CCTKi_ParameterCreate("jacobian_group",
                        "GenericFD",
                        "STRING",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Name of group containing Jacobian",
                        "",
                        &(RESTRICTED_GENERICFD_STRUCT.jacobian_group),
                        0,
                        NULL,
                        1,
                        "", "String of the form <implementation>::<groupname>");

  CCTKi_ParameterCreate("jacobian_identity_map",
                        "GenericFD",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Map number on which the Jacobian should not be applied",
                        "-1",
                        &(RESTRICTED_GENERICFD_STRUCT.jacobian_identity_map),
                        0,
                        NULL,
                        1,
                        "-1:*", "Any integer");

  CCTKi_ParameterCreate("jacobian_inverse_group",
                        "GenericFD",
                        "STRING",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Name of group containing Jacobian inverse",
                        "",
                        &(RESTRICTED_GENERICFD_STRUCT.jacobian_inverse_group),
                        0,
                        NULL,
                        1,
                        "", "String of the form <implementation>::<groupname>");

  CCTKi_ParameterCreate("stencil_width",
                        "GenericFD",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "stencil width used near boundary DEPRECATED",
                        "-1",
                        &(RESTRICTED_GENERICFD_STRUCT.stencil_width),
                        0,
                        NULL,
                        1,
                        "-1:*", "outgoing characteristic speed > 0, default of -1 is intentionally invalid");

  CCTKi_ParameterCreate("stencil_width_x",
                        "GenericFD",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "stencil width used near boundary DEPRECATED",
                        "-1",
                        &(RESTRICTED_GENERICFD_STRUCT.stencil_width_x),
                        0,
                        NULL,
                        1,
                        "-1:*", "outgoing characteristic speed > 0, default of -1 is intentionally invalid");

  CCTKi_ParameterCreate("stencil_width_y",
                        "GenericFD",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "stencil width used near boundary DEPRECATED",
                        "-1",
                        &(RESTRICTED_GENERICFD_STRUCT.stencil_width_y),
                        0,
                        NULL,
                        1,
                        "-1:*", "outgoing characteristic speed > 0, default of -1 is intentionally invalid");

  CCTKi_ParameterCreate("stencil_width_z",
                        "GenericFD",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "stencil width used near boundary DEPRECATED",
                        "-1",
                        &(RESTRICTED_GENERICFD_STRUCT.stencil_width_z),
                        0,
                        NULL,
                        1,
                        "-1:*", "outgoing characteristic speed > 0, default of -1 is intentionally invalid");

  return 0;
}

int CCTKi_BindingsGenericFDParameterExtensions(void);
int CCTKi_BindingsGenericFDParameterExtensions(void)
{
  return 0;
}
