/*@@
   @file    ML_BSSN_Parameters.c
   @author  Automatically generated by CreateParameterBindings.pl
   @desc
            Creates/extends parameters for this thorn
   @enddesc
 @@*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "cctk_Config.h"
#include "cctk_Constants.h"
#include "ParameterBindings.h"
#include "CParameterStructNames.h"
#include "ParameterCRestrictedADMBASE.h"
#include "ParameterCRestrictedGENERICFD.h"
#include "ParameterCRestrictedMETHODOFLINES.h"

/* structure containing all private parameters of thorn ML_BSSN */
struct
{
  CCTK_REAL A_bound_limit;
  CCTK_REAL A_bound_scalar;
  CCTK_REAL A_bound_speed;
  CCTK_REAL At11_bound_limit;
  CCTK_REAL At11_bound_scalar;
  CCTK_REAL At11_bound_speed;
  CCTK_REAL At12_bound_limit;
  CCTK_REAL At12_bound_scalar;
  CCTK_REAL At12_bound_speed;
  CCTK_REAL At13_bound_limit;
  CCTK_REAL At13_bound_scalar;
  CCTK_REAL At13_bound_speed;
  CCTK_REAL At22_bound_limit;
  CCTK_REAL At22_bound_scalar;
  CCTK_REAL At22_bound_speed;
  CCTK_REAL At23_bound_limit;
  CCTK_REAL At23_bound_scalar;
  CCTK_REAL At23_bound_speed;
  CCTK_REAL At33_bound_limit;
  CCTK_REAL At33_bound_scalar;
  CCTK_REAL At33_bound_speed;
  CCTK_REAL B1_bound_limit;
  CCTK_REAL B1_bound_scalar;
  CCTK_REAL B1_bound_speed;
  CCTK_REAL B2_bound_limit;
  CCTK_REAL B2_bound_scalar;
  CCTK_REAL B2_bound_speed;
  CCTK_REAL B3_bound_limit;
  CCTK_REAL B3_bound_scalar;
  CCTK_REAL B3_bound_speed;
  CCTK_REAL ML_Gamma_bound_limit;
  CCTK_REAL ML_Gamma_bound_scalar;
  CCTK_REAL ML_Gamma_bound_speed;
  CCTK_REAL ML_curv_bound_limit;
  CCTK_REAL ML_curv_bound_scalar;
  CCTK_REAL ML_curv_bound_speed;
  CCTK_REAL ML_dtlapse_bound_limit;
  CCTK_REAL ML_dtlapse_bound_scalar;
  CCTK_REAL ML_dtlapse_bound_speed;
  CCTK_REAL ML_dtshift_bound_limit;
  CCTK_REAL ML_dtshift_bound_scalar;
  CCTK_REAL ML_dtshift_bound_speed;
  CCTK_REAL ML_lapse_bound_limit;
  CCTK_REAL ML_lapse_bound_scalar;
  CCTK_REAL ML_lapse_bound_speed;
  CCTK_REAL ML_log_confac_bound_limit;
  CCTK_REAL ML_log_confac_bound_scalar;
  CCTK_REAL ML_log_confac_bound_speed;
  CCTK_REAL ML_metric_bound_limit;
  CCTK_REAL ML_metric_bound_scalar;
  CCTK_REAL ML_metric_bound_speed;
  CCTK_REAL ML_shift_bound_limit;
  CCTK_REAL ML_shift_bound_scalar;
  CCTK_REAL ML_shift_bound_speed;
  CCTK_REAL ML_trace_curv_bound_limit;
  CCTK_REAL ML_trace_curv_bound_scalar;
  CCTK_REAL ML_trace_curv_bound_speed;
  CCTK_REAL Xt1_bound_limit;
  CCTK_REAL Xt1_bound_scalar;
  CCTK_REAL Xt1_bound_speed;
  CCTK_REAL Xt2_bound_limit;
  CCTK_REAL Xt2_bound_scalar;
  CCTK_REAL Xt2_bound_speed;
  CCTK_REAL Xt3_bound_limit;
  CCTK_REAL Xt3_bound_scalar;
  CCTK_REAL Xt3_bound_speed;
  CCTK_REAL alpha_bound_limit;
  CCTK_REAL alpha_bound_scalar;
  CCTK_REAL alpha_bound_speed;
  CCTK_REAL beta1_bound_limit;
  CCTK_REAL beta1_bound_scalar;
  CCTK_REAL beta1_bound_speed;
  CCTK_REAL beta2_bound_limit;
  CCTK_REAL beta2_bound_scalar;
  CCTK_REAL beta2_bound_speed;
  CCTK_REAL beta3_bound_limit;
  CCTK_REAL beta3_bound_scalar;
  CCTK_REAL beta3_bound_speed;
  CCTK_REAL gt11_bound_limit;
  CCTK_REAL gt11_bound_scalar;
  CCTK_REAL gt11_bound_speed;
  CCTK_REAL gt12_bound_limit;
  CCTK_REAL gt12_bound_scalar;
  CCTK_REAL gt12_bound_speed;
  CCTK_REAL gt13_bound_limit;
  CCTK_REAL gt13_bound_scalar;
  CCTK_REAL gt13_bound_speed;
  CCTK_REAL gt22_bound_limit;
  CCTK_REAL gt22_bound_scalar;
  CCTK_REAL gt22_bound_speed;
  CCTK_REAL gt23_bound_limit;
  CCTK_REAL gt23_bound_scalar;
  CCTK_REAL gt23_bound_speed;
  CCTK_REAL gt33_bound_limit;
  CCTK_REAL gt33_bound_scalar;
  CCTK_REAL gt33_bound_speed;
  CCTK_REAL phi_bound_limit;
  CCTK_REAL phi_bound_scalar;
  CCTK_REAL phi_bound_speed;
  CCTK_REAL trK_bound_limit;
  CCTK_REAL trK_bound_scalar;
  CCTK_REAL trK_bound_speed;
  const char * A_bound;
  const char * At11_bound;
  const char * At12_bound;
  const char * At13_bound;
  const char * At22_bound;
  const char * At23_bound;
  const char * At33_bound;
  const char * B1_bound;
  const char * B2_bound;
  const char * B3_bound;
  const char * ML_Gamma_bound;
  const char * ML_curv_bound;
  const char * ML_dtlapse_bound;
  const char * ML_dtshift_bound;
  const char * ML_lapse_bound;
  const char * ML_log_confac_bound;
  const char * ML_metric_bound;
  const char * ML_shift_bound;
  const char * ML_trace_curv_bound;
  const char * Xt1_bound;
  const char * Xt2_bound;
  const char * Xt3_bound;
  const char * alpha_bound;
  const char * apply_dissipation;
  const char * beta1_bound;
  const char * beta2_bound;
  const char * beta3_bound;
  const char * dt_lapse_shift_method;
  const char * gt11_bound;
  const char * gt12_bound;
  const char * gt13_bound;
  const char * gt22_bound;
  const char * gt23_bound;
  const char * gt33_bound;
  const char * my_boundary_condition;
  const char * my_initial_data;
  const char * phi_bound;
  const char * trK_bound;
} PRIVATE_ML_BSSN_STRUCT;


/* structure containing all restricted parameters of thorn ML_BSSN */
struct
{
  CCTK_REAL AlphaDriver;
  CCTK_REAL BetaDriver;
  CCTK_REAL EpsDiss;
  CCTK_REAL LapseACoeff;
  CCTK_REAL LapseAdvectionCoeff;
  CCTK_REAL MinimumLapse;
  CCTK_REAL ShiftAdvectionCoeff;
  CCTK_REAL ShiftBCoeff;
  CCTK_REAL ShiftGammaCoeff;
  CCTK_REAL SpatialBetaDriverRadius;
  CCTK_REAL SpatialShiftGammaCoeffRadius;
  CCTK_REAL harmonicF;
  const char * UseSpatialBetaDriver;
  const char * calculate_ADMBase_variables_at;
  const char * my_initial_boundary_condition;
  const char * my_rhs_boundary_condition;
  CCTK_INT ML_BSSN_Advect_calc_every;
  CCTK_INT ML_BSSN_Advect_calc_offset;
  CCTK_INT ML_BSSN_Dissipation_calc_every;
  CCTK_INT ML_BSSN_Dissipation_calc_offset;
  CCTK_INT ML_BSSN_InitGamma_calc_every;
  CCTK_INT ML_BSSN_InitGamma_calc_offset;
  CCTK_INT ML_BSSN_InitRHS_calc_every;
  CCTK_INT ML_BSSN_InitRHS_calc_offset;
  CCTK_INT ML_BSSN_MaxNumArrayEvolvedVars;
  CCTK_INT ML_BSSN_MaxNumEvolvedVars;
  CCTK_INT ML_BSSN_Minkowski_calc_every;
  CCTK_INT ML_BSSN_Minkowski_calc_offset;
  CCTK_INT ML_BSSN_RHSStaticBoundary_calc_every;
  CCTK_INT ML_BSSN_RHSStaticBoundary_calc_offset;
  CCTK_INT ML_BSSN_RHS_calc_every;
  CCTK_INT ML_BSSN_RHS_calc_offset;
  CCTK_INT ML_BSSN_boundary_calc_every;
  CCTK_INT ML_BSSN_boundary_calc_offset;
  CCTK_INT ML_BSSN_constraints_calc_every;
  CCTK_INT ML_BSSN_constraints_calc_offset;
  CCTK_INT ML_BSSN_convertFromADMBaseGamma_calc_every;
  CCTK_INT ML_BSSN_convertFromADMBaseGamma_calc_offset;
  CCTK_INT ML_BSSN_convertFromADMBase_calc_every;
  CCTK_INT ML_BSSN_convertFromADMBase_calc_offset;
  CCTK_INT ML_BSSN_convertToADMBaseDtLapseShiftBoundary_calc_every;
  CCTK_INT ML_BSSN_convertToADMBaseDtLapseShiftBoundary_calc_offset;
  CCTK_INT ML_BSSN_convertToADMBaseDtLapseShift_calc_every;
  CCTK_INT ML_BSSN_convertToADMBaseDtLapseShift_calc_offset;
  CCTK_INT ML_BSSN_convertToADMBaseFakeDtLapseShift_calc_every;
  CCTK_INT ML_BSSN_convertToADMBaseFakeDtLapseShift_calc_offset;
  CCTK_INT ML_BSSN_convertToADMBase_calc_every;
  CCTK_INT ML_BSSN_convertToADMBase_calc_offset;
  CCTK_INT ML_BSSN_enforce_calc_every;
  CCTK_INT ML_BSSN_enforce_calc_offset;
  CCTK_INT ShiftAlphaPower;
  CCTK_INT conformalMethod;
  CCTK_INT fdOrder;
  CCTK_INT harmonicN;
  CCTK_INT harmonicShift;
  CCTK_INT other_timelevels;
  CCTK_INT rhs_timelevels;
  CCTK_INT timelevels;
  CCTK_INT verbose;
} RESTRICTED_ML_BSSN_STRUCT;


int CCTKi_BindingsCreateML_BSSNParameters(void);
int CCTKi_BindingsCreateML_BSSNParameters(void)
{
  CCTKi_ParameterCreate("AlphaDriver",
                        "ML_BSSN",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "AlphaDriver",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.AlphaDriver),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("BetaDriver",
                        "ML_BSSN",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "BetaDriver",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.BetaDriver),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("EpsDiss",
                        "ML_BSSN",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Dissipation strength",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.EpsDiss),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("LapseACoeff",
                        "ML_BSSN",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Whether to evolve A in time",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.LapseACoeff),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("LapseAdvectionCoeff",
                        "ML_BSSN",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Factor in front of the lapse advection terms in 1+log",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.LapseAdvectionCoeff),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_Advect_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_Advect_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_Advect_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_Advect_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_Advect_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_Advect_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_Dissipation_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_Dissipation_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_Dissipation_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_Dissipation_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_Dissipation_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_Dissipation_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_InitGamma_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_InitGamma_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_InitGamma_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_InitGamma_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_InitGamma_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_InitGamma_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_InitRHS_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_InitRHS_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_InitRHS_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_InitRHS_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_InitRHS_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_InitRHS_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_MaxNumArrayEvolvedVars",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Number of Array evolved variables used by this thorn",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_MaxNumArrayEvolvedVars),
                        0,
                        NULL,
                        1,
                        "0:0", "Number of Array evolved variables used by this thorn");

  CCTKi_ParameterCreate("ML_BSSN_MaxNumEvolvedVars",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Number of evolved variables used by this thorn",
                        "25",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_MaxNumEvolvedVars),
                        0,
                        NULL,
                        1,
                        "25:25", "Number of evolved variables used by this thorn");

  CCTKi_ParameterCreate("ML_BSSN_Minkowski_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_Minkowski_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_Minkowski_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_Minkowski_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_Minkowski_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_Minkowski_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_RHSStaticBoundary_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_RHSStaticBoundary_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_RHSStaticBoundary_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_RHSStaticBoundary_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_RHSStaticBoundary_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_RHSStaticBoundary_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_RHS_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_RHS_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_RHS_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_RHS_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_RHS_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_RHS_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_boundary_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_boundary_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_boundary_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_boundary_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_boundary_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_boundary_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_constraints_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_constraints_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_constraints_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_constraints_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_constraints_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_constraints_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_convertFromADMBaseGamma_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_convertFromADMBaseGamma_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_convertFromADMBaseGamma_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_convertFromADMBaseGamma_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_convertFromADMBaseGamma_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_convertFromADMBaseGamma_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_convertFromADMBase_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_convertFromADMBase_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_convertFromADMBase_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_convertFromADMBase_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_convertFromADMBase_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_convertFromADMBase_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_convertToADMBaseDtLapseShiftBoundary_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_convertToADMBaseDtLapseShiftBoundary_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_convertToADMBaseDtLapseShiftBoundary_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_convertToADMBaseDtLapseShiftBoundary_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_convertToADMBaseDtLapseShiftBoundary_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_convertToADMBaseDtLapseShiftBoundary_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_convertToADMBaseDtLapseShift_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_convertToADMBaseDtLapseShift_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_convertToADMBaseDtLapseShift_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_convertToADMBaseDtLapseShift_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_convertToADMBaseDtLapseShift_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_convertToADMBaseDtLapseShift_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_convertToADMBaseFakeDtLapseShift_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_convertToADMBaseFakeDtLapseShift_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_convertToADMBaseFakeDtLapseShift_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_convertToADMBaseFakeDtLapseShift_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_convertToADMBaseFakeDtLapseShift_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_convertToADMBaseFakeDtLapseShift_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_convertToADMBase_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_convertToADMBase_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_convertToADMBase_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_convertToADMBase_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_convertToADMBase_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_convertToADMBase_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_enforce_calc_every",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_enforce_calc_every",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_enforce_calc_every),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ML_BSSN_enforce_calc_offset",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "ML_BSSN_enforce_calc_offset",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ML_BSSN_enforce_calc_offset),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("MinimumLapse",
                        "ML_BSSN",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Minimum value of the lapse function",
                        "-1",
                        &(RESTRICTED_ML_BSSN_STRUCT.MinimumLapse),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ShiftAdvectionCoeff",
                        "ML_BSSN",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Factor in front of the shift advection terms in gamma driver",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ShiftAdvectionCoeff),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ShiftAlphaPower",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "ShiftAlphaPower",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ShiftAlphaPower),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ShiftBCoeff",
                        "ML_BSSN",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Whether to evolve B^i in time",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.ShiftBCoeff),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("ShiftGammaCoeff",
                        "ML_BSSN",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "ShiftGammaCoeff",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.ShiftGammaCoeff),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("SpatialBetaDriverRadius",
                        "ML_BSSN",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Radius at which the BetaDriver starts to be reduced",
                        "1000000000000",
                        &(RESTRICTED_ML_BSSN_STRUCT.SpatialBetaDriverRadius),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("SpatialShiftGammaCoeffRadius",
                        "ML_BSSN",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Radius at which the ShiftGammaCoefficient starts to be reduced",
                        "1000000000000",
                        &(RESTRICTED_ML_BSSN_STRUCT.SpatialShiftGammaCoeffRadius),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("UseSpatialBetaDriver",
                        "ML_BSSN",
                        "KEYWORD",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "UseSpatialBetaDriver",
                        "no",
                        &(RESTRICTED_ML_BSSN_STRUCT.UseSpatialBetaDriver),
                        0,
                        NULL,
                        2,
                        "no", "no",
                        "yes", "yes");

  CCTKi_ParameterCreate("calculate_ADMBase_variables_at",
                        "ML_BSSN",
                        "KEYWORD",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "calculate_ADMBase_variables_at",
                        "MoL_PostStep",
                        &(RESTRICTED_ML_BSSN_STRUCT.calculate_ADMBase_variables_at),
                        0,
                        NULL,
                        3,
                        "MoL_PostStep", "MoL_PostStep",
                        "CCTK_EVOL", "CCTK_EVOL",
                        "CCTK_ANALYSIS", "CCTK_ANALYSIS");

  CCTKi_ParameterCreate("conformalMethod",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Treatment of conformal factor",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.conformalMethod),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("fdOrder",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "fdOrder",
                        "4",
                        &(RESTRICTED_ML_BSSN_STRUCT.fdOrder),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("harmonicF",
                        "ML_BSSN",
                        "REAL",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "d/dt alpha = - f alpha^n K   (harmonic=1, 1+log=2)",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.harmonicF),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("harmonicN",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "d/dt alpha = - f alpha^n K  (harmonic=2, 1+log=1)",
                        "2",
                        &(RESTRICTED_ML_BSSN_STRUCT.harmonicN),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("harmonicShift",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Whether to use the harmonic shift",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.harmonicShift),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("my_initial_boundary_condition",
                        "ML_BSSN",
                        "KEYWORD",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "my_initial_boundary_condition",
                        "none",
                        &(RESTRICTED_ML_BSSN_STRUCT.my_initial_boundary_condition),
                        0,
                        NULL,
                        1,
                        "none", "none");

  CCTKi_ParameterCreate("my_rhs_boundary_condition",
                        "ML_BSSN",
                        "KEYWORD",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "my_rhs_boundary_condition",
                        "none",
                        &(RESTRICTED_ML_BSSN_STRUCT.my_rhs_boundary_condition),
                        0,
                        NULL,
                        3,
                        "none", "none",
                        "static", "static",
                        "radiative", "radiative");

  CCTKi_ParameterCreate("other_timelevels",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Number of active timelevels for non-evolved grid functions",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.other_timelevels),
                        0,
                        NULL,
                        1,
                        "0:3", "");

  CCTKi_ParameterCreate("rhs_timelevels",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Number of active RHS timelevels",
                        "1",
                        &(RESTRICTED_ML_BSSN_STRUCT.rhs_timelevels),
                        0,
                        NULL,
                        1,
                        "0:3", "");

  CCTKi_ParameterCreate("timelevels",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_RECOVER,
                        "Number of active timelevels",
                        "3",
                        &(RESTRICTED_ML_BSSN_STRUCT.timelevels),
                        0,
                        NULL,
                        1,
                        "0:3", "");

  CCTKi_ParameterCreate("verbose",
                        "ML_BSSN",
                        "INT",
                        "RESTRICTED",
                        CCTK_STEERABLE_ALWAYS,
                        "verbose",
                        "0",
                        &(RESTRICTED_ML_BSSN_STRUCT.verbose),
                        0,
                        NULL,
                        1,
                        "*:*", "");

  CCTKi_ParameterCreate("A_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.A_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("A_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.A_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("A_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.A_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("A_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.A_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("At11_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.At11_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("At11_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.At11_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("At11_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.At11_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("At11_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.At11_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("At12_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.At12_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("At12_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.At12_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("At12_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.At12_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("At12_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.At12_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("At13_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.At13_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("At13_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.At13_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("At13_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.At13_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("At13_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.At13_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("At22_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.At22_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("At22_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.At22_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("At22_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.At22_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("At22_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.At22_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("At23_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.At23_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("At23_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.At23_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("At23_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.At23_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("At23_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.At23_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("At33_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.At33_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("At33_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.At33_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("At33_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.At33_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("At33_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.At33_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("B1_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.B1_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("B1_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.B1_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("B1_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.B1_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("B1_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.B1_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("B2_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.B2_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("B2_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.B2_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("B2_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.B2_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("B2_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.B2_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("B3_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.B3_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("B3_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.B3_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("B3_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.B3_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("B3_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.B3_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("ML_Gamma_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "none",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_Gamma_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("ML_Gamma_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_Gamma_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("ML_Gamma_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_Gamma_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("ML_Gamma_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_Gamma_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("ML_curv_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "none",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_curv_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("ML_curv_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_curv_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("ML_curv_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_curv_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("ML_curv_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_curv_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("ML_dtlapse_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "none",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_dtlapse_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("ML_dtlapse_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_dtlapse_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("ML_dtlapse_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_dtlapse_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("ML_dtlapse_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_dtlapse_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("ML_dtshift_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "none",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_dtshift_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("ML_dtshift_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_dtshift_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("ML_dtshift_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_dtshift_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("ML_dtshift_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_dtshift_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("ML_lapse_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "none",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_lapse_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("ML_lapse_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_lapse_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("ML_lapse_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_lapse_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("ML_lapse_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_lapse_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("ML_log_confac_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "none",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_log_confac_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("ML_log_confac_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_log_confac_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("ML_log_confac_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_log_confac_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("ML_log_confac_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_log_confac_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("ML_metric_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "none",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_metric_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("ML_metric_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_metric_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("ML_metric_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_metric_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("ML_metric_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_metric_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("ML_shift_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "none",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_shift_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("ML_shift_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_shift_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("ML_shift_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_shift_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("ML_shift_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_shift_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("ML_trace_curv_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "none",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_trace_curv_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("ML_trace_curv_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_trace_curv_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("ML_trace_curv_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_trace_curv_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("ML_trace_curv_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.ML_trace_curv_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("Xt1_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.Xt1_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("Xt1_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.Xt1_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("Xt1_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.Xt1_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("Xt1_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.Xt1_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("Xt2_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.Xt2_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("Xt2_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.Xt2_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("Xt2_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.Xt2_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("Xt2_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.Xt2_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("Xt3_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.Xt3_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("Xt3_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.Xt3_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("Xt3_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.Xt3_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("Xt3_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.Xt3_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("alpha_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.alpha_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("alpha_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.alpha_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("alpha_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.alpha_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("alpha_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.alpha_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("apply_dissipation",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Whether to apply dissipation to the RHSs",
                        "never",
                        &(PRIVATE_ML_BSSN_STRUCT.apply_dissipation),
                        0,
                        NULL,
                        2,
                        "always", "always",
                        "never", "never");

  CCTKi_ParameterCreate("beta1_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.beta1_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("beta1_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.beta1_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("beta1_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.beta1_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("beta1_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.beta1_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("beta2_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.beta2_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("beta2_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.beta2_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("beta2_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.beta2_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("beta2_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.beta2_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("beta3_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.beta3_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("beta3_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.beta3_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("beta3_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.beta3_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("beta3_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.beta3_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("dt_lapse_shift_method",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Treatment of ADMBase dtlapse and dtshift",
                        "correct",
                        &(PRIVATE_ML_BSSN_STRUCT.dt_lapse_shift_method),
                        0,
                        NULL,
                        2,
                        "correct", "correct",
                        "noLapseShiftAdvection", "noLapseShiftAdvection");

  CCTKi_ParameterCreate("gt11_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.gt11_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("gt11_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt11_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("gt11_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt11_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("gt11_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt11_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("gt12_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.gt12_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("gt12_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt12_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("gt12_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt12_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("gt12_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt12_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("gt13_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.gt13_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("gt13_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt13_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("gt13_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt13_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("gt13_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt13_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("gt22_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.gt22_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("gt22_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt22_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("gt22_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt22_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("gt22_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt22_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("gt23_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.gt23_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("gt23_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt23_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("gt23_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt23_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("gt23_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt23_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("gt33_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.gt33_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("gt33_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt33_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("gt33_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt33_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("gt33_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.gt33_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("my_boundary_condition",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "my_boundary_condition",
                        "none",
                        &(PRIVATE_ML_BSSN_STRUCT.my_boundary_condition),
                        0,
                        NULL,
                        2,
                        "none", "none",
                        "Minkowski", "Minkowski");

  CCTKi_ParameterCreate("my_initial_data",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "my_initial_data",
                        "ADMBase",
                        &(PRIVATE_ML_BSSN_STRUCT.my_initial_data),
                        0,
                        NULL,
                        2,
                        "ADMBase", "ADMBase",
                        "Minkowski", "Minkowski");

  CCTKi_ParameterCreate("phi_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.phi_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("phi_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.phi_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("phi_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.phi_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("phi_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.phi_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  CCTKi_ParameterCreate("trK_bound",
                        "ML_BSSN",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Boundary condition to implement",
                        "skip",
                        &(PRIVATE_ML_BSSN_STRUCT.trK_bound),
                        0,
                        NULL,
                        7,
                        "flat", "Flat boundary condition",
                        "none", "No boundary condition",
                        "static", "Boundaries held fixed",
                        "radiative", "Radiation boundary condition",
                        "scalar", "Dirichlet boundary condition",
                        "newrad", "Improved radiative boundary condition",
                        "skip", "skip boundary condition code");

  CCTKi_ParameterCreate("trK_bound_limit",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "limit value for r -> infinity",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.trK_bound_limit),
                        0,
                        NULL,
                        1,
                        "*:*", "value of limit value is unrestricted");

  CCTKi_ParameterCreate("trK_bound_scalar",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Dirichlet boundary value",
                        "0.",
                        &(PRIVATE_ML_BSSN_STRUCT.trK_bound_scalar),
                        0,
                        NULL,
                        1,
                        "*:*", "unrestricted");

  CCTKi_ParameterCreate("trK_bound_speed",
                        "ML_BSSN",
                        "REAL",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "characteristic speed at boundary",
                        "1.",
                        &(PRIVATE_ML_BSSN_STRUCT.trK_bound_speed),
                        0,
                        NULL,
                        1,
                        "0:*", "outgoing characteristic speed > 0");

  return 0;
}

int CCTKi_BindingsML_BSSNParameterExtensions(void);
int CCTKi_BindingsML_BSSNParameterExtensions(void)
{
  CCTKi_ParameterAddRange("ADMBASE",
                          "evolution_method",
                          "ML_BSSN",
                          "ML_BSSN",
                          "");

  CCTKi_ParameterAddRange("ADMBASE",
                          "lapse_evolution_method",
                          "ML_BSSN",
                          "ML_BSSN",
                          "");

  CCTKi_ParameterAddRange("ADMBASE",
                          "shift_evolution_method",
                          "ML_BSSN",
                          "ML_BSSN",
                          "");

  CCTKi_ParameterAddRange("ADMBASE",
                          "dtlapse_evolution_method",
                          "ML_BSSN",
                          "ML_BSSN",
                          "");

  CCTKi_ParameterAddRange("ADMBASE",
                          "dtshift_evolution_method",
                          "ML_BSSN",
                          "ML_BSSN",
                          "");

  CCTKi_ParameterAccumulatorBase("ML_BSSN",
                          "ML_BSSN_MaxNumArrayEvolvedVars",
                          "MethodofLines",
                          "MoL_Num_ArrayEvolved_Vars");

  CCTKi_ParameterAccumulatorBase("ML_BSSN",
                          "ML_BSSN_MaxNumEvolvedVars",
                          "MethodofLines",
                          "MoL_Num_Evolved_Vars");

  return 0;
}
