/*@@
   @file    PUGH_Parameters.c
   @author  Automatically generated by CreateParameterBindings.pl
   @desc
            Creates/extends parameters for this thorn
   @enddesc
 @@*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "cctk_Config.h"
#include "cctk_Constants.h"
#include "ParameterBindings.h"
#include "CParameterStructNames.h"
#include "ParameterCRestrictedCACTUS.h"

/* structure containing all private parameters of thorn PUGH */
struct
{
  const char * info;
  const char * initialize_memory;
  const char * partition;
  const char * partition_1d_x;
  const char * partition_2d_x;
  const char * partition_2d_y;
  const char * partition_3d_x;
  const char * partition_3d_y;
  const char * partition_3d_z;
  const char * physical2logical;
  const char * processor_topology;
  const char * storage_verbose;
  CCTK_INT cacheline_mult;
  CCTK_INT enable_all_storage;
  CCTK_INT ghost_size;
  CCTK_INT ghost_size_x;
  CCTK_INT ghost_size_y;
  CCTK_INT ghost_size_z;
  CCTK_INT global_nsize;
  CCTK_INT global_nx;
  CCTK_INT global_ny;
  CCTK_INT global_nz;
  CCTK_INT local_nsize;
  CCTK_INT local_nx;
  CCTK_INT local_ny;
  CCTK_INT local_nz;
  CCTK_INT local_size_includes_ghosts;
  CCTK_INT overloadabort;
  CCTK_INT overloadarraygroupsizeb;
  CCTK_INT overloadbarrier;
  CCTK_INT overloaddisablegroupcomm;
  CCTK_INT overloaddisablegroupstorage;
  CCTK_INT overloadenablegroupcomm;
  CCTK_INT overloadenablegroupstorage;
  CCTK_INT overloadevolve;
  CCTK_INT overloadexit;
  CCTK_INT overloadgroupdynamicdata;
  CCTK_INT overloadmyproc;
  CCTK_INT overloadnprocs;
  CCTK_INT overloadparallelinit;
  CCTK_INT overloadquerygroupstorageb;
  CCTK_INT overloadsyncgroup;
  CCTK_INT overloadsyncgroupsbydiri;
  CCTK_INT padding_active;
  CCTK_INT padding_address_spacing;
  CCTK_INT padding_cacheline_bits;
  CCTK_INT padding_size;
  CCTK_INT processor_topology_1d_x;
  CCTK_INT processor_topology_2d_x;
  CCTK_INT processor_topology_2d_y;
  CCTK_INT processor_topology_3d_x;
  CCTK_INT processor_topology_3d_y;
  CCTK_INT processor_topology_3d_z;
  CCTK_INT storage_report_every;
  CCTK_INT timer_output;
} PRIVATE_PUGH_STRUCT;


/* structure containing all restricted parameters of thorn PUGH */
struct
{
  CCTK_INT periodic;
  CCTK_INT periodic_x;
  CCTK_INT periodic_y;
  CCTK_INT periodic_z;
} RESTRICTED_DRIVER_STRUCT;


int CCTKi_BindingsCreatePUGHParameters(void);
int CCTKi_BindingsCreatePUGHParameters(void)
{
  CCTKi_ParameterCreate("periodic",
                        "PUGH",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Periodic boundary conditions",
                        "no",
                        &(RESTRICTED_DRIVER_STRUCT.periodic),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("periodic_x",
                        "PUGH",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Periodic boundary conditions in x-direction",
                        "yes",
                        &(RESTRICTED_DRIVER_STRUCT.periodic_x),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("periodic_y",
                        "PUGH",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Periodic boundary conditions in y-direction",
                        "yes",
                        &(RESTRICTED_DRIVER_STRUCT.periodic_y),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("periodic_z",
                        "PUGH",
                        "BOOLEAN",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "Periodic boundary conditions in z-direction",
                        "yes",
                        &(RESTRICTED_DRIVER_STRUCT.periodic_z),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("cacheline_mult",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Multiplier for cacheline number",
                        "4001",
                        &(PRIVATE_PUGH_STRUCT.cacheline_mult),
                        0,
                        NULL,
                        1,
                        "0:*",  "Any positive number");

  CCTKi_ParameterCreate("enable_all_storage",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Enable storage for all GFs?",
                        "no",
                        &(PRIVATE_PUGH_STRUCT.enable_all_storage),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("ghost_size",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The width of the ghost zone in each direction",
                        "-1",
                        &(PRIVATE_PUGH_STRUCT.ghost_size),
                        0,
                        NULL,
                        1,
                        "-1:*", "Any positive number to override the ghost_size_[xyz] parameters");

  CCTKi_ParameterCreate("ghost_size_x",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The width of the ghost zone in the x direction",
                        "1",
                        &(PRIVATE_PUGH_STRUCT.ghost_size_x),
                        0,
                        NULL,
                        1,
                        "0:*", "Must be a positive integer");

  CCTKi_ParameterCreate("ghost_size_y",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The width of the ghost zone in the y direction",
                        "1",
                        &(PRIVATE_PUGH_STRUCT.ghost_size_y),
                        0,
                        NULL,
                        1,
                        "0:*", "Must be a positive integer");

  CCTKi_ParameterCreate("ghost_size_z",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The width of the ghost zone in the z direction",
                        "1",
                        &(PRIVATE_PUGH_STRUCT.ghost_size_z),
                        0,
                        NULL,
                        1,
                        "0:*", "Must be a positive integer");

  CCTKi_ParameterCreate("global_nsize",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The size of the grid in each spatial direction",
                        "-1",
                        &(PRIVATE_PUGH_STRUCT.global_nsize),
                        0,
                        NULL,
                        1,
                        "-1:*", "Grid of this size in each dir distributed across all processors");

  CCTKi_ParameterCreate("global_nx",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The size of the grid in the x direction",
                        "10",
                        &(PRIVATE_PUGH_STRUCT.global_nx),
                        0,
                        NULL,
                        1,
                        "0:*", "Grid of this size distributed across all processors");

  CCTKi_ParameterCreate("global_ny",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The size of the grid in the y direction",
                        "10",
                        &(PRIVATE_PUGH_STRUCT.global_ny),
                        0,
                        NULL,
                        1,
                        "0:*", "Grid of this size distributed across all processors");

  CCTKi_ParameterCreate("global_nz",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The size of the grid in the z direction",
                        "10",
                        &(PRIVATE_PUGH_STRUCT.global_nz),
                        0,
                        NULL,
                        1,
                        "0:*", "Grid of this size distributed across all processors");

  CCTKi_ParameterCreate("info",
                        "PUGH",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Provide additional information about what PUGH is doing",
                        "none",
                        &(PRIVATE_PUGH_STRUCT.info),
                        0,
                        NULL,
                        2,
                        "none", "No extra information",
                        "load", "Load on each processor");

  CCTKi_ParameterCreate("initialize_memory",
                        "PUGH",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "How to initialize memory for grid variables at allocation time",
                        "none",
                        &(PRIVATE_PUGH_STRUCT.initialize_memory),
                        0,
                        NULL,
                        3,
                        "none", "Do not initialize storage for allocated grid variables (default)",
                        "zero", "Zero out all elements of all allocated grid variables",
                        "NaN", "Set all elements of allocated floating point grid variables to Not-a-Number values");

  CCTKi_ParameterCreate("local_nsize",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The size of the grid in each spatial direction",
                        "-1",
                        &(PRIVATE_PUGH_STRUCT.local_nsize),
                        0,
                        NULL,
                        1,
                        "-1:*", "Grid of this size in each dir on each processor");

  CCTKi_ParameterCreate("local_nx",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The size of the grid in the x direction",
                        "-1",
                        &(PRIVATE_PUGH_STRUCT.local_nx),
                        0,
                        NULL,
                        1,
                        "-1:*", "Grid of this size on each processor");

  CCTKi_ParameterCreate("local_ny",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The size of the grid in the y direction",
                        "-1",
                        &(PRIVATE_PUGH_STRUCT.local_ny),
                        0,
                        NULL,
                        1,
                        "-1:*", "Grid of this size on each processor");

  CCTKi_ParameterCreate("local_nz",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "The size of the grid in the z direction",
                        "-1",
                        &(PRIVATE_PUGH_STRUCT.local_nz),
                        0,
                        NULL,
                        1,
                        "-1:*", "Grid of this size on each processor");

  CCTKi_ParameterCreate("local_size_includes_ghosts",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Does the local grid size include the ghost zones?",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.local_size_includes_ghosts),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadabort",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload Abort driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadabort),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadarraygroupsizeb",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload ArrayGroupSizeB driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadarraygroupsizeb),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadbarrier",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload Barrier driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadbarrier),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloaddisablegroupcomm",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload DisableGroupComm driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloaddisablegroupcomm),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloaddisablegroupstorage",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload DisableGroupStorage driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloaddisablegroupstorage),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadenablegroupcomm",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload EnableGroupComm driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadenablegroupcomm),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadenablegroupstorage",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload EnableGroupStorage driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadenablegroupstorage),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadevolve",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload Evolve driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadevolve),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadexit",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload Exit driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadexit),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadgroupdynamicdata",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload GroupDynamicData driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadgroupdynamicdata),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadmyproc",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload MyProc driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadmyproc),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadnprocs",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload nProcs driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadnprocs),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadparallelinit",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload ParallelInit driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadparallelinit),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadquerygroupstorageb",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload QueryGroupStorageB driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadquerygroupstorageb),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadsyncgroup",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload SyncGroup driver function",
                        "no",
                        &(PRIVATE_PUGH_STRUCT.overloadsyncgroup),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("overloadsyncgroupsbydiri",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Overload SyncGroupsByDirI driver function",
                        "yes",
                        &(PRIVATE_PUGH_STRUCT.overloadsyncgroupsbydiri),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("padding_active",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Pad 3D arrays so they line up on cache lines?",
                        "no",
                        &(PRIVATE_PUGH_STRUCT.padding_active),
                        0,
                        NULL,
                        0);

  CCTKi_ParameterCreate("padding_address_spacing",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Number of CCTK_REALs to space starting addresses in lowest padding_cacheline_bits bits",
                        "24",
                        &(PRIVATE_PUGH_STRUCT.padding_address_spacing),
                        0,
                        NULL,
                        1,
                        "0:*",  "Any positive number");

  CCTKi_ParameterCreate("padding_cacheline_bits",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Number of bits which have to be unique to pad properly for cache lines",
                        "12",
                        &(PRIVATE_PUGH_STRUCT.padding_cacheline_bits),
                        0,
                        NULL,
                        1,
                        "1:*", "Any positive number");

  CCTKi_ParameterCreate("padding_size",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "How many CCTK_REALs to pad by; we have to noodle around with the starting address, so if there isn't enough space we may not be able to pad",
                        "4112",
                        &(PRIVATE_PUGH_STRUCT.padding_size),
                        0,
                        NULL,
                        1,
                        "0:*",  "Any positive number");

  CCTKi_ParameterCreate("partition",
                        "PUGH",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Is the partition manual",
                        "automatic",
                        &(PRIVATE_PUGH_STRUCT.partition),
                        0,
                        NULL,
                        2,
                        "automatic", "even",
                        "manual", "specified by partition_XYZ ..");

  CCTKi_ParameterCreate("partition_1d_x",
                        "PUGH",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Tells how to partition on direction X",
                        "",
                        &(PRIVATE_PUGH_STRUCT.partition_1d_x),
                        0,
                        NULL,
                        1,
                        ".*", "A regex which matches anything");

  CCTKi_ParameterCreate("partition_2d_x",
                        "PUGH",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Tells how to partition on direction X",
                        "",
                        &(PRIVATE_PUGH_STRUCT.partition_2d_x),
                        0,
                        NULL,
                        1,
                        ".*", "A regex which matches anything");

  CCTKi_ParameterCreate("partition_2d_y",
                        "PUGH",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Tells how to partition on direction y",
                        "",
                        &(PRIVATE_PUGH_STRUCT.partition_2d_y),
                        0,
                        NULL,
                        1,
                        ".*", "A regex which matches anything");

  CCTKi_ParameterCreate("partition_3d_x",
                        "PUGH",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Tells how to partition on direction X",
                        "",
                        &(PRIVATE_PUGH_STRUCT.partition_3d_x),
                        0,
                        NULL,
                        1,
                        ".*", "A regex which matches anything");

  CCTKi_ParameterCreate("partition_3d_y",
                        "PUGH",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Tells how to partition on direction y",
                        "",
                        &(PRIVATE_PUGH_STRUCT.partition_3d_y),
                        0,
                        NULL,
                        1,
                        ".*", "A regex which matches anything");

  CCTKi_ParameterCreate("partition_3d_z",
                        "PUGH",
                        "STRING",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Tells how to partition on direction z",
                        "",
                        &(PRIVATE_PUGH_STRUCT.partition_3d_z),
                        0,
                        NULL,
                        1,
                        ".*", "A regex which matches anything");

  CCTKi_ParameterCreate("physical2logical",
                        "PUGH",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Physical process to logical process mapping method to use",
                        "direct",
                        &(PRIVATE_PUGH_STRUCT.physical2logical),
                        0,
                        NULL,
                        2,
                        "direct", "Maps MPI IDs directly to IJKs",
                        "example", "Maps MPI IDs directly to IJKs using a lookup table");

  CCTKi_ParameterCreate("processor_topology",
                        "PUGH",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "How to determine the processor topology",
                        "automatic",
                        &(PRIVATE_PUGH_STRUCT.processor_topology),
                        0,
                        NULL,
                        3,
                        "manual", "Specified by proc_top_nx etc",
                        "automatic", "Automatically generated",
                        "automatic_old", "Automatically generated (old method)");

  CCTKi_ParameterCreate("processor_topology_1d_x",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Number of processors in X direction",
                        "0",
                        &(PRIVATE_PUGH_STRUCT.processor_topology_1d_x),
                        0,
                        NULL,
                        1,
                        "0:*", "See proc_topology");

  CCTKi_ParameterCreate("processor_topology_2d_x",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Number of processors in X direction",
                        "0",
                        &(PRIVATE_PUGH_STRUCT.processor_topology_2d_x),
                        0,
                        NULL,
                        1,
                        "0:*", "See proc_topology");

  CCTKi_ParameterCreate("processor_topology_2d_y",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Number of processors in Y direction",
                        "0",
                        &(PRIVATE_PUGH_STRUCT.processor_topology_2d_y),
                        0,
                        NULL,
                        1,
                        "0:*", "See proc_topology");

  CCTKi_ParameterCreate("processor_topology_3d_x",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Number of processors in X direction",
                        "0",
                        &(PRIVATE_PUGH_STRUCT.processor_topology_3d_x),
                        0,
                        NULL,
                        1,
                        "0:*", "See proc_topology");

  CCTKi_ParameterCreate("processor_topology_3d_y",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Number of processors in Y direction",
                        "0",
                        &(PRIVATE_PUGH_STRUCT.processor_topology_3d_y),
                        0,
                        NULL,
                        1,
                        "0:*", "See proc_topology");

  CCTKi_ParameterCreate("processor_topology_3d_z",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_RECOVER,
                        "Number of processors in Z direction",
                        "0",
                        &(PRIVATE_PUGH_STRUCT.processor_topology_3d_z),
                        0,
                        NULL,
                        1,
                        "0:*", "See proc_topology");

  CCTKi_ParameterCreate("storage_report_every",
                        "PUGH",
                        "INT",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "How often to provide a report on storage information",
                        "0",
                        &(PRIVATE_PUGH_STRUCT.storage_report_every),
                        0,
                        NULL,
                        2,
                        "0:0", "Never report",
                        "1:*", "Report at intervals");

  CCTKi_ParameterCreate("storage_verbose",
                        "PUGH",
                        "KEYWORD",
                        "PRIVATE",
                        CCTK_STEERABLE_ALWAYS,
                        "Report on memory assignment",
                        "no",
                        &(PRIVATE_PUGH_STRUCT.storage_verbose),
                        0,
                        NULL,
                        3,
                        "yes", "Standard storage information",
                        "report", "Provide a report of storage every storage_report_every iterations and at termination",
                        "no", "Provide no information");

  CCTKi_ParameterCreate("timer_output",
                        "PUGH",
                        "BOOLEAN",
                        "PRIVATE",
                        CCTK_STEERABLE_NEVER,
                        "Print time spent in communication",
                        "no",
                        &(PRIVATE_PUGH_STRUCT.timer_output),
                        0,
                        NULL,
                        0);

  return 0;
}

int CCTKi_BindingsPUGHParameterExtensions(void);
int CCTKi_BindingsPUGHParameterExtensions(void)
{
  return 0;
}
