/*@@
   @file    StaticConformal_Parameters.c
   @author  Automatically generated by CreateParameterBindings.pl
   @desc
            Creates/extends parameters for this thorn
   @enddesc
 @@*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include "cctk_Config.h"
#include "cctk_Constants.h"
#include "ParameterBindings.h"
#include "CParameterStructNames.h"
#include "ParameterCRestrictedADMBASE.h"

/* structure containing all private parameters of thorn StaticConformal */
struct
{
  int dummy_parameter;
} PRIVATE_STATICCONFORMAL_STRUCT;


/* structure containing all restricted parameters of thorn StaticConformal */
struct
{
  const char * conformal_storage;
} RESTRICTED_STATICCONFORMAL_STRUCT;


int CCTKi_BindingsCreateStaticConformalParameters(void);
int CCTKi_BindingsCreateStaticConformalParameters(void)
{
  CCTKi_ParameterCreate("conformal_storage",
                        "StaticConformal",
                        "KEYWORD",
                        "RESTRICTED",
                        CCTK_STEERABLE_NEVER,
                        "How much conformal storage do we have ?",
                        "factor+derivs+2nd derivs",
                        &(RESTRICTED_STATICCONFORMAL_STRUCT.conformal_storage),
                        0,
                        NULL,
                        3,
                        "factor", "Just the conformal factor",
                        "factor+derivs", "Conformal factor plus first derivatives",
                        "factor+derivs+2nd derivs", "Conformal factor plus first and second derivatives");

  return 0;
}

int CCTKi_BindingsStaticConformalParameterExtensions(void);
int CCTKi_BindingsStaticConformalParameterExtensions(void)
{
  CCTKi_ParameterAddRange("ADMBASE",
                          "metric_type",
                          "StaticConformal",
                          "static conformal",
                          "Metric is conformal with static conformal factor, extrinsic curvature is physical");

  return 0;
}
