/*@@
   @file    ADMBase.c
   @author  Automatically generated by GridFuncStuff.pl
   @desc
            Creates the CCTK variables for thorn ADMBase
   @enddesc
 @@*/



#include <stddef.h>

#ifdef SPEC 
#include "ADMBase/cctk.h" 
#define THORN_DIR "ADMBase" 
#else 
#include "ADMBase/cctk.h"
#endif /* END SPEC */ 
#ifdef SPEC 
#include "ADMBase/cctk_Arguments.h" 
#else 
#include "ADMBase/cctk_Arguments.h"
#endif /* END SPEC */ 
#include "cctk_Parameter.h"
#include "cctk_WarnLevel.h"
#include "cctki_Groups.h"
#include "cctki_FortranWrappers.h"
#include "ADMBase/cctk_ScheduleFunctions.h"

int CactusBindingsVariables_ADMBase_Initialise(void);
static int CCTKi_BindingsFortranWrapperADMBase(void *_GH, void *fpointer);

static int CCTKi_BindingsFortranWrapperADMBase(void *_GH, void *fpointer)
{
  cGH const *const GH = _GH;
  const int _cctk_zero = 0;
  void (*function)(ADMBASE_C2F_PROTO);
  DECLARE_ADMBASE_C2F
  INITIALISE_ADMBASE_C2F
  (void) (_cctk_zero + 0);

  function = (void (*) (ADMBASE_C2F_PROTO)) fpointer;
  function (PASS_ADMBASE_C2F (GH));

  return (0);
}

int CactusBindingsVariables_ADMBase_Initialise(void)
{
  const char * warn_mixeddim_gfs = "";
  int warn_mixeddim = 0;
  const CCTK_INT *allow_mixeddim_gfs;


  allow_mixeddim_gfs = CCTK_ParameterGet ("allow_mixeddim_gfs", "Cactus", 0);

  if (CCTKi_CreateGroup ("SHIFT_STATE", "ADMBASE", "ADMBASE",
                         "SCALAR", "INT", "PUBLIC",
                         0, 1,
                         "CONSTANT",
                         "", "",
                         "",
                         NULL,
                         1,
                         "shift_state") == 1)
  {
    warn_mixeddim_gfs = "shift_state";
    warn_mixeddim = 0;
  }
  if (CCTKi_CreateGroup ("DTLAPSE_STATE", "ADMBASE", "ADMBASE",
                         "SCALAR", "INT", "PUBLIC",
                         0, 1,
                         "CONSTANT",
                         "", "",
                         "",
                         NULL,
                         1,
                         "dtlapse_state") == 1)
  {
    warn_mixeddim_gfs = "dtlapse_state";
    warn_mixeddim = 0;
  }
  if (CCTKi_CreateGroup ("DTSHIFT_STATE", "ADMBASE", "ADMBASE",
                         "SCALAR", "INT", "PUBLIC",
                         0, 1,
                         "CONSTANT",
                         "", "",
                         "",
                         NULL,
                         1,
                         "dtshift_state") == 1)
  {
    warn_mixeddim_gfs = "dtshift_state";
    warn_mixeddim = 0;
  }
  if (CCTKi_CreateGroup ("METRIC", "ADMBASE", "ADMBASE",
                         "GF", "REAL", "PUBLIC",
                         3, 3,
                         "DEFAULT",
                         "", "",
                         "tensortypealias=\"DD_sym\" ProlongationParameter=\"ADMBase::metric_prolongation_type\"",
                         NULL,
                         6,
                         "gxx",
                         "gxy",
                         "gxz",
                         "gyy",
                         "gyz",
                         "gzz") == 1)
  {
    warn_mixeddim_gfs = "metric";
    warn_mixeddim = 3;
  }
  if (CCTKi_CreateGroup ("CURV", "ADMBASE", "ADMBASE",
                         "GF", "REAL", "PUBLIC",
                         3, 3,
                         "DEFAULT",
                         "", "",
                         "tensortypealias=\"DD_sym\" ProlongationParameter=\"ADMBase::metric_prolongation_type\"",
                         NULL,
                         6,
                         "kxx",
                         "kxy",
                         "kxz",
                         "kyy",
                         "kyz",
                         "kzz") == 1)
  {
    warn_mixeddim_gfs = "curv";
    warn_mixeddim = 3;
  }
  if (CCTKi_CreateGroup ("LAPSE", "ADMBASE", "ADMBASE",
                         "GF", "REAL", "PUBLIC",
                         3, 3,
                         "DEFAULT",
                         "", "",
                         "tensortypealias=\"Scalar\" ProlongationParameter=\"ADMBase::lapse_prolongation_type\"",
                         NULL,
                         1,
                         "alp") == 1)
  {
    warn_mixeddim_gfs = "lapse";
    warn_mixeddim = 3;
  }
  if (CCTKi_CreateGroup ("SHIFT", "ADMBASE", "ADMBASE",
                         "GF", "REAL", "PUBLIC",
                         3, 3,
                         "DEFAULT",
                         "", "",
                         "tensortypealias=\"U\" ProlongationParameter=\"ADMBase::shift_prolongation_type\"",
                         NULL,
                         3,
                         "betax",
                         "betay",
                         "betaz") == 1)
  {
    warn_mixeddim_gfs = "shift";
    warn_mixeddim = 3;
  }
  if (CCTKi_CreateGroup ("DTLAPSE", "ADMBASE", "ADMBASE",
                         "GF", "REAL", "PUBLIC",
                         3, 3,
                         "DEFAULT",
                         "", "",
                         "tensortypealias=\"Scalar\" ProlongationParameter=\"ADMBase::lapse_prolongation_type\"",
                         NULL,
                         1,
                         "dtalp") == 1)
  {
    warn_mixeddim_gfs = "dtlapse";
    warn_mixeddim = 3;
  }
  if (CCTKi_CreateGroup ("DTSHIFT", "ADMBASE", "ADMBASE",
                         "GF", "REAL", "PUBLIC",
                         3, 3,
                         "DEFAULT",
                         "", "",
                         "tensortypealias=\"U\" ProlongationParameter=\"ADMBase::shift_prolongation_type\"",
                         NULL,
                         3,
                         "dtbetax",
                         "dtbetay",
                         "dtbetaz") == 1)
  {
    warn_mixeddim_gfs = "dtshift";
    warn_mixeddim = 3;
  }

  if (*warn_mixeddim_gfs)
  {
    if (allow_mixeddim_gfs && *allow_mixeddim_gfs)
    {
      CCTK_VWarn (2, __LINE__, __FILE__, "Cactus",
                  "CCTKi_CreateGroup: Working dimension already set, "
                  "creating GF group '%s' with different dimension %d",
                  warn_mixeddim_gfs, warn_mixeddim);
    }
    else
    {
      CCTK_VWarn (0, __LINE__, __FILE__, "Cactus",
                  "CCTKi_CreateGroup: Working dimension already set, "
                  "cannot create GF group '%s' with dimension %d",
                  warn_mixeddim_gfs, warn_mixeddim);
    }
 }

  CCTKi_RegisterFortranWrapper("ADMBase", CCTKi_BindingsFortranWrapperADMBase);

  return 0;
}
