/*@@
   @file    GenericFD.c
   @author  Automatically generated by GridFuncStuff.pl
   @desc
            Creates the CCTK variables for thorn GenericFD
   @enddesc
 @@*/



#include <stddef.h>

#ifdef SPEC 
#include "GenericFD/cctk.h" 
#define THORN_DIR "GenericFD" 
#else 
#include "GenericFD/cctk.h"
#endif /* END SPEC */ 
#ifdef SPEC 
#include "GenericFD/cctk_Arguments.h" 
#else 
#include "GenericFD/cctk_Arguments.h"
#endif /* END SPEC */ 
#include "cctk_Parameter.h"
#include "cctk_WarnLevel.h"
#include "cctki_Groups.h"
#include "cctki_FortranWrappers.h"
#include "GenericFD/cctk_ScheduleFunctions.h"

int CactusBindingsVariables_GenericFD_Initialise(void);
static int CCTKi_BindingsFortranWrapperGenericFD(void *_GH, void *fpointer);

static int CCTKi_BindingsFortranWrapperGenericFD(void *_GH, void *fpointer)
{
  cGH const *const GH = _GH;
  const int _cctk_zero = 0;
  void (*function)(GENERICFD_C2F_PROTO);
  DECLARE_GENERICFD_C2F
  INITIALISE_GENERICFD_C2F
  (void) (_cctk_zero + 0);

  function = (void (*) (GENERICFD_C2F_PROTO)) fpointer;
  function (PASS_GENERICFD_C2F (GH));

  return (0);
}

int CactusBindingsVariables_GenericFD_Initialise(void)
{
  const char * warn_mixeddim_gfs = "";
  int warn_mixeddim = 0;
  const CCTK_INT *allow_mixeddim_gfs;


  allow_mixeddim_gfs = CCTK_ParameterGet ("allow_mixeddim_gfs", "Cactus", 0);

  if (CCTKi_CreateGroup ("JACOBIAN", "GENERICFD", "GENERICFD",
                         "GF", "REAL", "PRIVATE",
                         3, 1,
                         "DEFAULT",
                         "", "",
                         "checkpoint=\"no\" prolongation=\"none\"",
                         NULL,
                         9,
                         "J11",
                         "J12",
                         "J13",
                         "J21",
                         "J22",
                         "J23",
                         "J31",
                         "J32",
                         "J33") == 1)
  {
    warn_mixeddim_gfs = "jacobian";
    warn_mixeddim = 3;
  }
  if (CCTKi_CreateGroup ("JACOBIAN2", "GENERICFD", "GENERICFD",
                         "GF", "REAL", "PRIVATE",
                         3, 1,
                         "DEFAULT",
                         "", "",
                         "checkpoint=\"no\" prolongation=\"none\"",
                         NULL,
                         18,
                         "dJ111",
                         "dJ112",
                         "dJ113",
                         "dJ122",
                         "dJ123",
                         "dJ133",
                         "dJ211",
                         "dJ212",
                         "dJ213",
                         "dJ222",
                         "dJ223",
                         "dJ233",
                         "dJ311",
                         "dJ312",
                         "dJ313",
                         "dJ322",
                         "dJ323",
                         "dJ333") == 1)
  {
    warn_mixeddim_gfs = "jacobian2";
    warn_mixeddim = 3;
  }

  if (*warn_mixeddim_gfs)
  {
    if (allow_mixeddim_gfs && *allow_mixeddim_gfs)
    {
      CCTK_VWarn (2, __LINE__, __FILE__, "Cactus",
                  "CCTKi_CreateGroup: Working dimension already set, "
                  "creating GF group '%s' with different dimension %d",
                  warn_mixeddim_gfs, warn_mixeddim);
    }
    else
    {
      CCTK_VWarn (0, __LINE__, __FILE__, "Cactus",
                  "CCTKi_CreateGroup: Working dimension already set, "
                  "cannot create GF group '%s' with dimension %d",
                  warn_mixeddim_gfs, warn_mixeddim);
    }
 }

  CCTKi_RegisterFortranWrapper("GenericFD", CCTKi_BindingsFortranWrapperGenericFD);

  return 0;
}
