/*@@
   @file    Time.c
   @author  Automatically generated by GridFuncStuff.pl
   @desc
            Creates the CCTK variables for thorn Time
   @enddesc
 @@*/



#include <stddef.h>

#ifdef SPEC 
#include "Time/cctk.h" 
#define THORN_DIR "Time" 
#else 
#include "Time/cctk.h"
#endif /* END SPEC */ 
#ifdef SPEC 
#include "Time/cctk_Arguments.h" 
#else 
#include "Time/cctk_Arguments.h"
#endif /* END SPEC */ 
#include "cctk_Parameter.h"
#include "cctk_WarnLevel.h"
#include "cctki_Groups.h"
#include "cctki_FortranWrappers.h"
#include "Time/cctk_ScheduleFunctions.h"

int CactusBindingsVariables_Time_Initialise(void);
static int CCTKi_BindingsFortranWrapperTime(void *_GH, void *fpointer);

static int CCTKi_BindingsFortranWrapperTime(void *_GH, void *fpointer)
{
  cGH const *const GH = _GH;
  const int _cctk_zero = 0;
  void (*function)(TIME_C2F_PROTO);
  DECLARE_TIME_C2F
  INITIALISE_TIME_C2F
  (void) (_cctk_zero + 0);

  function = (void (*) (TIME_C2F_PROTO)) fpointer;
  function (PASS_TIME_C2F (GH));

  return (0);
}

int CactusBindingsVariables_Time_Initialise(void)
{
  const char * warn_mixeddim_gfs = "";
  int warn_mixeddim = 0;
  const CCTK_INT *allow_mixeddim_gfs;


  allow_mixeddim_gfs = CCTK_ParameterGet ("allow_mixeddim_gfs", "Cactus", 0);

  if (CCTKi_CreateGroup ("SPEEDVARS", "TIME", "TIME",
                         "SCALAR", "REAL", "PUBLIC",
                         0, 1,
                         "CONSTANT",
                         "", "",
                         "",
                         NULL,
                         2,
                         "courant_wave_speed",
                         "courant_min_time") == 1)
  {
    warn_mixeddim_gfs = "speedvars";
    warn_mixeddim = 0;
  }
  if (CCTKi_CreateGroup ("COURANTTEMPS", "TIME", "TIME",
                         "SCALAR", "REAL", "PRIVATE",
                         0, 1,
                         "CONSTANT",
                         "", "",
                         "",
                         NULL,
                         1,
                         "courant_dt") == 1)
  {
    warn_mixeddim_gfs = "couranttemps";
    warn_mixeddim = 0;
  }

  if (*warn_mixeddim_gfs)
  {
    if (allow_mixeddim_gfs && *allow_mixeddim_gfs)
    {
      CCTK_VWarn (2, __LINE__, __FILE__, "Cactus",
                  "CCTKi_CreateGroup: Working dimension already set, "
                  "creating GF group '%s' with different dimension %d",
                  warn_mixeddim_gfs, warn_mixeddim);
    }
    else
    {
      CCTK_VWarn (0, __LINE__, __FILE__, "Cactus",
                  "CCTKi_CreateGroup: Working dimension already set, "
                  "cannot create GF group '%s' with dimension %d",
                  warn_mixeddim_gfs, warn_mixeddim);
    }
 }

  CCTKi_RegisterFortranWrapper("Time", CCTKi_BindingsFortranWrapperTime);

  return 0;
}
