/*@@
  @header   CDXCDK_guts.h
  @date     August 98
  @author   Gabrielle Allen
  @desc
  Macro to calculate the first conformal derivatives of the 
  extrinsic curvature with respect to x
  @enddesc
@@*/

#ifndef CDXCDK_GUTS
#define CDXCDK_GUTS

#include "DXDK_guts.h"
#include "CHR2_guts.h"

#ifdef FCODE 

      CDXCDK_CDXCDKXX = DXDK_DXDKXX - 2D0*(CHR2_XXX*CDXCDK_KXX \
      + CHR2_YXX*CDXCDK_KXY + CHR2_ZXX*CDXCDK_KXZ)
      CDXCDK_CDXCDKYY = DXDK_DXDKYY - 2D0*(CHR2_XXY*CDXCDK_KXY \
      + CHR2_YXY*CDXCDK_KYY + CHR2_ZXY*CDXCDK_KYZ)
      CDXCDK_CDXCDKZZ = DXDK_DXDKZZ - 2D0*(CHR2_XXZ*CDXCDK_KXZ \
      + CHR2_YXZ*CDXCDK_KYZ + CHR2_ZXZ*CDXCDK_KZZ)

      CDXCDK_CDXCDKXY = DXDK_DXDKXY - CHR2_XXY*CDXCDK_KXX -  \
      (CHR2_XXX + CHR2_YXY)*CDXCDK_KXY - CHR2_ZXY*CDXCDK_KXZ -  \
      CHR2_YXX*CDXCDK_KYY - CHR2_ZXX*CDXCDK_KYZ
      CDXCDK_CDXCDKXZ = DXDK_DXDKXZ - CHR2_XXZ*CDXCDK_KXX -  \
      (CHR2_XXX + CHR2_ZXZ)*CDXCDK_KXZ - CHR2_YXZ*CDXCDK_KXY -  \
      CHR2_YXX*CDXCDK_KYZ - CHR2_ZXX*CDXCDK_KZZ
      CDXCDK_CDXCDKYZ = DXDK_DXDKYZ - CHR2_XXZ*CDXCDK_KXY -  \
      CHR2_XXY*CDXCDK_KXZ - CHR2_YXZ*CDXCDK_KYY -  \
      (CHR2_YXY + CHR2_ZXZ)*CDXCDK_KYZ - CHR2_ZXY*CDXCDK_KZZ

#endif

#ifdef CCODE

      CDXCDK_CDXCDKXX = DXDK_DXDKXX - 2.*(CHR2_XXX*CDXCDK_KXX
       + CHR2_YXX*CDXCDK_KXY + CHR2_ZXX*CDXCDK_KXZ);
      CDXCDK_CDXCDKYY = DXDK_DXDKYY - 2.*(CHR2_XXY*CDXCDK_KXY
       + CHR2_YXY*CDXCDK_KYY + CHR2_ZXY*CDXCDK_KYZ);
      CDXCDK_CDXCDKZZ = DXDK_DXDKZZ - 2.*(CHR2_XXZ*CDXCDK_KXZ
       + CHR2_YXZ*CDXCDK_KYZ + CHR2_ZXZ*CDXCDK_KZZ);

      CDXCDK_CDXCDKXY = DXDK_DXDKXY - CHR2_XXY*CDXCDK_KXX - 
       (CHR2_XXX + CHR2_YXY)*CDXCDK_KXY - CHR2_ZXY*CDXCDK_KXZ - 
       CHR2_YXX*CDXCDK_KYY - CHR2_ZXX*CDXCDK_KYZ;
      CDXCDK_CDXCDKXZ = DXDK_DXDKXZ - CHR2_XXZ*CDXCDK_KXX - 
       (CHR2_XXX + CHR2_ZXZ)*CDXCDK_KXZ - CHR2_YXZ*CDXCDK_KXY - 
       CHR2_YXX*CDXCDK_KYZ - CHR2_ZXX*CDXCDK_KZZ;
      CDXCDK_CDXCDKYZ = DXDK_DXDKYZ - CHR2_XXZ*CDXCDK_KXY - 
       CHR2_XXY*CDXCDK_KXZ - CHR2_YXZ*CDXCDK_KYY - 
       (CHR2_YXY + CHR2_ZXZ)*CDXCDK_KYZ - CHR2_ZXY*CDXCDK_KZZ;


#endif

#endif
