/*@@
  @header   CHR2_guts.h
  @date     Jun 98
  @author   Gabrielle Allen
  @desc
  Macro to calculate Christoffel symbols of the second kind. 

  That is CHR2_cab =  g^cd CHR1_dab

                   =  1/2 g^cd (g_ad,b + gbd,a - gab,d)

  Requires: Christoffel symbols of first kind
            Uppermetric

  Provides: Christoffel sybols of second kind

  @enddesc
@@*/

#ifndef CHR2_GUTS
#define CHR2_GUTS

#include "CHR1_guts.h"
#include "UPPERMET_guts.h"

#ifdef FCODE 

      CHR2_XXX = CHR1_XXX*UPPERMET_UXX + CHR1_YXX*UPPERMET_UXY + CHR1_ZXX*UPPERMET_UXZ
      CHR2_XXY = CHR1_XXY*UPPERMET_UXX + CHR1_YXY*UPPERMET_UXY + CHR1_ZXY*UPPERMET_UXZ
      CHR2_XXZ = CHR1_XXZ*UPPERMET_UXX + CHR1_YXZ*UPPERMET_UXY + CHR1_ZXZ*UPPERMET_UXZ
      CHR2_XYY = CHR1_XYY*UPPERMET_UXX + CHR1_YYY*UPPERMET_UXY + CHR1_ZYY*UPPERMET_UXZ
      CHR2_XYZ = CHR1_XYZ*UPPERMET_UXX + CHR1_YYZ*UPPERMET_UXY + CHR1_ZYZ*UPPERMET_UXZ
      CHR2_XZZ = CHR1_XZZ*UPPERMET_UXX + CHR1_YZZ*UPPERMET_UXY + CHR1_ZZZ*UPPERMET_UXZ
      CHR2_YXX = CHR1_XXX*UPPERMET_UXY + CHR1_YXX*UPPERMET_UYY + CHR1_ZXX*UPPERMET_UYZ
      CHR2_YXY = CHR1_XXY*UPPERMET_UXY + CHR1_YXY*UPPERMET_UYY + CHR1_ZXY*UPPERMET_UYZ
      CHR2_YXZ = CHR1_XXZ*UPPERMET_UXY + CHR1_YXZ*UPPERMET_UYY + CHR1_ZXZ*UPPERMET_UYZ
      CHR2_YYY = CHR1_XYY*UPPERMET_UXY + CHR1_YYY*UPPERMET_UYY + CHR1_ZYY*UPPERMET_UYZ
      CHR2_YYZ = CHR1_XYZ*UPPERMET_UXY + CHR1_YYZ*UPPERMET_UYY + CHR1_ZYZ*UPPERMET_UYZ
      CHR2_YZZ = CHR1_XZZ*UPPERMET_UXY + CHR1_YZZ*UPPERMET_UYY + CHR1_ZZZ*UPPERMET_UYZ
      CHR2_ZXX = CHR1_XXX*UPPERMET_UXZ + CHR1_YXX*UPPERMET_UYZ + CHR1_ZXX*UPPERMET_UZZ
      CHR2_ZXY = CHR1_XXY*UPPERMET_UXZ + CHR1_YXY*UPPERMET_UYZ + CHR1_ZXY*UPPERMET_UZZ
      CHR2_ZXZ = CHR1_XXZ*UPPERMET_UXZ + CHR1_YXZ*UPPERMET_UYZ + CHR1_ZXZ*UPPERMET_UZZ
      CHR2_ZYY = CHR1_XYY*UPPERMET_UXZ + CHR1_YYY*UPPERMET_UYZ + CHR1_ZYY*UPPERMET_UZZ
      CHR2_ZYZ = CHR1_XYZ*UPPERMET_UXZ + CHR1_YYZ*UPPERMET_UYZ + CHR1_ZYZ*UPPERMET_UZZ
      CHR2_ZZZ = CHR1_XZZ*UPPERMET_UXZ + CHR1_YZZ*UPPERMET_UYZ + CHR1_ZZZ*UPPERMET_UZZ

#endif

#ifdef CCODE

      CHR2_XXX = CHR1_XXX*UPPERMET_UXX + CHR1_YXX*UPPERMET_UXY + CHR1_ZXX*UPPERMET_UXZ;
      CHR2_XXY = CHR1_XXY*UPPERMET_UXX + CHR1_YXY*UPPERMET_UXY + CHR1_ZXY*UPPERMET_UXZ;
      CHR2_XXZ = CHR1_XXZ*UPPERMET_UXX + CHR1_YXZ*UPPERMET_UXY + CHR1_ZXZ*UPPERMET_UXZ;
      CHR2_XYY = CHR1_XYY*UPPERMET_UXX + CHR1_YYY*UPPERMET_UXY + CHR1_ZYY*UPPERMET_UXZ;
      CHR2_XYZ = CHR1_XYZ*UPPERMET_UXX + CHR1_YYZ*UPPERMET_UXY + CHR1_ZYZ*UPPERMET_UXZ;
      CHR2_XZZ = CHR1_XZZ*UPPERMET_UXX + CHR1_YZZ*UPPERMET_UXY + CHR1_ZZZ*UPPERMET_UXZ;
      CHR2_YXX = CHR1_XXX*UPPERMET_UXY + CHR1_YXX*UPPERMET_UYY + CHR1_ZXX*UPPERMET_UYZ;
      CHR2_YXY = CHR1_XXY*UPPERMET_UXY + CHR1_YXY*UPPERMET_UYY + CHR1_ZXY*UPPERMET_UYZ;
      CHR2_YXZ = CHR1_XXZ*UPPERMET_UXY + CHR1_YXZ*UPPERMET_UYY + CHR1_ZXZ*UPPERMET_UYZ;
      CHR2_YYY = CHR1_XYY*UPPERMET_UXY + CHR1_YYY*UPPERMET_UYY + CHR1_ZYY*UPPERMET_UYZ;
      CHR2_YYZ = CHR1_XYZ*UPPERMET_UXY + CHR1_YYZ*UPPERMET_UYY + CHR1_ZYZ*UPPERMET_UYZ;
      CHR2_YZZ = CHR1_XZZ*UPPERMET_UXY + CHR1_YZZ*UPPERMET_UYY + CHR1_ZZZ*UPPERMET_UYZ;
      CHR2_ZXX = CHR1_XXX*UPPERMET_UXZ + CHR1_YXX*UPPERMET_UYZ + CHR1_ZXX*UPPERMET_UZZ;
      CHR2_ZXY = CHR1_XXY*UPPERMET_UXZ + CHR1_YXY*UPPERMET_UYZ + CHR1_ZXY*UPPERMET_UZZ;
      CHR2_ZXZ = CHR1_XXZ*UPPERMET_UXZ + CHR1_YXZ*UPPERMET_UYZ + CHR1_ZXZ*UPPERMET_UZZ;
      CHR2_ZYY = CHR1_XYY*UPPERMET_UXZ + CHR1_YYY*UPPERMET_UYZ + CHR1_ZYY*UPPERMET_UZZ;
      CHR2_ZYZ = CHR1_XYZ*UPPERMET_UXZ + CHR1_YYZ*UPPERMET_UYZ + CHR1_ZYZ*UPPERMET_UZZ;
      CHR2_ZZZ = CHR1_XZZ*UPPERMET_UXZ + CHR1_YZZ*UPPERMET_UYZ + CHR1_ZZZ*UPPERMET_UZZ;

#endif

#endif
