/*
UPPERMET_guts.h

Macro to calculate the components of the upper physical metric,
and as an offspin the determinant of the conformal(?) metric. 

Gabrielle Allen, 11th June 1998

*/

#ifndef UPPERMET_GUTS
#define UPPERMET_GUTS

#include "DETG_guts.h"

#ifdef FCODE

      IUPPERMET_PSI4DET = 1.d0 / (DETG_PSI4*DETG_DETCG)

      UPPERMET_UXX = DETG_TEMPXX*IUPPERMET_PSI4DET
      UPPERMET_UXY = DETG_TEMPXY*IUPPERMET_PSI4DET
      UPPERMET_UXZ = DETG_TEMPXZ*IUPPERMET_PSI4DET
      UPPERMET_UYY = DETG_TEMPYY*IUPPERMET_PSI4DET
      UPPERMET_UYZ = DETG_TEMPYZ*IUPPERMET_PSI4DET
      UPPERMET_UZZ = DETG_TEMPZZ*IUPPERMET_PSI4DET

#endif

#ifdef CCODE

IUPPERMET_PSI4DET = 1.0 / (DETG_PSI4*DETG_DETCG);

UPPERMET_UXX = DETG_TEMPXX*IUPPERMET_PSI4DET;
UPPERMET_UXY = DETG_TEMPXY*IUPPERMET_PSI4DET;
UPPERMET_UXZ = DETG_TEMPXZ*IUPPERMET_PSI4DET;
UPPERMET_UYY = DETG_TEMPYY*IUPPERMET_PSI4DET;
UPPERMET_UYZ = DETG_TEMPYZ*IUPPERMET_PSI4DET;
UPPERMET_UZZ = DETG_TEMPZZ*IUPPERMET_PSI4DET;

#endif

#endif
