! ATMOS_LIB: Atmospheric science procedures for F90
! Compiled/Modified:
!   07/01/06  John Haynes (haynes@atmos.colostate.edu)
!
! mcclatchey (subroutine)
  
  module atmos_lib
  implicit none
  
  integer, private, parameter :: r8 = selected_real_kind(15)

  contains
  
! ----------------------------------------------------------------------------
! subroutine MCCLATCHEY
! ----------------------------------------------------------------------------
  subroutine mcclatchey(stype,hgt,prs,tk,rh)
  implicit none
!
! Purpose:
!   returns a standard atmospheric profile
!
! Input:
!   [stype]   type of profile to return
!             1 = mid-latitude summer
!             2 = mid-latitude winter
!             3 = tropical
!
! Outputs:
!   [hgt]     height (m)
!   [prs]     pressure (hPa)
!   [tk]      temperature (K)
!   [rh]      relative humidity (%)
!
! Created:
!   06/01/2006  John Haynes (haynes@atmos.colostate.edu)

! ----- INPUTS -----
  integer, intent(in) :: &
  stype

  integer, parameter :: ndat = 33

! ----- OUTPUTS -----
  real(8), intent(out), dimension(ndat) :: &
  hgt, &                        ! height (m)
  prs, &                        ! pressure (hPa)
  tk, &                         ! temperature (K)
  rh                            ! relative humidity (%)
  
  hgt = (/0.00000_r8,1000.00_r8,2000.00_r8,3000.00_r8,4000.00_r8,5000.00_r8, &
          6000.00_r8,7000.00_r8,8000.00_r8,9000.00_r8,10000.0_r8,11000.0_r8, &
          12000.0_r8,13000.0_r8,14000.0_r8,15000.0_r8,16000.0_r8,17000.0_r8, &
          18000.0_r8,19000.0_r8,20000.0_r8,21000.0_r8,22000.0_r8,23000.0_r8, &
          24000.0_r8,25000.0_r8,30000.0_r8,35000.0_r8,40000.0_r8,45000.0_r8, &
          50000.0_r8,70000.0_r8,100000._r8/)

  select case(stype)

  case(1)
!   // mid-latitide summer  
    prs = (/1013.00_r8, 902.000_r8, 802.000_r8, 710.000_r8, 628.000_r8, 554.000_r8, &
            487.000_r8, 426.000_r8, 372.000_r8, 324.000_r8, 281.000_r8, 243.000_r8, &
            209.000_r8, 179.000_r8, 153.000_r8, 130.000_r8, 111.000_r8, 95.0000_r8, &
            81.2000_r8, 69.5000_r8, 59.5000_r8, 51.0000_r8, 43.7000_r8, 37.6000_r8, &
            32.2000_r8, 27.7000_r8, 13.2000_r8, 6.52000_r8, 3.33000_r8, 1.76000_r8, &
            0.951000_r8,0.0671000_r8,0.000300000_r8/)
        
    tk =  (/294.000_r8, 290.000_r8, 285.000_r8, 279.000_r8, 273.000_r8, 267.000_r8, &
            261.000_r8, 255.000_r8, 248.000_r8, 242.000_r8, 235.000_r8, 229.000_r8, &
            222.000_r8, 216.000_r8, 216.000_r8, 216.000_r8, 216.000_r8, 216.000_r8, &
            216.000_r8, 217.000_r8, 218.000_r8, 219.000_r8, 220.000_r8, 222.000_r8, &
            223.000_r8, 224.000_r8, 234.000_r8, 245.000_r8, 258.000_r8, 270.000_r8, &
            276.000_r8, 218.000_r8, 210.000_r8/)

    rh =  (/74.8384_r8, 63.4602_r8, 55.0485_r8, 45.4953_r8, 39.3805_r8, 31.7965_r8, &
            30.3958_r8, 29.5966_r8, 30.1626_r8, 29.3624_r8, 30.3334_r8, 19.0768_r8, &
            11.0450_r8, 6.61278_r8, 3.67379_r8, 2.79209_r8, 2.35123_r8, 2.05732_r8, &
            1.83690_r8, 1.59930_r8, 1.30655_r8, 1.31890_r8, 1.17620_r8,0.994076_r8, &
            0.988566_r8,0.989143_r8,0.188288_r8,0.0205613_r8,0.00271164_r8,0.000488798_r8, &
            0.000107066_r8,0.000406489_r8,7.68645e-06_r8/)

  case(2)
!   // mid-latitude winter
    prs = (/1018.00_r8, 897.300_r8, 789.700_r8, 693.800_r8, 608.100_r8, 531.300_r8, &
            462.700_r8, 401.600_r8, 347.300_r8, 299.200_r8, 256.800_r8, 219.900_r8, &
            188.200_r8, 161.000_r8, 137.800_r8, 117.800_r8, 100.700_r8, 86.1000_r8, &
            73.5000_r8, 62.8000_r8, 53.7000_r8, 45.8000_r8, 39.1000_r8, 33.4000_r8, &
            28.6000_r8, 24.3000_r8, 11.1000_r8, 5.18000_r8, 2.53000_r8, 1.29000_r8, &
            0.682000_r8,0.0467000_r8,0.000300000_r8/)

    tk =  (/272.200_r8, 268.700_r8, 265.200_r8, 261.700_r8, 255.700_r8, 249.700_r8, &
            243.700_r8, 237.700_r8, 231.700_r8, 225.700_r8, 219.700_r8, 219.200_r8, &
            218.700_r8, 218.200_r8, 217.700_r8, 217.200_r8, 216.700_r8, 216.200_r8, &
            215.700_r8, 215.200_r8, 215.200_r8, 215.200_r8, 215.200_r8, 215.200_r8, &
            215.200_r8, 215.200_r8, 217.400_r8, 227.800_r8, 243.200_r8, 258.500_r8, &
            265.700_r8, 230.700_r8, 210.200_r8/)

    rh =  (/76.6175_r8, 70.1686_r8, 65.2478_r8, 56.6267_r8, 49.8755_r8, 47.1765_r8, &
            44.0477_r8, 31.0565_r8, 23.0244_r8, 19.6510_r8, 17.8987_r8, 17.4376_r8, &
            16.0621_r8, 5.10608_r8, 3.00679_r8, 2.42293_r8, 2.16406_r8, 2.00901_r8, &
            1.90374_r8, 1.98072_r8, 1.81902_r8, 2.06155_r8, 2.06154_r8, 2.18280_r8, &
            2.42531_r8,2.70824_r8,1.12105_r8,0.108119_r8,0.00944200_r8,0.00115201_r8, &
            0.000221094_r8,0.000101946_r8,7.49350e-06_r8/)

  case(3)
!   // tropical
    prs = (/1013.00_r8, 904.000_r8, 805.000_r8, 715.000_r8, 633.000_r8, 559.000_r8, &
            492.000_r8, 432.000_r8, 378.000_r8, 329.000_r8, 286.000_r8, 247.000_r8, &
            213.000_r8, 182.000_r8, 156.000_r8, 132.000_r8, 111.000_r8, 93.7000_r8, &
            78.9000_r8, 66.6000_r8, 56.5000_r8, 48.0000_r8, 40.9000_r8, 35.0000_r8, &
            30.0000_r8, 25.7000_r8, 12.2000_r8, 6.00000_r8, 3.05000_r8, 1.59000_r8, &
            0.854000_r8,0.0579000_r8,0.000300000_r8/)

    tk =  (/300.000_r8, 294.000_r8, 288.000_r8, 284.000_r8, 277.000_r8, 270.000_r8, &
            264.000_r8, 257.000_r8, 250.000_r8, 244.000_r8, 237.000_r8, 230.000_r8, &
            224.000_r8, 217.000_r8, 210.000_r8, 204.000_r8, 197.000_r8, 195.000_r8, &
            199.000_r8, 203.000_r8, 207.000_r8, 211.000_r8, 215.000_r8, 217.000_r8, &
            219.000_r8, 221.000_r8, 232.000_r8, 243.000_r8, 254.000_r8, 265.000_r8, &
            270.000_r8, 219.000_r8, 210.000_r8/)

    rh =  (/71.4334_r8, 69.4097_r8, 71.4488_r8, 46.7724_r8, 34.7129_r8, 38.3820_r8, &
            33.7214_r8, 32.0122_r8, 30.2607_r8, 24.5059_r8, 19.5321_r8, 13.2966_r8, &
            8.85795_r8, 5.87496_r8, 7.68644_r8, 12.8879_r8, 29.4976_r8, 34.9351_r8, &
            17.1606_r8, 9.53422_r8, 5.10154_r8, 3.45407_r8, 2.11168_r8, 1.76247_r8, &
            1.55162_r8,1.37966_r8,0.229799_r8,0.0245943_r8,0.00373686_r8,0.000702138_r8, &
            0.000162076_r8,0.000362055_r8,7.68645e-06_r8/)
         
  case default
    print *, 'Must enter a profile type'
    stop
    
  end select
  
  end subroutine mcclatchey
  
  end module atmos_lib
