#!/bin/bash
# Simple build script, potentially useful if building a GPL-redistributable
# version on a system *without* SPEC CPU2017.  See:
#
#     https://www.spec.org/cpu2017/Docs/licenses.html#GPLtarballs
#
# Note: if the benchmark uses "specpp", that is the freely-redistributable
#       preprocessor "filepp".   It is described at 
#         https://www.spec.org/cpu2017/Docs/utility.html#specpp  
#       and will need to be in your path.  You can find filepp sources as
#       modified by SPEC in redistributable_sources/modified/tools.src/harness-spec.tar.xz 
#---------------------------------------------------------------------------

specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ESMF_BaseMod.F90 -o ESMF_BaseMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_BaseMod.fppized.o -I. -Iinclude -Inetcdf/include -g ESMF_BaseMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ESMF_BaseTimeMod.F90 -o ESMF_BaseTimeMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_BaseTimeMod.fppized.o -I. -Iinclude -Inetcdf/include -g ESMF_BaseTimeMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ESMF_FractionMod.F90 -o ESMF_FractionMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_FractionMod.fppized.o -I. -Iinclude -Inetcdf/include -g ESMF_FractionMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ESMF_CalendarMod.F90 -o ESMF_CalendarMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_CalendarMod.fppized.o -I. -Iinclude -Inetcdf/include -g ESMF_CalendarMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ESMF_TimeIntervalMod.F90 -o ESMF_TimeIntervalMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_TimeIntervalMod.fppized.o -I. -Iinclude -Inetcdf/include -g ESMF_TimeIntervalMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ESMF_Stubs.F90 -o ESMF_Stubs.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_Stubs.fppized.o -I. -Iinclude -Inetcdf/include -g ESMF_Stubs.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ESMF_TimeMod.F90 -o ESMF_TimeMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_TimeMod.fppized.o -I. -Iinclude -Inetcdf/include -g ESMF_TimeMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ESMF_AlarmMod.F90 -o ESMF_AlarmMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_AlarmMod.fppized.o -I. -Iinclude -Inetcdf/include -g ESMF_AlarmMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ESMF_ClockMod.F90 -o ESMF_ClockMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_ClockMod.fppized.o -I. -Iinclude -Inetcdf/include -g ESMF_ClockMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ESMF_AlarmClockMod.F90 -o ESMF_AlarmClockMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_AlarmClockMod.fppized.o -I. -Iinclude -Inetcdf/include -g ESMF_AlarmClockMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ESMF_Mod.F90 -o ESMF_Mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ESMF_Mod.fppized.o -I. -Iinclude -Inetcdf/include -g ESMF_Mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cam_logfile.F90 -o cam_logfile.fppized.f90
/usr/bin/gfortran           -m64 -c -o cam_logfile.fppized.o -I. -Iinclude -Inetcdf/include -g cam_logfile.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 debugutilitiesmodule.F90 -o debugutilitiesmodule.fppized.f90
/usr/bin/gfortran           -m64 -c -o debugutilitiesmodule.fppized.o -I. -Iinclude -Inetcdf/include -g debugutilitiesmodule.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 decompmodule.F90 -o decompmodule.fppized.f90
/usr/bin/gfortran           -m64 -c -o decompmodule.fppized.o -I. -Iinclude -Inetcdf/include -g decompmodule.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_kind_mod.F90 -o shr_kind_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_kind_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_kind_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ghostmodule.F90 -o ghostmodule.fppized.f90
/usr/bin/gfortran           -m64 -c -o ghostmodule.fppized.o -I. -Iinclude -Inetcdf/include -g ghostmodule.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 perf_utils.F90 -o perf_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o perf_utils.fppized.o -I. -Iinclude -Inetcdf/include -g perf_utils.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_log_mod.F90 -o shr_log_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_log_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_log_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_mpi_mod.F90 -o shr_mpi_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_mpi_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_mpi_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_sys_mod.F90 -o shr_sys_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_sys_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_sys_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_file_mod.F90 -o shr_file_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_file_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_file_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 string_utils.F90 -o string_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o string_utils.fppized.o -I. -Iinclude -Inetcdf/include -g string_utils.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 namelist_utils.F90 -o namelist_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o namelist_utils.fppized.o -I. -Iinclude -Inetcdf/include -g namelist_utils.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 perf_mod.F90 -o perf_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o perf_mod.fppized.o -I. -Iinclude -Inetcdf/include -g perf_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mod_comm.F90 -o mod_comm.fppized.f90
/usr/bin/gfortran           -m64 -c -o mod_comm.fppized.o -I. -Iinclude -Inetcdf/include -g mod_comm.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 parutilitiesmodule.F90 -o parutilitiesmodule.fppized.f90
/usr/bin/gfortran           -m64 -c -o parutilitiesmodule.fppized.o -I. -Iinclude -Inetcdf/include -g parutilitiesmodule.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mpishorthand.F90 -o mpishorthand.fppized.f90
/usr/bin/gfortran           -m64 -c -o mpishorthand.fppized.o -I. -Iinclude -Inetcdf/include -g mpishorthand.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 abortutils.F90 -o abortutils.fppized.f90
/usr/bin/gfortran           -m64 -c -o abortutils.fppized.o -I. -Iinclude -Inetcdf/include -g abortutils.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 units.F90 -o units.fppized.f90
/usr/bin/gfortran           -m64 -c -o units.fppized.o -I. -Iinclude -Inetcdf/include -g units.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 spmd_utils.F90 -o spmd_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o spmd_utils.fppized.o -I. -Iinclude -Inetcdf/include -g spmd_utils.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 fv_control_mod.F90 -o fv_control_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o fv_control_mod.fppized.o -I. -Iinclude -Inetcdf/include -g fv_control_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pft_module.F90 -o pft_module.fppized.f90
/usr/bin/gfortran           -m64 -c -o pft_module.fppized.o -I. -Iinclude -Inetcdf/include -g pft_module.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 dynamics_vars.F90 -o dynamics_vars.fppized.f90
/usr/bin/gfortran           -m64 -c -o dynamics_vars.fppized.o -I. -Iinclude -Inetcdf/include -g dynamics_vars.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 FVperf_module.F90 -o FVperf_module.fppized.f90
/usr/bin/gfortran           -m64 -c -o FVperf_module.fppized.o -I. -Iinclude -Inetcdf/include -g FVperf_module.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o GPTLget_memusage.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  GPTLget_memusage.c
/usr/bin/gcc     -std=c99   -m64 -c -o GPTLprint_memusage.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  GPTLprint_memusage.c
/usr/bin/gcc     -std=c99   -m64 -c -o GPTLutil.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  GPTLutil.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 MISR_simulator.F90 -o MISR_simulator.fppized.f90
/usr/bin/gfortran           -m64 -c -o MISR_simulator.fppized.o -I. -Iinclude -Inetcdf/include -g MISR_simulator.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 Meat.F90 -o Meat.fppized.f90
/usr/bin/gfortran           -m64 -c -o Meat.fppized.o -I. -Iinclude -Inetcdf/include -g Meat.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pmgrid.F90 -o pmgrid.fppized.f90
/usr/bin/gfortran           -m64 -c -o pmgrid.fppized.o -I. -Iinclude -Inetcdf/include -g pmgrid.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 dycore.F90 -o dycore.fppized.f90
/usr/bin/gfortran           -m64 -c -o dycore.fppized.o -I. -Iinclude -Inetcdf/include -g dycore.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pio_kinds.F90 -o pio_kinds.fppized.f90
/usr/bin/gfortran           -m64 -c -o netcdf/typeSizes.o -I. -Iinclude -Inetcdf/include -g netcdf/typeSizes.f90
/usr/bin/gfortran           -m64 -c -o netcdf/netcdf.o -I. -Iinclude -Inetcdf/include -g netcdf/netcdf.f90
/usr/bin/gfortran           -m64 -c -o pio_kinds.fppized.o -I. -Iinclude -Inetcdf/include -g pio_kinds.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pio_support.F90 -o pio_support.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_support.fppized.o -I. -Iinclude -Inetcdf/include -g pio_support.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pio_types.F90 -o pio_types.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_types.fppized.o -I. -Iinclude -Inetcdf/include -g pio_types.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pio_msg_mod.F90 -o pio_msg_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_msg_mod.fppized.o -I. -Iinclude -Inetcdf/include -g pio_msg_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 alloc_mod.F90 -o alloc_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o alloc_mod.fppized.o -I. -Iinclude -Inetcdf/include -g alloc_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pio_utils.F90 -o pio_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_utils.fppized.o -I. -Iinclude -Inetcdf/include -g pio_utils.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 nf_mod.F90 -o nf_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o nf_mod.fppized.o -I. -Iinclude -Inetcdf/include -g nf_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pionfput_mod.F90 -o pionfput_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o pionfput_mod.fppized.o -I. -Iinclude -Inetcdf/include -g pionfput_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pionfatt_mod.F90 -o pionfatt_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o pionfatt_mod.fppized.o -I. -Iinclude -Inetcdf/include -g pionfatt_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pio_spmd_utils.F90 -o pio_spmd_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_spmd_utils.fppized.o -I. -Iinclude -Inetcdf/include -g pio_spmd_utils.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 calcdisplace_mod.F90 -o calcdisplace_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o calcdisplace_mod.fppized.o -I. -Iinclude -Inetcdf/include -g calcdisplace_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 box_rearrange.F90 -o box_rearrange.fppized.f90
/usr/bin/gfortran           -m64 -c -o box_rearrange.fppized.o -I. -Iinclude -Inetcdf/include -g box_rearrange.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 rearrange.F90 -o rearrange.fppized.f90
/usr/bin/gfortran           -m64 -c -o rearrange.fppized.o -I. -Iinclude -Inetcdf/include -g rearrange.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pionfread_mod.F90 -o pionfread_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o pionfread_mod.fppized.o -I. -Iinclude -Inetcdf/include -g pionfread_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 iompi_mod.F90 -o iompi_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o iompi_mod.fppized.o -I. -Iinclude -Inetcdf/include -g iompi_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pionfwrite_mod.F90 -o pionfwrite_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o pionfwrite_mod.fppized.o -I. -Iinclude -Inetcdf/include -g pionfwrite_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 piodarray.F90 -o piodarray.fppized.f90
/usr/bin/gfortran           -m64 -c -o piodarray.fppized.o -I. -Iinclude -Inetcdf/include -g piodarray.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ionf_mod.F90 -o ionf_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ionf_mod.fppized.o -I. -Iinclude -Inetcdf/include -g ionf_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 calcdecomp.F90 -o calcdecomp.fppized.f90
/usr/bin/gfortran           -m64 -c -o calcdecomp.fppized.o -I. -Iinclude -Inetcdf/include -g calcdecomp.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pio_mpi_utils.F90 -o pio_mpi_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_mpi_utils.fppized.o -I. -Iinclude -Inetcdf/include -g pio_mpi_utils.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 piolib_mod.F90 -o piolib_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o piolib_mod.fppized.o -I. -Iinclude -Inetcdf/include -g piolib_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pionfget_mod.F90 -o pionfget_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o pionfget_mod.fppized.o -I. -Iinclude -Inetcdf/include -g pionfget_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pio.F90 -o pio.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio.fppized.o -I. -Iinclude -Inetcdf/include -g pio.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_timer_mod.F90 -o shr_timer_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_timer_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_timer_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_string_mod.F90 -o shr_string_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_string_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_string_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_const_mod.F90 -o shr_const_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_const_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_const_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_cal_mod.F90 -o shr_cal_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_cal_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_cal_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 time_manager.F90 -o time_manager.fppized.f90
/usr/bin/gfortran           -m64 -c -o time_manager.fppized.o -I. -Iinclude -Inetcdf/include -g time_manager.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ppgrid.F90 -o ppgrid.fppized.f90
/usr/bin/gfortran           -m64 -c -o ppgrid.fppized.o -I. -Iinclude -Inetcdf/include -g ppgrid.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 physconst.F90 -o physconst.fppized.f90
/usr/bin/gfortran           -m64 -c -o physconst.fppized.o -I. -Iinclude -Inetcdf/include -g physconst.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 constituents.F90 -o constituents.fppized.f90
/usr/bin/gfortran           -m64 -c -o constituents.fppized.o -I. -Iinclude -Inetcdf/include -g constituents.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 commap.F90 -o commap.fppized.f90
/usr/bin/gfortran           -m64 -c -o commap.fppized.o -I. -Iinclude -Inetcdf/include -g commap.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 infnan.F90 -o infnan.fppized.f90
/usr/bin/gfortran           -m64 -c -o infnan.fppized.o -I. -Iinclude -Inetcdf/include -g infnan.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pspect.F90 -o pspect.fppized.f90
/usr/bin/gfortran           -m64 -c -o pspect.fppized.o -I. -Iinclude -Inetcdf/include -g pspect.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 rgrid.F90 -o rgrid.fppized.f90
/usr/bin/gfortran           -m64 -c -o rgrid.fppized.o -I. -Iinclude -Inetcdf/include -g rgrid.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 spmd_dyn.F90 -o spmd_dyn.fppized.f90
/usr/bin/gfortran           -m64 -c -o spmd_dyn.fppized.o -I. -Iinclude -Inetcdf/include -g spmd_dyn.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 hycoef.F90 -o hycoef.fppized.f90
/usr/bin/gfortran           -m64 -c -o hycoef.fppized.o -I. -Iinclude -Inetcdf/include -g hycoef.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 dyn_grid.F90 -o dyn_grid.fppized.f90
/usr/bin/gfortran           -m64 -c -o dyn_grid.fppized.o -I. -Iinclude -Inetcdf/include -g dyn_grid.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_chars.F90 -o m_chars.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_chars.fppized.o -I. -Iinclude -Inetcdf/include -g m_chars.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_flow.F90 -o m_flow.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_flow.fppized.o -I. -Iinclude -Inetcdf/include -g m_flow.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_stdio.F90 -o m_stdio.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_stdio.fppized.o -I. -Iinclude -Inetcdf/include -g m_stdio.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_mpif.F90 -o m_mpif.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_mpif.fppized.o -I. -Iinclude -Inetcdf/include -g m_mpif.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_realkinds.F90 -o m_realkinds.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_realkinds.fppized.o -I. -Iinclude -Inetcdf/include -g m_realkinds.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_mpif90.F90 -o m_mpif90.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_mpif90.fppized.o -I. -Iinclude -Inetcdf/include -g m_mpif90.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_dropdead.F90 -o m_dropdead.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_dropdead.fppized.o -I. -Iinclude -Inetcdf/include -g m_dropdead.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_ioutil.F90 -o m_ioutil.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_ioutil.fppized.o -I. -Iinclude -Inetcdf/include -g m_ioutil.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_mpout.F90 -o m_mpout.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_mpout.fppized.o -I. -Iinclude -Inetcdf/include -g m_mpout.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_die.F90 -o m_die.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_die.fppized.o -I. -Iinclude -Inetcdf/include -g m_die.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_MergeSorts.F90 -o m_MergeSorts.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_MergeSorts.fppized.o -I. -Iinclude -Inetcdf/include -g m_MergeSorts.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 phys_grid.F90 -o phys_grid.fppized.f90
/usr/bin/gfortran           -m64 -c -o phys_grid.fppized.o -I. -Iinclude -Inetcdf/include -g phys_grid.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ioFileMod.F90 -o ioFileMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ioFileMod.fppized.o -I. -Iinclude -Inetcdf/include -g ioFileMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cam_history_support.F90 -o cam_history_support.fppized.f90
/usr/bin/gfortran           -m64 -c -o cam_history_support.fppized.o -I. -Iinclude -Inetcdf/include -g cam_history_support.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cam_control_mod.F90 -o cam_control_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o cam_control_mod.fppized.o -I. -Iinclude -Inetcdf/include -g cam_control_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_mall.F90 -o m_mall.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_mall.fppized.o -I. -Iinclude -Inetcdf/include -g m_mall.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_String.F90 -o m_String.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_String.fppized.o -I. -Iinclude -Inetcdf/include -g m_String.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_rankMerge.F90 -o m_rankMerge.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_rankMerge.fppized.o -I. -Iinclude -Inetcdf/include -g m_rankMerge.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_IndexBin_logical.F90 -o m_IndexBin_logical.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_IndexBin_logical.fppized.o -I. -Iinclude -Inetcdf/include -g m_IndexBin_logical.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_Permuter.F90 -o m_Permuter.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Permuter.fppized.o -I. -Iinclude -Inetcdf/include -g m_Permuter.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_IndexBin_char.F90 -o m_IndexBin_char.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_IndexBin_char.fppized.o -I. -Iinclude -Inetcdf/include -g m_IndexBin_char.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_IndexBin_integer.F90 -o m_IndexBin_integer.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_IndexBin_integer.fppized.o -I. -Iinclude -Inetcdf/include -g m_IndexBin_integer.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_SortingTools.F90 -o m_SortingTools.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SortingTools.fppized.o -I. -Iinclude -Inetcdf/include -g m_SortingTools.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_List.F90 -o m_List.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_List.fppized.o -I. -Iinclude -Inetcdf/include -g m_List.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_TraceBack.F90 -o m_TraceBack.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_TraceBack.fppized.o -I. -Iinclude -Inetcdf/include -g m_TraceBack.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_AttrVect.F90 -o m_AttrVect.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_AttrVect.fppized.o -I. -Iinclude -Inetcdf/include -g m_AttrVect.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_GlobalMap.F90 -o m_GlobalMap.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_GlobalMap.fppized.o -I. -Iinclude -Inetcdf/include -g m_GlobalMap.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_FcComms.F90 -o m_FcComms.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_FcComms.fppized.o -I. -Iinclude -Inetcdf/include -g m_FcComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_MCTWorld.F90 -o m_MCTWorld.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_MCTWorld.fppized.o -I. -Iinclude -Inetcdf/include -g m_MCTWorld.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_GlobalSegMap.F90 -o m_GlobalSegMap.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_GlobalSegMap.fppized.o -I. -Iinclude -Inetcdf/include -g m_GlobalSegMap.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_AttrVectComms.F90 -o m_AttrVectComms.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_AttrVectComms.fppized.o -I. -Iinclude -Inetcdf/include -g m_AttrVectComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_SparseMatrix.F90 -o m_SparseMatrix.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SparseMatrix.fppized.o -I. -Iinclude -Inetcdf/include -g m_SparseMatrix.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_SparseMatrixDecomp.F90 -o m_SparseMatrixDecomp.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SparseMatrixDecomp.fppized.o -I. -Iinclude -Inetcdf/include -g m_SparseMatrixDecomp.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_SparseMatrixComms.F90 -o m_SparseMatrixComms.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SparseMatrixComms.fppized.o -I. -Iinclude -Inetcdf/include -g m_SparseMatrixComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_Navigator.F90 -o m_Navigator.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Navigator.fppized.o -I. -Iinclude -Inetcdf/include -g m_Navigator.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_GlobalToLocal.F90 -o m_GlobalToLocal.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_GlobalToLocal.fppized.o -I. -Iinclude -Inetcdf/include -g m_GlobalToLocal.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_SparseMatrixToMaps.F90 -o m_SparseMatrixToMaps.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SparseMatrixToMaps.fppized.o -I. -Iinclude -Inetcdf/include -g m_SparseMatrixToMaps.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_ConvertMaps.F90 -o m_ConvertMaps.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_ConvertMaps.fppized.o -I. -Iinclude -Inetcdf/include -g m_ConvertMaps.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_ExchangeMaps.F90 -o m_ExchangeMaps.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_ExchangeMaps.fppized.o -I. -Iinclude -Inetcdf/include -g m_ExchangeMaps.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_Router.F90 -o m_Router.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Router.fppized.o -I. -Iinclude -Inetcdf/include -g m_Router.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_Rearranger.F90 -o m_Rearranger.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Rearranger.fppized.o -I. -Iinclude -Inetcdf/include -g m_Rearranger.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_SparseMatrixPlus.F90 -o m_SparseMatrixPlus.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SparseMatrixPlus.fppized.o -I. -Iinclude -Inetcdf/include -g m_SparseMatrixPlus.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_GeneralGrid.F90 -o m_GeneralGrid.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_GeneralGrid.fppized.o -I. -Iinclude -Inetcdf/include -g m_GeneralGrid.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_Transfer.F90 -o m_Transfer.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Transfer.fppized.o -I. -Iinclude -Inetcdf/include -g m_Transfer.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_inpak90.F90 -o m_inpak90.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_inpak90.fppized.o -I. -Iinclude -Inetcdf/include -g m_inpak90.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_GlobalSegMapComms.F90 -o m_GlobalSegMapComms.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_GlobalSegMapComms.fppized.o -I. -Iinclude -Inetcdf/include -g m_GlobalSegMapComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_Accumulator.F90 -o m_Accumulator.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Accumulator.fppized.o -I. -Iinclude -Inetcdf/include -g m_Accumulator.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_MatAttrVectMul.F90 -o m_MatAttrVectMul.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_MatAttrVectMul.fppized.o -I. -Iinclude -Inetcdf/include -g m_MatAttrVectMul.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_GeneralGridComms.F90 -o m_GeneralGridComms.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_GeneralGridComms.fppized.o -I. -Iinclude -Inetcdf/include -g m_GeneralGridComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mct_mod.F90 -o mct_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o mct_mod.fppized.o -I. -Iinclude -Inetcdf/include -g mct_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_comm_mct.F90 -o seq_comm_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_comm_mct.fppized.o -I. -Iinclude -Inetcdf/include -g seq_comm_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_drydep_mod.F90 -o seq_drydep_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_drydep_mod.fppized.o -I. -Iinclude -Inetcdf/include -g seq_drydep_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_flds_mod.F90 -o seq_flds_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_flds_mod.fppized.o -I. -Iinclude -Inetcdf/include -g seq_flds_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_io_mod.F90 -o seq_io_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_io_mod.fppized.o -I. -Iinclude -Inetcdf/include -g seq_io_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cam_pio_utils.F90 -o cam_pio_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o cam_pio_utils.fppized.o -I. -Iinclude -Inetcdf/include -g cam_pio_utils.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 sat_hist.F90 -o sat_hist.fppized.f90
/usr/bin/gfortran           -m64 -c -o sat_hist.fppized.o -I. -Iinclude -Inetcdf/include -g sat_hist.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 solar_data.F90 -o solar_data.fppized.f90
/usr/bin/gfortran           -m64 -c -o solar_data.fppized.o -I. -Iinclude -Inetcdf/include -g solar_data.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_orb_mod.F90 -o shr_orb_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_orb_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_orb_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_tInterp_mod.F90 -o shr_tInterp_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_tInterp_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_tInterp_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_stream_mod.F90 -o shr_stream_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_stream_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_stream_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_pcdf_mod.F90 -o shr_pcdf_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_pcdf_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_pcdf_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_mct_mod.F90 -o shr_mct_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_mct_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_mct_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_map_mod.F90 -o shr_map_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_map_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_map_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_ncread_mod.F90 -o shr_ncread_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_ncread_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_ncread_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_dmodel_mod.F90 -o shr_dmodel_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_dmodel_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_dmodel_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_strdata_mod.F90 -o shr_strdata_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_strdata_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_strdata_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_scam_mod.F90 -o shr_scam_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_scam_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_scam_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 wrap_nf.F90 -o wrap_nf.fppized.f90
/usr/bin/gfortran           -m64 -c -o wrap_nf.fppized.o -I. -Iinclude -Inetcdf/include -g wrap_nf.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 scamMod.F90 -o scamMod.fppized.f90
/usr/bin/gfortran           -m64 -c -o scamMod.fppized.o -I. -Iinclude -Inetcdf/include -g scamMod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 error_messages.F90 -o error_messages.fppized.f90
/usr/bin/gfortran           -m64 -c -o error_messages.fppized.o -I. -Iinclude -Inetcdf/include -g error_messages.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 interpolate_data.F90 -o interpolate_data.fppized.f90
/usr/bin/gfortran           -m64 -c -o interpolate_data.fppized.o -I. -Iinclude -Inetcdf/include -g interpolate_data.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 geopotential.F90 -o geopotential.fppized.f90
/usr/bin/gfortran           -m64 -c -o geopotential.fppized.o -I. -Iinclude -Inetcdf/include -g geopotential.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ref_pres.F90 -o ref_pres.fppized.f90
/usr/bin/gfortran           -m64 -c -o ref_pres.fppized.o -I. -Iinclude -Inetcdf/include -g ref_pres.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 phys_control.F90 -o phys_control.fppized.f90
/usr/bin/gfortran           -m64 -c -o phys_control.fppized.o -I. -Iinclude -Inetcdf/include -g phys_control.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 physics_types.F90 -o physics_types.fppized.f90
/usr/bin/gfortran           -m64 -c -o physics_types.fppized.o -I. -Iinclude -Inetcdf/include -g physics_types.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 time_utils.F90 -o time_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o time_utils.fppized.o -I. -Iinclude -Inetcdf/include -g time_utils.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 repro_sum_mod.F90 -o repro_sum_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o repro_sum_mod.fppized.o -I. -Iinclude -Inetcdf/include -g repro_sum_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 phys_gmean.F90 -o phys_gmean.fppized.f90
/usr/bin/gfortran           -m64 -c -o phys_gmean.fppized.o -I. -Iinclude -Inetcdf/include -g phys_gmean.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mo_constants.F90 -o mo_constants.fppized.f90
/usr/bin/gfortran           -m64 -c -o mo_constants.fppized.o -I. -Iinclude -Inetcdf/include -g mo_constants.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_types.F90 -o m_types.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_types.fppized.o -I. -Iinclude -Inetcdf/include -g m_types.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mo_flbc.F90 -o mo_flbc.fppized.f90
/usr/bin/gfortran           -m64 -c -o mo_flbc.fppized.o -I. -Iinclude -Inetcdf/include -g mo_flbc.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 chem_surfvals.F90 -o chem_surfvals.fppized.f90
/usr/bin/gfortran           -m64 -c -o chem_surfvals.fppized.o -I. -Iinclude -Inetcdf/include -g chem_surfvals.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cam_history_buffers.F90 -o cam_history_buffers.fppized.f90
/usr/bin/gfortran           -m64 -c -o cam_history_buffers.fppized.o -I. -Iinclude -Inetcdf/include -g cam_history_buffers.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 filenames.F90 -o filenames.fppized.f90
/usr/bin/gfortran           -m64 -c -o filenames.fppized.o -I. -Iinclude -Inetcdf/include -g filenames.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cosp_share.F90 -o cosp_share.fppized.f90
/usr/bin/gfortran           -m64 -c -o cosp_share.fppized.o -I. -Iinclude -Inetcdf/include -g cosp_share.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 interp_mod.F90 -o interp_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o interp_mod.fppized.o -I. -Iinclude -Inetcdf/include -g interp_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cam_history.F90 -o cam_history.fppized.f90
/usr/bin/gfortran           -m64 -c -o cam_history.fppized.o -I. -Iinclude -Inetcdf/include -g cam_history.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 advect_tend.F90 -o advect_tend.fppized.f90
/usr/bin/gfortran           -m64 -c -o advect_tend.fppized.o -I. -Iinclude -Inetcdf/include -g advect_tend.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 phys_buffer.F90 -o phys_buffer.fppized.f90
/usr/bin/gfortran           -m64 -c -o phys_buffer.fppized.o -I. -Iinclude -Inetcdf/include -g phys_buffer.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ghg_data.F90 -o ghg_data.fppized.f90
/usr/bin/gfortran           -m64 -c -o ghg_data.fppized.o -I. -Iinclude -Inetcdf/include -g ghg_data.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 radconstants.F90 -o radconstants.fppized.f90
/usr/bin/gfortran           -m64 -c -o radconstants.fppized.o -I. -Iinclude -Inetcdf/include -g radconstants.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 radae.F90 -o radae.fppized.f90
/usr/bin/gfortran           -m64 -c -o radae.fppized.o -I. -Iinclude -Inetcdf/include -g radae.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 quicksort.F90 -o quicksort.fppized.f90
/usr/bin/gfortran           -m64 -c -o quicksort.fppized.o -I. -Iinclude -Inetcdf/include -g quicksort.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 radlw.F90 -o radlw.fppized.f90
/usr/bin/gfortran           -m64 -c -o radlw.fppized.o -I. -Iinclude -Inetcdf/include -g radlw.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pkg_cldoptics.F90 -o pkg_cldoptics.fppized.f90
/usr/bin/gfortran           -m64 -c -o pkg_cldoptics.fppized.o -I. -Iinclude -Inetcdf/include -g pkg_cldoptics.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 phys_debug_util.F90 -o phys_debug_util.fppized.f90
/usr/bin/gfortran           -m64 -c -o phys_debug_util.fppized.o -I. -Iinclude -Inetcdf/include -g phys_debug_util.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 conv_water.F90 -o conv_water.fppized.f90
/usr/bin/gfortran           -m64 -c -o conv_water.fppized.o -I. -Iinclude -Inetcdf/include -g conv_water.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 param_cldoptics.F90 -o param_cldoptics.fppized.f90
/usr/bin/gfortran           -m64 -c -o param_cldoptics.fppized.o -I. -Iinclude -Inetcdf/include -g param_cldoptics.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mo_util.F90 -o mo_util.fppized.f90
/usr/bin/gfortran           -m64 -c -o mo_util.fppized.o -I. -Iinclude -Inetcdf/include -g mo_util.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 rad_solar_var.F90 -o rad_solar_var.fppized.f90
/usr/bin/gfortran           -m64 -c -o rad_solar_var.fppized.o -I. -Iinclude -Inetcdf/include -g rad_solar_var.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cmparray_mod.F90 -o cmparray_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o cmparray_mod.fppized.o -I. -Iinclude -Inetcdf/include -g cmparray_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 radsw.F90 -o radsw.fppized.f90
/usr/bin/gfortran           -m64 -c -o radsw.fppized.o -I. -Iinclude -Inetcdf/include -g radsw.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 phys_prop.F90 -o phys_prop.fppized.f90
/usr/bin/gfortran           -m64 -c -o phys_prop.fppized.o -I. -Iinclude -Inetcdf/include -g phys_prop.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 rad_constituents.F90 -o rad_constituents.fppized.f90
/usr/bin/gfortran           -m64 -c -o rad_constituents.fppized.o -I. -Iinclude -Inetcdf/include -g rad_constituents.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 wv_saturation.F90 -o wv_saturation.fppized.f90
/usr/bin/gfortran           -m64 -c -o wv_saturation.fppized.o -I. -Iinclude -Inetcdf/include -g wv_saturation.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 modal_aer_opt.F90 -o modal_aer_opt.fppized.f90
/usr/bin/gfortran           -m64 -c -o modal_aer_opt.fppized.o -I. -Iinclude -Inetcdf/include -g modal_aer_opt.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 aer_rad_props.F90 -o aer_rad_props.fppized.f90
/usr/bin/gfortran           -m64 -c -o aer_rad_props.fppized.o -I. -Iinclude -Inetcdf/include -g aer_rad_props.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 camsrfexch_types.F90 -o camsrfexch_types.fppized.f90
/usr/bin/gfortran           -m64 -c -o camsrfexch_types.fppized.o -I. -Iinclude -Inetcdf/include -g camsrfexch_types.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 radiation_data.F90 -o radiation_data.fppized.f90
/usr/bin/gfortran           -m64 -c -o radiation_data.fppized.o -I. -Iinclude -Inetcdf/include -g radiation_data.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cosp_constants.F90 -o cosp_constants.fppized.f90
/usr/bin/gfortran           -m64 -c -o cosp_constants.fppized.o -I. -Iinclude -Inetcdf/include -g cosp_constants.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cosp_utils.F90 -o cosp_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o cosp_utils.fppized.o -I. -Iinclude -Inetcdf/include -g cosp_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o radar_simulator_types.o -I. -Iinclude -Inetcdf/include -g radar_simulator_types.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cosp_types.F90 -o cosp_types.fppized.f90
/usr/bin/gfortran           -m64 -c -o cosp_types.fppized.o -I. -Iinclude -Inetcdf/include -g cosp_types.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 modis_simulator.F90 -o modis_simulator.fppized.f90
/usr/bin/gfortran           -m64 -c -o modis_simulator.fppized.o -I. -Iinclude -Inetcdf/include -g modis_simulator.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cosp_modis_simulator.F90 -o cosp_modis_simulator.fppized.f90
/usr/bin/gfortran           -m64 -c -o cosp_modis_simulator.fppized.o -I. -Iinclude -Inetcdf/include -g cosp_modis_simulator.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cosp_lidar.F90 -o cosp_lidar.fppized.f90
/usr/bin/gfortran           -m64 -c -o cosp_lidar.fppized.o -I. -Iinclude -Inetcdf/include -g cosp_lidar.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cosp_misr_simulator.F90 -o cosp_misr_simulator.fppized.f90
/usr/bin/gfortran           -m64 -c -o cosp_misr_simulator.fppized.o -I. -Iinclude -Inetcdf/include -g cosp_misr_simulator.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 llnl_stats.F90 -o llnl_stats.fppized.f90
/usr/bin/gfortran           -m64 -c -o llnl_stats.fppized.o -I. -Iinclude -Inetcdf/include -g llnl_stats.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 lmd_ipsl_stats.F90 -o lmd_ipsl_stats.fppized.f90
/usr/bin/gfortran           -m64 -c -o lmd_ipsl_stats.fppized.o -I. -Iinclude -Inetcdf/include -g lmd_ipsl_stats.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cosp_stats.F90 -o cosp_stats.fppized.f90
/usr/bin/gfortran           -m64 -c -o cosp_stats.fppized.o -I. -Iinclude -Inetcdf/include -g cosp_stats.fppized.f90
/usr/bin/gfortran           -m64 -c -o atmos_lib.o -I. -Iinclude -Inetcdf/include -g atmos_lib.f90
/usr/bin/gfortran           -m64 -c -o mrgrnk.o -I. -Iinclude -Inetcdf/include -g mrgrnk.f90
/usr/bin/gfortran           -m64 -c -o array_lib.o -I. -Iinclude -Inetcdf/include -g array_lib.f90
/usr/bin/gfortran           -m64 -c -o format_input.o -I. -Iinclude -Inetcdf/include -g format_input.f90
/usr/bin/gfortran           -m64 -c -o math_lib.o -I. -Iinclude -Inetcdf/include -g math_lib.f90
/usr/bin/gfortran           -m64 -c -o optics_lib.o -I. -Iinclude -Inetcdf/include -g optics_lib.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cosp_radar.F90 -o cosp_radar.fppized.f90
/usr/bin/gfortran           -m64 -c -o cosp_radar.fppized.o -I. -Iinclude -Inetcdf/include -g cosp_radar.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cosp_isccp_simulator.F90 -o cosp_isccp_simulator.fppized.f90
/usr/bin/gfortran           -m64 -c -o cosp_isccp_simulator.fppized.o -I. -Iinclude -Inetcdf/include -g cosp_isccp_simulator.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cosp_simulator.F90 -o cosp_simulator.fppized.f90
/usr/bin/gfortran           -m64 -c -o cosp_simulator.fppized.o -I. -Iinclude -Inetcdf/include -g cosp_simulator.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cosp.F90 -o cosp.fppized.f90
/usr/bin/gfortran           -m64 -c -o cosp.fppized.o -I. -Iinclude -Inetcdf/include -g cosp.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cospsimulator_intr.F90 -o cospsimulator_intr.fppized.f90
/usr/bin/gfortran           -m64 -c -o cospsimulator_intr.fppized.o -I. -Iinclude -Inetcdf/include -g cospsimulator_intr.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 chemistry.F90 -o chemistry.fppized.f90
/usr/bin/gfortran           -m64 -c -o chemistry.fppized.o -I. -Iinclude -Inetcdf/include -g chemistry.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 radheat.F90 -o radheat.fppized.f90
/usr/bin/gfortran           -m64 -c -o radheat.fppized.o -I. -Iinclude -Inetcdf/include -g radheat.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 radiation.F90 -o radiation.fppized.f90
/usr/bin/gfortran           -m64 -c -o radiation.fppized.o -I. -Iinclude -Inetcdf/include -g radiation.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 horizontal_interpolate.F90 -o horizontal_interpolate.fppized.f90
/usr/bin/gfortran           -m64 -c -o horizontal_interpolate.fppized.o -I. -Iinclude -Inetcdf/include -g horizontal_interpolate.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 polar_avg.F90 -o polar_avg.fppized.f90
/usr/bin/gfortran           -m64 -c -o polar_avg.fppized.o -I. -Iinclude -Inetcdf/include -g polar_avg.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 tracer_data.F90 -o tracer_data.fppized.f90
/usr/bin/gfortran           -m64 -c -o tracer_data.fppized.o -I. -Iinclude -Inetcdf/include -g tracer_data.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 prescribed_ghg.F90 -o prescribed_ghg.fppized.f90
/usr/bin/gfortran           -m64 -c -o prescribed_ghg.fppized.o -I. -Iinclude -Inetcdf/include -g prescribed_ghg.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 prescribed_aero.F90 -o prescribed_aero.fppized.f90
/usr/bin/gfortran           -m64 -c -o prescribed_aero.fppized.o -I. -Iinclude -Inetcdf/include -g prescribed_aero.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 trb_mtn_stress.F90 -o trb_mtn_stress.fppized.f90
/usr/bin/gfortran           -m64 -c -o trb_mtn_stress.fppized.o -I. -Iinclude -Inetcdf/include -g trb_mtn_stress.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 phys_debug.F90 -o phys_debug.fppized.f90
/usr/bin/gfortran           -m64 -c -o phys_debug.fppized.o -I. -Iinclude -Inetcdf/include -g phys_debug.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 hb_diff.F90 -o hb_diff.fppized.f90
/usr/bin/gfortran           -m64 -c -o hb_diff.fppized.o -I. -Iinclude -Inetcdf/include -g hb_diff.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 upper_bc.F90 -o upper_bc.fppized.f90
/usr/bin/gfortran           -m64 -c -o upper_bc.fppized.o -I. -Iinclude -Inetcdf/include -g upper_bc.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 molec_diff.F90 -o molec_diff.fppized.f90
/usr/bin/gfortran           -m64 -c -o molec_diff.fppized.o -I. -Iinclude -Inetcdf/include -g molec_diff.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 diffusion_solver.F90 -o diffusion_solver.fppized.f90
/usr/bin/gfortran           -m64 -c -o diffusion_solver.fppized.o -I. -Iinclude -Inetcdf/include -g diffusion_solver.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 eddy_diff.F90 -o eddy_diff.fppized.f90
/usr/bin/gfortran           -m64 -c -o eddy_diff.fppized.o -I. -Iinclude -Inetcdf/include -g eddy_diff.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 vertical_diffusion.F90 -o vertical_diffusion.fppized.f90
/usr/bin/gfortran           -m64 -c -o vertical_diffusion.fppized.o -I. -Iinclude -Inetcdf/include -g vertical_diffusion.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 boundarydata.F90 -o boundarydata.fppized.f90
/usr/bin/gfortran           -m64 -c -o boundarydata.fppized.o -I. -Iinclude -Inetcdf/include -g boundarydata.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cam3_ozone_data.F90 -o cam3_ozone_data.fppized.f90
/usr/bin/gfortran           -m64 -c -o cam3_ozone_data.fppized.o -I. -Iinclude -Inetcdf/include -g cam3_ozone_data.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 aoa_tracers.F90 -o aoa_tracers.fppized.f90
/usr/bin/gfortran           -m64 -c -o aoa_tracers.fppized.o -I. -Iinclude -Inetcdf/include -g aoa_tracers.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 iondrag.F90 -o iondrag.fppized.f90
/usr/bin/gfortran           -m64 -c -o iondrag.fppized.o -I. -Iinclude -Inetcdf/include -g iondrag.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cam3_aero_data.F90 -o cam3_aero_data.fppized.f90
/usr/bin/gfortran           -m64 -c -o cam3_aero_data.fppized.o -I. -Iinclude -Inetcdf/include -g cam3_aero_data.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 tracers_suite.F90 -o tracers_suite.fppized.f90
/usr/bin/gfortran           -m64 -c -o tracers_suite.fppized.o -I. -Iinclude -Inetcdf/include -g tracers_suite.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 tracers.F90 -o tracers.fppized.f90
/usr/bin/gfortran           -m64 -c -o tracers.fppized.o -I. -Iinclude -Inetcdf/include -g tracers.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 tropopause.F90 -o tropopause.fppized.f90
/usr/bin/gfortran           -m64 -c -o tropopause.fppized.o -I. -Iinclude -Inetcdf/include -g tropopause.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 prescribed_volcaero.F90 -o prescribed_volcaero.fppized.f90
/usr/bin/gfortran           -m64 -c -o prescribed_volcaero.fppized.o -I. -Iinclude -Inetcdf/include -g prescribed_volcaero.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 prescribed_ozone.F90 -o prescribed_ozone.fppized.f90
/usr/bin/gfortran           -m64 -c -o prescribed_ozone.fppized.o -I. -Iinclude -Inetcdf/include -g prescribed_ozone.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 aircraft_emit.F90 -o aircraft_emit.fppized.f90
/usr/bin/gfortran           -m64 -c -o aircraft_emit.fppized.o -I. -Iinclude -Inetcdf/include -g aircraft_emit.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 modal_aero_deposition.F90 -o modal_aero_deposition.fppized.f90
/usr/bin/gfortran           -m64 -c -o modal_aero_deposition.fppized.o -I. -Iinclude -Inetcdf/include -g modal_aero_deposition.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 aerodep_flx.F90 -o aerodep_flx.fppized.f90
/usr/bin/gfortran           -m64 -c -o aerodep_flx.fppized.o -I. -Iinclude -Inetcdf/include -g aerodep_flx.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 advnce.F90 -o advnce.fppized.f90
/usr/bin/gfortran           -m64 -c -o advnce.fppized.o -I. -Iinclude -Inetcdf/include -g advnce.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 drydep_mod.F90 -o drydep_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o drydep_mod.fppized.o -I. -Iinclude -Inetcdf/include -g drydep_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 wetdep.F90 -o wetdep.fppized.f90
/usr/bin/gfortran           -m64 -c -o wetdep.fppized.o -I. -Iinclude -Inetcdf/include -g wetdep.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 dust_sediment_mod.F90 -o dust_sediment_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o dust_sediment_mod.fppized.o -I. -Iinclude -Inetcdf/include -g dust_sediment_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 dust_intr.F90 -o dust_intr.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 error_function.F90 -o error_function.fppized.f90
/usr/bin/gfortran           -m64 -c -o error_function.fppized.o -I. -Iinclude -Inetcdf/include -g error_function.fppized.f90
/usr/bin/gfortran           -m64 -c -o dust_intr.fppized.o -I. -Iinclude -Inetcdf/include -g dust_intr.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 progseasalts_intr.F90 -o progseasalts_intr.fppized.f90
/usr/bin/gfortran           -m64 -c -o progseasalts_intr.fppized.o -I. -Iinclude -Inetcdf/include -g progseasalts_intr.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 scyc.F90 -o scyc.fppized.f90
/usr/bin/gfortran           -m64 -c -o scyc.fppized.o -I. -Iinclude -Inetcdf/include -g scyc.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 aerosol_intr.F90 -o aerosol_intr.fppized.f90
/usr/bin/gfortran           -m64 -c -o aerosol_intr.fppized.o -I. -Iinclude -Inetcdf/include -g aerosol_intr.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 history_scam.F90 -o history_scam.fppized.f90
/usr/bin/gfortran           -m64 -c -o history_scam.fppized.o -I. -Iinclude -Inetcdf/include -g history_scam.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 xpavg_mod.F90 -o xpavg_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o xpavg_mod.fppized.o -I. -Iinclude -Inetcdf/include -g xpavg_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ncdio_atm.F90 -o ncdio_atm.fppized.f90
/usr/bin/gfortran           -m64 -c -o ncdio_atm.fppized.o -I. -Iinclude -Inetcdf/include -g ncdio_atm.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 metdata.F90 -o metdata.fppized.f90
/usr/bin/gfortran           -m64 -c -o metdata.fppized.o -I. -Iinclude -Inetcdf/include -g metdata.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 co2_data_flux.F90 -o co2_data_flux.fppized.f90
/usr/bin/gfortran           -m64 -c -o co2_data_flux.fppized.o -I. -Iinclude -Inetcdf/include -g co2_data_flux.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 co2_cycle.F90 -o co2_cycle.fppized.f90
/usr/bin/gfortran           -m64 -c -o co2_cycle.fppized.o -I. -Iinclude -Inetcdf/include -g co2_cycle.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 buffer.F90 -o buffer.fppized.f90
/usr/bin/gfortran           -m64 -c -o buffer.fppized.o -I. -Iinclude -Inetcdf/include -g buffer.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 comsrf.F90 -o comsrf.fppized.f90
/usr/bin/gfortran           -m64 -c -o comsrf.fppized.o -I. -Iinclude -Inetcdf/include -g comsrf.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 restart_physics.F90 -o restart_physics.fppized.f90
/usr/bin/gfortran           -m64 -c -o restart_physics.fppized.o -I. -Iinclude -Inetcdf/include -g restart_physics.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pfixer.F90 -o pfixer.fppized.f90
/usr/bin/gfortran           -m64 -c -o pfixer.fppized.o -I. -Iinclude -Inetcdf/include -g pfixer.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ctem.F90 -o ctem.fppized.f90
/usr/bin/gfortran           -m64 -c -o ctem.fppized.o -I. -Iinclude -Inetcdf/include -g ctem.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 diag_module.F90 -o diag_module.fppized.f90
/usr/bin/gfortran           -m64 -c -o diag_module.fppized.o -I. -Iinclude -Inetcdf/include -g diag_module.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 dyn_comp.F90 -o dyn_comp.fppized.f90
/usr/bin/gfortran           -m64 -c -o dyn_comp.fppized.o -I. -Iinclude -Inetcdf/include -g dyn_comp.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 dyn_internal_state.F90 -o dyn_internal_state.fppized.f90
/usr/bin/gfortran           -m64 -c -o dyn_internal_state.fppized.o -I. -Iinclude -Inetcdf/include -g dyn_internal_state.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 restart_dynamics.F90 -o restart_dynamics.fppized.f90
/usr/bin/gfortran           -m64 -c -o restart_dynamics.fppized.o -I. -Iinclude -Inetcdf/include -g restart_dynamics.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cam_restart.F90 -o cam_restart.fppized.f90
/usr/bin/gfortran           -m64 -c -o cam_restart.fppized.o -I. -Iinclude -Inetcdf/include -g cam_restart.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 readinitial.F90 -o readinitial.fppized.f90
/usr/bin/gfortran           -m64 -c -o readinitial.fppized.o -I. -Iinclude -Inetcdf/include -g readinitial.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 history_defaults.F90 -o history_defaults.fppized.f90
/usr/bin/gfortran           -m64 -c -o history_defaults.fppized.o -I. -Iinclude -Inetcdf/include -g history_defaults.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 uw_conv.F90 -o uw_conv.fppized.f90
/usr/bin/gfortran           -m64 -c -o uw_conv.fppized.o -I. -Iinclude -Inetcdf/include -g uw_conv.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 uwshcu.F90 -o uwshcu.fppized.f90
/usr/bin/gfortran           -m64 -c -o uwshcu.fppized.o -I. -Iinclude -Inetcdf/include -g uwshcu.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cldwat.F90 -o cldwat.fppized.f90
/usr/bin/gfortran           -m64 -c -o cldwat.fppized.o -I. -Iinclude -Inetcdf/include -g cldwat.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 zm_conv.F90 -o zm_conv.fppized.f90
/usr/bin/gfortran           -m64 -c -o zm_conv.fppized.o -I. -Iinclude -Inetcdf/include -g zm_conv.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 hk_conv.F90 -o hk_conv.fppized.f90
/usr/bin/gfortran           -m64 -c -o hk_conv.fppized.o -I. -Iinclude -Inetcdf/include -g hk_conv.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 convect_shallow.F90 -o convect_shallow.fppized.f90
/usr/bin/gfortran           -m64 -c -o convect_shallow.fppized.o -I. -Iinclude -Inetcdf/include -g convect_shallow.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cloud_fraction.F90 -o cloud_fraction.fppized.f90
/usr/bin/gfortran           -m64 -c -o cloud_fraction.fppized.o -I. -Iinclude -Inetcdf/include -g cloud_fraction.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cldwat2m_macro.F90 -o cldwat2m_macro.fppized.f90
/usr/bin/gfortran           -m64 -c -o cldwat2m_macro.fppized.o -I. -Iinclude -Inetcdf/include -g cldwat2m_macro.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ndrop.F90 -o ndrop.fppized.f90
/usr/bin/gfortran           -m64 -c -o ndrop.fppized.o -I. -Iinclude -Inetcdf/include -g ndrop.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cldwat2m_micro.F90 -o cldwat2m_micro.fppized.f90
/usr/bin/gfortran           -m64 -c -o cldwat2m_micro.fppized.o -I. -Iinclude -Inetcdf/include -g cldwat2m_micro.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 microp_aero.F90 -o microp_aero.fppized.f90
/usr/bin/gfortran           -m64 -c -o microp_aero.fppized.o -I. -Iinclude -Inetcdf/include -g microp_aero.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 microp_driver.F90 -o microp_driver.fppized.f90
/usr/bin/gfortran           -m64 -c -o microp_driver.fppized.o -I. -Iinclude -Inetcdf/include -g microp_driver.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pkg_cld_sediment.F90 -o pkg_cld_sediment.fppized.f90
/usr/bin/gfortran           -m64 -c -o pkg_cld_sediment.fppized.o -I. -Iinclude -Inetcdf/include -g pkg_cld_sediment.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 stratiform.F90 -o stratiform.fppized.f90
/usr/bin/gfortran           -m64 -c -o stratiform.fppized.o -I. -Iinclude -Inetcdf/include -g stratiform.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 inidat.F90 -o inidat.fppized.f90
/usr/bin/gfortran           -m64 -c -o inidat.fppized.o -I. -Iinclude -Inetcdf/include -g inidat.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 startup_initialconds.F90 -o startup_initialconds.fppized.f90
/usr/bin/gfortran           -m64 -c -o startup_initialconds.fppized.o -I. -Iinclude -Inetcdf/include -g startup_initialconds.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 inital.F90 -o inital.fppized.f90
/usr/bin/gfortran           -m64 -c -o inital.fppized.o -I. -Iinclude -Inetcdf/include -g inital.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 check_energy.F90 -o check_energy.fppized.f90
/usr/bin/gfortran           -m64 -c -o check_energy.fppized.o -I. -Iinclude -Inetcdf/include -g check_energy.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 dp_coupling.F90 -o dp_coupling.fppized.f90
/usr/bin/gfortran           -m64 -c -o dp_coupling.fppized.o -I. -Iinclude -Inetcdf/include -g dp_coupling.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 fv_prints.F90 -o fv_prints.fppized.f90
/usr/bin/gfortran           -m64 -c -o fv_prints.fppized.o -I. -Iinclude -Inetcdf/include -g fv_prints.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 stepon.F90 -o stepon.fppized.f90
/usr/bin/gfortran           -m64 -c -o stepon.fppized.o -I. -Iinclude -Inetcdf/include -g stepon.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ionosphere.F90 -o ionosphere.fppized.f90
/usr/bin/gfortran           -m64 -c -o ionosphere.fppized.o -I. -Iinclude -Inetcdf/include -g ionosphere.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cloud_diagnostics.F90 -o cloud_diagnostics.fppized.f90
/usr/bin/gfortran           -m64 -c -o cloud_diagnostics.fppized.o -I. -Iinclude -Inetcdf/include -g cloud_diagnostics.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cloud_rad_props.F90 -o cloud_rad_props.fppized.f90
/usr/bin/gfortran           -m64 -c -o cloud_rad_props.fppized.o -I. -Iinclude -Inetcdf/include -g cloud_rad_props.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 tidal_diag.F90 -o tidal_diag.fppized.f90
/usr/bin/gfortran           -m64 -c -o tidal_diag.fppized.o -I. -Iinclude -Inetcdf/include -g tidal_diag.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 constituent_burden.F90 -o constituent_burden.fppized.f90
/usr/bin/gfortran           -m64 -c -o constituent_burden.fppized.o -I. -Iinclude -Inetcdf/include -g constituent_burden.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cam_diagnostics.F90 -o cam_diagnostics.fppized.f90
/usr/bin/gfortran           -m64 -c -o cam_diagnostics.fppized.o -I. -Iinclude -Inetcdf/include -g cam_diagnostics.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 flux_avg.F90 -o flux_avg.fppized.f90
/usr/bin/gfortran           -m64 -c -o flux_avg.fppized.o -I. -Iinclude -Inetcdf/include -g flux_avg.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 macrop_driver.F90 -o macrop_driver.fppized.f90
/usr/bin/gfortran           -m64 -c -o macrop_driver.fppized.o -I. -Iinclude -Inetcdf/include -g macrop_driver.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 gw_drag.F90 -o gw_drag.fppized.f90
/usr/bin/gfortran           -m64 -c -o gw_drag.fppized.o -I. -Iinclude -Inetcdf/include -g gw_drag.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 zm_conv_intr.F90 -o zm_conv_intr.fppized.f90
/usr/bin/gfortran           -m64 -c -o zm_conv_intr.fppized.o -I. -Iinclude -Inetcdf/include -g zm_conv_intr.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 convect_deep.F90 -o convect_deep.fppized.f90
/usr/bin/gfortran           -m64 -c -o convect_deep.fppized.o -I. -Iinclude -Inetcdf/include -g convect_deep.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 rayleigh_friction.F90 -o rayleigh_friction.fppized.f90
/usr/bin/gfortran           -m64 -c -o rayleigh_friction.fppized.o -I. -Iinclude -Inetcdf/include -g rayleigh_friction.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 majorsp_diffusion.F90 -o majorsp_diffusion.fppized.f90
/usr/bin/gfortran           -m64 -c -o majorsp_diffusion.fppized.o -I. -Iinclude -Inetcdf/include -g majorsp_diffusion.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 sslt_rebin.F90 -o sslt_rebin.fppized.f90
/usr/bin/gfortran           -m64 -c -o sslt_rebin.fppized.o -I. -Iinclude -Inetcdf/include -g sslt_rebin.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 physpkg.F90 -o physpkg.fppized.f90
/usr/bin/gfortran           -m64 -c -o physpkg.fppized.o -I. -Iinclude -Inetcdf/include -g physpkg.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cam_comp.F90 -o cam_comp.fppized.f90
/usr/bin/gfortran           -m64 -c -o cam_comp.fppized.o -I. -Iinclude -Inetcdf/include -g cam_comp.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_infodata_mod.F90 -o seq_infodata_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_infodata_mod.fppized.o -I. -Iinclude -Inetcdf/include -g seq_infodata_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_cdata_mod.F90 -o seq_cdata_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_cdata_mod.fppized.o -I. -Iinclude -Inetcdf/include -g seq_cdata_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 runtime_opts.F90 -o runtime_opts.fppized.f90
/usr/bin/gfortran           -m64 -c -o runtime_opts.fppized.o -I. -Iinclude -Inetcdf/include -g runtime_opts.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cam_cpl_indices.F90 -o cam_cpl_indices.fppized.f90
/usr/bin/gfortran           -m64 -c -o cam_cpl_indices.fppized.o -I. -Iinclude -Inetcdf/include -g cam_cpl_indices.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_timemgr_mod.F90 -o seq_timemgr_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_timemgr_mod.fppized.o -I. -Iinclude -Inetcdf/include -g seq_timemgr_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 atm_comp_mct.F90 -o atm_comp_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o atm_comp_mct.fppized.o -I. -Iinclude -Inetcdf/include -g atm_comp_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 benergy.F90 -o benergy.fppized.f90
/usr/bin/gfortran           -m64 -c -o benergy.fppized.o -I. -Iinclude -Inetcdf/include -g benergy.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 binary_io.F90 -o binary_io.fppized.f90
/usr/bin/gfortran           -m64 -c -o binary_io.fppized.o -I. -Iinclude -Inetcdf/include -g binary_io.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 bnddyi.F90 -o bnddyi.fppized.f90
/usr/bin/gfortran           -m64 -c -o bnddyi.fppized.o -I. -Iinclude -Inetcdf/include -g bnddyi.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_flds_indices.F90 -o seq_flds_indices.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_flds_indices.fppized.o -I. -Iinclude -Inetcdf/include -g seq_flds_indices.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_diag_mct.F90 -o seq_diag_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_diag_mct.fppized.o -I. -Iinclude -Inetcdf/include -g seq_diag_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_rearr_mod.F90 -o seq_rearr_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_rearr_mod.fppized.o -I. -Iinclude -Inetcdf/include -g seq_rearr_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_ocnocn_mct.F90 -o map_ocnocn_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_ocnocn_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_ocnocn_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mrg_x2s_mct.F90 -o mrg_x2s_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o mrg_x2s_mct.fppized.o -I. -Iinclude -Inetcdf/include -g mrg_x2s_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ice_comp_mct.F90 -o ice_comp_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o ice_comp_mct.fppized.o -I. -Iinclude -Inetcdf/include -g ice_comp_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mrg_x2o_mct.F90 -o mrg_x2o_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o mrg_x2o_mct.fppized.o -I. -Iinclude -Inetcdf/include -g mrg_x2o_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_avdata_mod.F90 -o seq_avdata_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_avdata_mod.fppized.o -I. -Iinclude -Inetcdf/include -g seq_avdata_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_hist_mod.F90 -o seq_hist_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_hist_mod.fppized.o -I. -Iinclude -Inetcdf/include -g seq_hist_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mrg_x2a_mct.F90 -o mrg_x2a_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o mrg_x2a_mct.fppized.o -I. -Iinclude -Inetcdf/include -g mrg_x2a_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_iceocn_mct.F90 -o map_iceocn_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_iceocn_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_iceocn_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_map_mod.F90 -o seq_map_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_map_mod.fppized.o -I. -Iinclude -Inetcdf/include -g seq_map_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_atmlnd_mct.F90 -o map_atmlnd_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_atmlnd_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_atmlnd_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_atmice_mct.F90 -o map_atmice_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_atmice_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_atmice_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_snoglc_mct.F90 -o map_snoglc_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_snoglc_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_snoglc_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_atmocn_mct.F90 -o map_atmocn_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_atmocn_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_atmocn_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_domain_mct.F90 -o seq_domain_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_domain_mct.fppized.o -I. -Iinclude -Inetcdf/include -g seq_domain_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_rest_mod.F90 -o seq_rest_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_rest_mod.fppized.o -I. -Iinclude -Inetcdf/include -g seq_rest_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mrg_x2l_mct.F90 -o mrg_x2l_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o mrg_x2l_mct.fppized.o -I. -Iinclude -Inetcdf/include -g mrg_x2l_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_frac_mct.F90 -o seq_frac_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_frac_mct.fppized.o -I. -Iinclude -Inetcdf/include -g seq_frac_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_flux_mod.F90 -o shr_flux_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_flux_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_flux_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 seq_flux_mct.F90 -o seq_flux_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o seq_flux_mct.fppized.o -I. -Iinclude -Inetcdf/include -g seq_flux_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_lndlnd_mct.F90 -o map_lndlnd_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_lndlnd_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_lndlnd_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_iceice_mct.F90 -o map_iceice_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_iceice_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_iceice_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_glcglc_mct.F90 -o map_glcglc_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_glcglc_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_glcglc_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 lnd_comp_mct.F90 -o lnd_comp_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o lnd_comp_mct.fppized.o -I. -Iinclude -Inetcdf/include -g lnd_comp_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ocn_types.F90 -o ocn_types.fppized.f90
/usr/bin/gfortran           -m64 -c -o ocn_types.fppized.o -I. -Iinclude -Inetcdf/include -g ocn_types.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ocn_comp.F90 -o ocn_comp.fppized.f90
/usr/bin/gfortran           -m64 -c -o ocn_comp.fppized.o -I. -Iinclude -Inetcdf/include -g ocn_comp.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ocn_comp_mct.F90 -o ocn_comp_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o ocn_comp_mct.fppized.o -I. -Iinclude -Inetcdf/include -g ocn_comp_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_rofrof_mct.F90 -o map_rofrof_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_rofrof_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_rofrof_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_atmatm_mct.F90 -o map_atmatm_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_atmatm_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_atmatm_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_rofocn_mct.F90 -o map_rofocn_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_rofocn_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_rofocn_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_mem_mod.F90 -o shr_mem_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_mem_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_mem_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 map_snosno_mct.F90 -o map_snosno_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o map_snosno_mct.fppized.o -I. -Iinclude -Inetcdf/include -g map_snosno_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mrg_x2g_mct.F90 -o mrg_x2g_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o mrg_x2g_mct.fppized.o -I. -Iinclude -Inetcdf/include -g mrg_x2g_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mrg_x2i_mct.F90 -o mrg_x2i_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o mrg_x2i_mct.fppized.o -I. -Iinclude -Inetcdf/include -g mrg_x2i_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 glc_comp_mct.F90 -o glc_comp_mct.fppized.f90
/usr/bin/gfortran           -m64 -c -o glc_comp_mct.fppized.o -I. -Iinclude -Inetcdf/include -g glc_comp_mct.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ccsm_comp_mod.F90 -o ccsm_comp_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o ccsm_comp_mod.fppized.o -I. -Iinclude -Inetcdf/include -g ccsm_comp_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 ccsm_driver.F90 -o ccsm_driver.fppized.f90
/usr/bin/gfortran           -m64 -c -o ccsm_driver.fppized.o -I. -Iinclude -Inetcdf/include -g ccsm_driver.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 tp_core.F90 -o tp_core.fppized.f90
/usr/bin/gfortran           -m64 -c -o tp_core.fppized.o -I. -Iinclude -Inetcdf/include -g tp_core.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 sw_core.F90 -o sw_core.fppized.f90
/usr/bin/gfortran           -m64 -c -o sw_core.fppized.o -I. -Iinclude -Inetcdf/include -g sw_core.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cd_core.F90 -o cd_core.fppized.f90
/usr/bin/gfortran           -m64 -c -o cd_core.fppized.o -I. -Iinclude -Inetcdf/include -g cd_core.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cldsav.F90 -o cldsav.fppized.f90
/usr/bin/gfortran           -m64 -c -o cldsav.fppized.o -I. -Iinclude -Inetcdf/include -g cldsav.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o collective.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  collective.c
/usr/bin/gcc     -std=c99   -m64 -c -o comm.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  comm.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 comspe.F90 -o comspe.fppized.f90
/usr/bin/gfortran           -m64 -c -o comspe.fppized.o -I. -Iinclude -Inetcdf/include -g comspe.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 cpslec.F90 -o cpslec.fppized.f90
/usr/bin/gfortran           -m64 -c -o cpslec.fppized.o -I. -Iinclude -Inetcdf/include -g cpslec.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 d2a3dijk.F90 -o d2a3dijk.fppized.f90
/usr/bin/gfortran           -m64 -c -o d2a3dijk.fppized.o -I. -Iinclude -Inetcdf/include -g d2a3dijk.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 d2a3dikj.F90 -o d2a3dikj.fppized.f90
/usr/bin/gfortran           -m64 -c -o d2a3dikj.fppized.o -I. -Iinclude -Inetcdf/include -g d2a3dikj.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 dadadj.F90 -o dadadj.fppized.f90
/usr/bin/gfortran           -m64 -c -o dadadj.fppized.o -I. -Iinclude -Inetcdf/include -g dadadj.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 datetime.F90 -o datetime.fppized.f90
/usr/bin/gfortran           -m64 -c -o datetime.fppized.o -I. -Iinclude -Inetcdf/include -g datetime.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 diag_dynvar_ic.F90 -o diag_dynvar_ic.fppized.f90
/usr/bin/gfortran           -m64 -c -o diag_dynvar_ic.fppized.o -I. -Iinclude -Inetcdf/include -g diag_dynvar_ic.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mean_module.F90 -o mean_module.fppized.f90
/usr/bin/gfortran           -m64 -c -o mean_module.fppized.o -I. -Iinclude -Inetcdf/include -g mean_module.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 dryairm.F90 -o dryairm.fppized.f90
/usr/bin/gfortran           -m64 -c -o dryairm.fppized.o -I. -Iinclude -Inetcdf/include -g dryairm.fppized.f90
/usr/bin/gfortran           -m64 -c -o dsd.o -I. -Iinclude -Inetcdf/include -g dsd.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mapz_module.F90 -o mapz_module.fppized.f90
/usr/bin/gfortran           -m64 -c -o mapz_module.fppized.o -I. -Iinclude -Inetcdf/include -g mapz_module.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 epvd.F90 -o epvd.fppized.f90
/usr/bin/gfortran           -m64 -c -o epvd.fppized.o -I. -Iinclude -Inetcdf/include -g epvd.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 esinti.F90 -o esinti.fppized.f90
/usr/bin/gfortran           -m64 -c -o esinti.fppized.o -I. -Iinclude -Inetcdf/include -g esinti.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o f_wrappers.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  f_wrappers.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 fft99.F90 -o fft99.fppized.f90
/usr/bin/gfortran           -m64 -c -o fft99.fppized.o -I. -Iinclude -Inetcdf/include -g fft99.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 fill_module.F90 -o fill_module.fppized.f90
/usr/bin/gfortran           -m64 -c -o fill_module.fppized.o -I. -Iinclude -Inetcdf/include -g fill_module.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 fort.F90 -o fort.fppized.f90
/usr/bin/gfortran           -m64 -c -o fort.fppized.o -I. -Iinclude -Inetcdf/include -g fort.fppized.f90
/usr/bin/gfortran           -m64 -c -o gases.o -I. -Iinclude -Inetcdf/include -g gases.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 gauaw_mod.F90 -o gauaw_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o gauaw_mod.fppized.o -I. -Iinclude -Inetcdf/include -g gauaw_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 geopk.F90 -o geopk.fppized.f90
/usr/bin/gfortran           -m64 -c -o geopk.fppized.o -I. -Iinclude -Inetcdf/include -g geopk.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o get_zeits.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  get_zeits.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 gffgch.F90 -o gffgch.fppized.f90
/usr/bin/gfortran           -m64 -c -o gffgch.fppized.o -I. -Iinclude -Inetcdf/include -g gffgch.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o gptl.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  gptl.c
/usr/bin/gcc     -std=c99   -m64 -c -o gptl_papi.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  gptl_papi.c
/usr/bin/gcc     -std=c99   -m64 -c -o group.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  group.c
/usr/bin/gcc     -std=c99   -m64 -c -o handles.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  handles.c
/usr/bin/gfortran           -m64 -c -o hirsbtpar.o -I. -Iinclude -Inetcdf/include -g hirsbtpar.f90
/usr/bin/gfortran           -m64 -c -o hirsbt.o -I. -Iinclude -Inetcdf/include -g hirsbt.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 icarus.F90 -o icarus.fppized.f90
/usr/bin/gfortran           -m64 -c -o icarus.fppized.o -I. -Iinclude -Inetcdf/include -g icarus.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 initcom.F90 -o initcom.fppized.f90
/usr/bin/gfortran           -m64 -c -o initcom.fppized.o -I. -Iinclude -Inetcdf/include -g initcom.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 initindx.F90 -o initindx.fppized.f90
/usr/bin/gfortran           -m64 -c -o initindx.fppized.o -I. -Iinclude -Inetcdf/include -g initindx.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 intp_util.F90 -o intp_util.fppized.f90
/usr/bin/gfortran           -m64 -c -o intp_util.fppized.o -I. -Iinclude -Inetcdf/include -g intp_util.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 iop_surf.F90 -o iop_surf.fppized.f90
/usr/bin/gfortran           -m64 -c -o iop_surf.fppized.o -I. -Iinclude -Inetcdf/include -g iop_surf.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 lidar_simulator.F90 -o lidar_simulator.fppized.f90
/usr/bin/gfortran           -m64 -c -o lidar_simulator.fppized.o -I. -Iinclude -Inetcdf/include -g lidar_simulator.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o list.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  list.c
/usr/bin/gfortran           -m64 -c -o load_hydrometeor_classes.o -I. -Iinclude -Inetcdf/include -g load_hydrometeor_classes.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_AccumulatorComms.F90 -o m_AccumulatorComms.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_AccumulatorComms.fppized.o -I. -Iinclude -Inetcdf/include -g m_AccumulatorComms.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_AttrVectReduce.F90 -o m_AttrVectReduce.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_AttrVectReduce.fppized.o -I. -Iinclude -Inetcdf/include -g m_AttrVectReduce.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_StrTemplate.F90 -o m_StrTemplate.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_StrTemplate.fppized.o -I. -Iinclude -Inetcdf/include -g m_StrTemplate.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_FileResolv.F90 -o m_FileResolv.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_FileResolv.fppized.o -I. -Iinclude -Inetcdf/include -g m_FileResolv.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_Filename.F90 -o m_Filename.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Filename.fppized.o -I. -Iinclude -Inetcdf/include -g m_Filename.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_Merge.F90 -o m_Merge.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_Merge.fppized.o -I. -Iinclude -Inetcdf/include -g m_Merge.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_SpatialIntegralV.F90 -o m_SpatialIntegralV.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SpatialIntegralV.fppized.o -I. -Iinclude -Inetcdf/include -g m_SpatialIntegralV.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_SpatialIntegral.F90 -o m_SpatialIntegral.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_SpatialIntegral.fppized.o -I. -Iinclude -Inetcdf/include -g m_SpatialIntegral.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 m_zeit.F90 -o m_zeit.fppized.f90
/usr/bin/gfortran           -m64 -c -o m_zeit.fppized.o -I. -Iinclude -Inetcdf/include -g m_zeit.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 marsaglia.F90 -o marsaglia.fppized.f90
/usr/bin/gfortran           -m64 -c -o marsaglia.fppized.o -I. -Iinclude -Inetcdf/include -g marsaglia.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mcshallow.F90 -o mcshallow.fppized.f90
/usr/bin/gfortran           -m64 -c -o mcshallow.fppized.o -I. -Iinclude -Inetcdf/include -g mcshallow.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pio_quicksort.F90 -o pio_quicksort.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_quicksort.fppized.o -I. -Iinclude -Inetcdf/include -g pio_quicksort.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mct_rearrange.F90 -o mct_rearrange.fppized.f90
/usr/bin/gfortran           -m64 -c -o mct_rearrange.fppized.o -I. -Iinclude -Inetcdf/include -g mct_rearrange.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 miesubs.F90 -o miesubs.fppized.f90
/usr/bin/gfortran           -m64 -c -o miesubs.fppized.o -I. -Iinclude -Inetcdf/include -g miesubs.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mo_msis_ubc.F90 -o mo_msis_ubc.fppized.f90
/usr/bin/gfortran           -m64 -c -o mo_msis_ubc.fppized.o -I. -Iinclude -Inetcdf/include -g mo_msis_ubc.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mo_regrider.F90 -o mo_regrider.fppized.f90
/usr/bin/gfortran           -m64 -c -o mo_regrider.fppized.o -I. -Iinclude -Inetcdf/include -g mo_regrider.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 mo_solar_parms.F90 -o mo_solar_parms.fppized.f90
/usr/bin/gfortran           -m64 -c -o mo_solar_parms.fppized.o -I. -Iinclude -Inetcdf/include -g mo_solar_parms.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o mpi.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  mpi.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 msise00.F90 -o msise00.fppized.f90
/usr/bin/gfortran           -m64 -c -o msise00.fppized.o -I. -Iinclude -Inetcdf/include -g msise00.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 p_d_adjust.F90 -o p_d_adjust.fppized.f90
/usr/bin/gfortran           -m64 -c -o p_d_adjust.fppized.o -I. -Iinclude -Inetcdf/include -g p_d_adjust.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o pack.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  pack.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 par_vecsum.F90 -o par_vecsum.fppized.f90
/usr/bin/gfortran           -m64 -c -o par_vecsum.fppized.o -I. -Iinclude -Inetcdf/include -g par_vecsum.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 par_xsum.F90 -o par_xsum.fppized.f90
/usr/bin/gfortran           -m64 -c -o par_xsum.fppized.o -I. -Iinclude -Inetcdf/include -g par_xsum.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pf_to_mr.F90 -o pf_to_mr.fppized.f90
/usr/bin/gfortran           -m64 -c -o pf_to_mr.fppized.o -I. -Iinclude -Inetcdf/include -g pf_to_mr.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pio_msg_callbacks.F90 -o pio_msg_callbacks.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_msg_callbacks.fppized.o -I. -Iinclude -Inetcdf/include -g pio_msg_callbacks.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pio_msg_getput_callbacks.F90 -o pio_msg_getput_callbacks.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_msg_getput_callbacks.fppized.o -I. -Iinclude -Inetcdf/include -g pio_msg_getput_callbacks.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pio_nf_utils.F90 -o pio_nf_utils.fppized.f90
/usr/bin/gfortran           -m64 -c -o pio_nf_utils.fppized.o -I. -Iinclude -Inetcdf/include -g pio_nf_utils.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 pkez.F90 -o pkez.fppized.f90
/usr/bin/gfortran           -m64 -c -o pkez.fppized.o -I. -Iinclude -Inetcdf/include -g pkez.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 prec_scops.F90 -o prec_scops.fppized.f90
/usr/bin/gfortran           -m64 -c -o prec_scops.fppized.o -I. -Iinclude -Inetcdf/include -g prec_scops.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 puminterfaces.F90 -o puminterfaces.fppized.f90
/usr/bin/gfortran           -m64 -c -o puminterfaces.fppized.o -I. -Iinclude -Inetcdf/include -g puminterfaces.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 qneg3.F90 -o qneg3.fppized.f90
/usr/bin/gfortran           -m64 -c -o qneg3.fppized.o -I. -Iinclude -Inetcdf/include -g qneg3.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 qneg4.F90 -o qneg4.fppized.f90
/usr/bin/gfortran           -m64 -c -o qneg4.fppized.o -I. -Iinclude -Inetcdf/include -g qneg4.fppized.f90
/usr/bin/gfortran           -m64 -c -o radar_simulator.o -I. -Iinclude -Inetcdf/include -g radar_simulator.f90
/usr/bin/gcc     -std=c99   -m64 -c -o recv.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  recv.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 redistributemodule.F90 -o redistributemodule.fppized.f90
/usr/bin/gfortran           -m64 -c -o redistributemodule.fppized.o -I. -Iinclude -Inetcdf/include -g redistributemodule.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o req.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  req.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 scops.F90 -o scops.fppized.f90
/usr/bin/gfortran           -m64 -c -o scops.fppized.o -I. -Iinclude -Inetcdf/include -g scops.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o send.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  send.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 sgexx.F90 -o sgexx.fppized.f90
/usr/bin/gfortran           -m64 -c -o sgexx.fppized.o -I. -Iinclude -Inetcdf/include -g sgexx.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o shr_jlcp.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  shr_jlcp.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_msg_mod.F90 -o shr_msg_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_msg_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_msg_mod.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o shr_vmath_fwrap.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  shr_vmath_fwrap.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 shr_vmath_mod.F90 -o shr_vmath_mod.fppized.f90
/usr/bin/gfortran           -m64 -c -o shr_vmath_mod.fppized.o -I. -Iinclude -Inetcdf/include -g shr_vmath_mod.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 srchutil.F90 -o srchutil.fppized.f90
/usr/bin/gfortran           -m64 -c -o srchutil.fppized.o -I. -Iinclude -Inetcdf/include -g srchutil.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 srfxfer.F90 -o srfxfer.fppized.f90
/usr/bin/gfortran           -m64 -c -o srfxfer.fppized.o -I. -Iinclude -Inetcdf/include -g srfxfer.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 sulchem.F90 -o sulchem.fppized.f90
/usr/bin/gfortran           -m64 -c -o sulchem.fppized.o -I. -Iinclude -Inetcdf/include -g sulchem.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 te_map.F90 -o te_map.fppized.f90
/usr/bin/gfortran           -m64 -c -o te_map.fppized.o -I. -Iinclude -Inetcdf/include -g te_map.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o threadutil.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  threadutil.c
/usr/bin/gcc     -std=c99   -m64 -c -o time.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  time.c
/usr/bin/gcc     -std=c99   -m64 -c -o topology.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  topology.c
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 tphysac.F90 -o tphysac.fppized.f90
/usr/bin/gfortran           -m64 -c -o tphysac.fppized.o -I. -Iinclude -Inetcdf/include -g tphysac.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 tphysbc.F90 -o tphysbc.fppized.f90
/usr/bin/gfortran           -m64 -c -o tphysbc.fppized.o -I. -Iinclude -Inetcdf/include -g tphysbc.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 tphysidl.F90 -o tphysidl.fppized.f90
/usr/bin/gfortran           -m64 -c -o tphysidl.fppized.o -I. -Iinclude -Inetcdf/include -g tphysidl.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 trac2d.F90 -o trac2d.fppized.f90
/usr/bin/gfortran           -m64 -c -o trac2d.fppized.o -I. -Iinclude -Inetcdf/include -g trac2d.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 trunc.F90 -o trunc.fppized.f90
/usr/bin/gfortran           -m64 -c -o trunc.fppized.o -I. -Iinclude -Inetcdf/include -g trunc.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 tsinti.F90 -o tsinti.fppized.f90
/usr/bin/gfortran           -m64 -c -o tsinti.fppized.o -I. -Iinclude -Inetcdf/include -g tsinti.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 uv3s_update.F90 -o uv3s_update.fppized.f90
/usr/bin/gfortran           -m64 -c -o uv3s_update.fppized.o -I. -Iinclude -Inetcdf/include -g uv3s_update.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 virtem.F90 -o virtem.fppized.f90
/usr/bin/gfortran           -m64 -c -o virtem.fppized.o -I. -Iinclude -Inetcdf/include -g virtem.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 vrtmap.F90 -o vrtmap.fppized.f90
/usr/bin/gfortran           -m64 -c -o vrtmap.fppized.o -I. -Iinclude -Inetcdf/include -g vrtmap.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 wrap_mpi.F90 -o wrap_mpi.fppized.f90
/usr/bin/gfortran           -m64 -c -o wrap_mpi.fppized.o -I. -Iinclude -Inetcdf/include -g wrap_mpi.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 wrf_error_fatal.F90 -o wrf_error_fatal.fppized.f90
/usr/bin/gfortran           -m64 -c -o wrf_error_fatal.fppized.o -I. -Iinclude -Inetcdf/include -g wrf_error_fatal.fppized.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 wrf_message.F90 -o wrf_message.fppized.f90
/usr/bin/gfortran           -m64 -c -o wrf_message.fppized.o -I. -Iinclude -Inetcdf/include -g wrf_message.fppized.f90
/usr/bin/gfortran           -m64 -c -o zeff.o -I. -Iinclude -Inetcdf/include -g zeff.f90
specpp -DSPEC -DSPEC_CPU -DNDEBUG -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP -w -DHIDE_MPI -D_MPISERIAL -DNO_MPI2 -DSPEC_CASE_FLAG -DSPEC_LP64 zenith.F90 -o zenith.fppized.f90
/usr/bin/gfortran           -m64 -c -o zenith.fppized.o -I. -Iinclude -Inetcdf/include -g zenith.fppized.f90
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/attr.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/attr.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/dim.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/dim.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/error.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/error.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-attio.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-attio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-control.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-control.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-dim.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-dim.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-genatt.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-genatt.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-geninq.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-geninq.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-genvar.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-genvar.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-lib.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-lib.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-misc.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-misc.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-v2compat.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-v2compat.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-var1io.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-var1io.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-varaio.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-varaio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-vario.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-vario.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-varmio.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-varmio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-varsio.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-varsio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/libvers.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/libvers.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/nc.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/nc.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/ncx.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/ncx.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/posixio.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/posixio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/putget.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/putget.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/string.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/string.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/v1hpg.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/v1hpg.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/v2i.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/v2i.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/var.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/var.c
/usr/bin/gcc     -std=c99   -m64 -c -o spec_qsort/spec_qsort.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  spec_qsort/spec_qsort.c
/usr/bin/gfortran           -m64      -g     -DSPEC_CASE_FLAG     ESMF_BaseMod.fppized.o ESMF_BaseTimeMod.fppized.o ESMF_FractionMod.fppized.o ESMF_CalendarMod.fppized.o ESMF_TimeIntervalMod.fppized.o ESMF_Stubs.fppized.o ESMF_TimeMod.fppized.o ESMF_AlarmMod.fppized.o ESMF_ClockMod.fppized.o ESMF_AlarmClockMod.fppized.o ESMF_Mod.fppized.o cam_logfile.fppized.o debugutilitiesmodule.fppized.o decompmodule.fppized.o shr_kind_mod.fppized.o ghostmodule.fppized.o perf_utils.fppized.o shr_log_mod.fppized.o shr_mpi_mod.fppized.o shr_sys_mod.fppized.o shr_file_mod.fppized.o string_utils.fppized.o namelist_utils.fppized.o perf_mod.fppized.o mod_comm.fppized.o parutilitiesmodule.fppized.o mpishorthand.fppized.o abortutils.fppized.o units.fppized.o spmd_utils.fppized.o fv_control_mod.fppized.o pft_module.fppized.o dynamics_vars.fppized.o FVperf_module.fppized.o GPTLget_memusage.o GPTLprint_memusage.o GPTLutil.o MISR_simulator.fppized.o Meat.fppized.o pmgrid.fppized.o dycore.fppized.o pio_kinds.fppized.o pio_support.fppized.o pio_types.fppized.o pio_msg_mod.fppized.o alloc_mod.fppized.o pio_utils.fppized.o nf_mod.fppized.o pionfput_mod.fppized.o pionfatt_mod.fppized.o pio_spmd_utils.fppized.o calcdisplace_mod.fppized.o box_rearrange.fppized.o rearrange.fppized.o pionfread_mod.fppized.o iompi_mod.fppized.o pionfwrite_mod.fppized.o piodarray.fppized.o ionf_mod.fppized.o calcdecomp.fppized.o pio_mpi_utils.fppized.o piolib_mod.fppized.o pionfget_mod.fppized.o pio.fppized.o shr_timer_mod.fppized.o shr_string_mod.fppized.o shr_const_mod.fppized.o shr_cal_mod.fppized.o time_manager.fppized.o ppgrid.fppized.o physconst.fppized.o constituents.fppized.o commap.fppized.o infnan.fppized.o pspect.fppized.o rgrid.fppized.o spmd_dyn.fppized.o hycoef.fppized.o dyn_grid.fppized.o m_chars.fppized.o m_flow.fppized.o m_stdio.fppized.o m_mpif.fppized.o m_realkinds.fppized.o m_mpif90.fppized.o m_dropdead.fppized.o m_ioutil.fppized.o m_mpout.fppized.o m_die.fppized.o m_MergeSorts.fppized.o phys_grid.fppized.o ioFileMod.fppized.o cam_history_support.fppized.o cam_control_mod.fppized.o m_mall.fppized.o m_String.fppized.o m_rankMerge.fppized.o m_IndexBin_logical.fppized.o m_Permuter.fppized.o m_IndexBin_char.fppized.o m_IndexBin_integer.fppized.o m_SortingTools.fppized.o m_List.fppized.o m_TraceBack.fppized.o m_AttrVect.fppized.o m_GlobalMap.fppized.o m_FcComms.fppized.o m_MCTWorld.fppized.o m_GlobalSegMap.fppized.o m_AttrVectComms.fppized.o m_SparseMatrix.fppized.o m_SparseMatrixDecomp.fppized.o m_SparseMatrixComms.fppized.o m_Navigator.fppized.o m_GlobalToLocal.fppized.o m_SparseMatrixToMaps.fppized.o m_ConvertMaps.fppized.o m_ExchangeMaps.fppized.o m_Router.fppized.o m_Rearranger.fppized.o m_SparseMatrixPlus.fppized.o m_GeneralGrid.fppized.o m_Transfer.fppized.o m_inpak90.fppized.o m_GlobalSegMapComms.fppized.o m_Accumulator.fppized.o m_MatAttrVectMul.fppized.o m_GeneralGridComms.fppized.o mct_mod.fppized.o seq_comm_mct.fppized.o seq_drydep_mod.fppized.o seq_flds_mod.fppized.o seq_io_mod.fppized.o cam_pio_utils.fppized.o sat_hist.fppized.o solar_data.fppized.o shr_orb_mod.fppized.o shr_tInterp_mod.fppized.o shr_stream_mod.fppized.o shr_pcdf_mod.fppized.o shr_mct_mod.fppized.o shr_map_mod.fppized.o shr_ncread_mod.fppized.o shr_dmodel_mod.fppized.o shr_strdata_mod.fppized.o shr_scam_mod.fppized.o wrap_nf.fppized.o scamMod.fppized.o error_messages.fppized.o interpolate_data.fppized.o geopotential.fppized.o ref_pres.fppized.o phys_control.fppized.o physics_types.fppized.o time_utils.fppized.o repro_sum_mod.fppized.o phys_gmean.fppized.o mo_constants.fppized.o m_types.fppized.o mo_flbc.fppized.o chem_surfvals.fppized.o cam_history_buffers.fppized.o filenames.fppized.o cosp_share.fppized.o interp_mod.fppized.o cam_history.fppized.o advect_tend.fppized.o phys_buffer.fppized.o ghg_data.fppized.o radconstants.fppized.o radae.fppized.o quicksort.fppized.o radlw.fppized.o pkg_cldoptics.fppized.o phys_debug_util.fppized.o conv_water.fppized.o param_cldoptics.fppized.o mo_util.fppized.o rad_solar_var.fppized.o cmparray_mod.fppized.o radsw.fppized.o phys_prop.fppized.o rad_constituents.fppized.o wv_saturation.fppized.o modal_aer_opt.fppized.o aer_rad_props.fppized.o camsrfexch_types.fppized.o radiation_data.fppized.o cosp_constants.fppized.o cosp_utils.fppized.o radar_simulator_types.o cosp_types.fppized.o modis_simulator.fppized.o cosp_modis_simulator.fppized.o cosp_lidar.fppized.o cosp_misr_simulator.fppized.o llnl_stats.fppized.o lmd_ipsl_stats.fppized.o cosp_stats.fppized.o atmos_lib.o mrgrnk.o array_lib.o format_input.o math_lib.o optics_lib.o cosp_radar.fppized.o cosp_isccp_simulator.fppized.o cosp_simulator.fppized.o cosp.fppized.o cospsimulator_intr.fppized.o chemistry.fppized.o radheat.fppized.o radiation.fppized.o horizontal_interpolate.fppized.o polar_avg.fppized.o tracer_data.fppized.o prescribed_ghg.fppized.o prescribed_aero.fppized.o trb_mtn_stress.fppized.o phys_debug.fppized.o hb_diff.fppized.o upper_bc.fppized.o molec_diff.fppized.o diffusion_solver.fppized.o eddy_diff.fppized.o vertical_diffusion.fppized.o boundarydata.fppized.o cam3_ozone_data.fppized.o aoa_tracers.fppized.o iondrag.fppized.o cam3_aero_data.fppized.o tracers_suite.fppized.o tracers.fppized.o tropopause.fppized.o prescribed_volcaero.fppized.o prescribed_ozone.fppized.o aircraft_emit.fppized.o modal_aero_deposition.fppized.o aerodep_flx.fppized.o advnce.fppized.o drydep_mod.fppized.o wetdep.fppized.o dust_sediment_mod.fppized.o dust_intr.fppized.o progseasalts_intr.fppized.o scyc.fppized.o aerosol_intr.fppized.o history_scam.fppized.o xpavg_mod.fppized.o ncdio_atm.fppized.o metdata.fppized.o co2_data_flux.fppized.o co2_cycle.fppized.o buffer.fppized.o comsrf.fppized.o restart_physics.fppized.o pfixer.fppized.o ctem.fppized.o diag_module.fppized.o dyn_comp.fppized.o dyn_internal_state.fppized.o restart_dynamics.fppized.o cam_restart.fppized.o readinitial.fppized.o history_defaults.fppized.o error_function.fppized.o uw_conv.fppized.o uwshcu.fppized.o cldwat.fppized.o zm_conv.fppized.o hk_conv.fppized.o convect_shallow.fppized.o cloud_fraction.fppized.o cldwat2m_macro.fppized.o ndrop.fppized.o cldwat2m_micro.fppized.o microp_aero.fppized.o microp_driver.fppized.o pkg_cld_sediment.fppized.o stratiform.fppized.o inidat.fppized.o startup_initialconds.fppized.o inital.fppized.o check_energy.fppized.o dp_coupling.fppized.o fv_prints.fppized.o stepon.fppized.o ionosphere.fppized.o cloud_diagnostics.fppized.o cloud_rad_props.fppized.o tidal_diag.fppized.o constituent_burden.fppized.o cam_diagnostics.fppized.o flux_avg.fppized.o macrop_driver.fppized.o gw_drag.fppized.o zm_conv_intr.fppized.o convect_deep.fppized.o rayleigh_friction.fppized.o majorsp_diffusion.fppized.o sslt_rebin.fppized.o physpkg.fppized.o cam_comp.fppized.o seq_infodata_mod.fppized.o seq_cdata_mod.fppized.o runtime_opts.fppized.o cam_cpl_indices.fppized.o seq_timemgr_mod.fppized.o atm_comp_mct.fppized.o benergy.fppized.o binary_io.fppized.o bnddyi.fppized.o seq_flds_indices.fppized.o seq_diag_mct.fppized.o seq_rearr_mod.fppized.o map_ocnocn_mct.fppized.o mrg_x2s_mct.fppized.o ice_comp_mct.fppized.o mrg_x2o_mct.fppized.o seq_avdata_mod.fppized.o seq_hist_mod.fppized.o mrg_x2a_mct.fppized.o map_iceocn_mct.fppized.o seq_map_mod.fppized.o map_atmlnd_mct.fppized.o map_atmice_mct.fppized.o map_snoglc_mct.fppized.o map_atmocn_mct.fppized.o seq_domain_mct.fppized.o seq_rest_mod.fppized.o mrg_x2l_mct.fppized.o seq_frac_mct.fppized.o shr_flux_mod.fppized.o seq_flux_mct.fppized.o map_lndlnd_mct.fppized.o map_iceice_mct.fppized.o map_glcglc_mct.fppized.o lnd_comp_mct.fppized.o ocn_types.fppized.o ocn_comp.fppized.o ocn_comp_mct.fppized.o map_rofrof_mct.fppized.o map_atmatm_mct.fppized.o map_rofocn_mct.fppized.o shr_mem_mod.fppized.o map_snosno_mct.fppized.o mrg_x2g_mct.fppized.o mrg_x2i_mct.fppized.o glc_comp_mct.fppized.o ccsm_comp_mod.fppized.o ccsm_driver.fppized.o tp_core.fppized.o sw_core.fppized.o cd_core.fppized.o cldsav.fppized.o collective.o comm.o comspe.fppized.o cpslec.fppized.o d2a3dijk.fppized.o d2a3dikj.fppized.o dadadj.fppized.o datetime.fppized.o diag_dynvar_ic.fppized.o mean_module.fppized.o dryairm.fppized.o dsd.o mapz_module.fppized.o epvd.fppized.o esinti.fppized.o f_wrappers.o fft99.fppized.o fill_module.fppized.o fort.fppized.o gases.o gauaw_mod.fppized.o geopk.fppized.o get_zeits.o gffgch.fppized.o gptl.o gptl_papi.o group.o handles.o hirsbtpar.o hirsbt.o icarus.fppized.o initcom.fppized.o initindx.fppized.o intp_util.fppized.o iop_surf.fppized.o lidar_simulator.fppized.o list.o load_hydrometeor_classes.o m_AccumulatorComms.fppized.o m_AttrVectReduce.fppized.o m_StrTemplate.fppized.o m_FileResolv.fppized.o m_Filename.fppized.o m_Merge.fppized.o m_SpatialIntegralV.fppized.o m_SpatialIntegral.fppized.o m_zeit.fppized.o marsaglia.fppized.o mcshallow.fppized.o pio_quicksort.fppized.o mct_rearrange.fppized.o miesubs.fppized.o mo_msis_ubc.fppized.o mo_regrider.fppized.o mo_solar_parms.fppized.o mpi.o msise00.fppized.o p_d_adjust.fppized.o pack.o par_vecsum.fppized.o par_xsum.fppized.o pf_to_mr.fppized.o pio_msg_callbacks.fppized.o pio_msg_getput_callbacks.fppized.o pio_nf_utils.fppized.o pkez.fppized.o prec_scops.fppized.o puminterfaces.fppized.o qneg3.fppized.o qneg4.fppized.o radar_simulator.o recv.o redistributemodule.fppized.o req.o scops.fppized.o send.o sgexx.fppized.o shr_jlcp.o shr_msg_mod.fppized.o shr_vmath_fwrap.o shr_vmath_mod.fppized.o srchutil.fppized.o srfxfer.fppized.o sulchem.fppized.o te_map.fppized.o threadutil.o time.o topology.o tphysac.fppized.o tphysbc.fppized.o tphysidl.fppized.o trac2d.fppized.o trunc.fppized.o tsinti.fppized.o uv3s_update.fppized.o virtem.fppized.o vrtmap.fppized.o wrap_mpi.fppized.o wrf_error_fatal.fppized.o wrf_message.fppized.o zeff.o zenith.fppized.o netcdf/attr.o netcdf/dim.o netcdf/error.o netcdf/fort-attio.o netcdf/fort-control.o netcdf/fort-dim.o netcdf/fort-genatt.o netcdf/fort-geninq.o netcdf/fort-genvar.o netcdf/fort-lib.o netcdf/fort-misc.o netcdf/fort-v2compat.o netcdf/fort-var1io.o netcdf/fort-varaio.o netcdf/fort-vario.o netcdf/fort-varmio.o netcdf/fort-varsio.o netcdf/libvers.o netcdf/nc.o netcdf/ncx.o netcdf/posixio.o netcdf/putget.o netcdf/string.o netcdf/v1hpg.o netcdf/v2i.o netcdf/var.o netcdf/typeSizes.o netcdf/netcdf.o spec_qsort/spec_qsort.o                      -o cam4_r  
