#!/bin/bash
# Simple build script, potentially useful if building a GPL-redistributable
# version on a system *without* SPEC CPU2017.  See:
#
#     https://www.spec.org/cpu2017/Docs/licenses.html#GPLtarballs
#
# Note: if the benchmark uses "specpp", that is the freely-redistributable
#       preprocessor "filepp".   It is described at 
#         https://www.spec.org/cpu2017/Docs/utility.html#specpp  
#       and will need to be in your path.  You can find filepp sources as
#       modified by SPEC in redistributable_sources/modified/tools.src/harness-spec.tar.xz 
#---------------------------------------------------------------------------

/usr/bin/gfortran           -m64 -c -o netcdf/typeSizes.o -I. -Iinclude -Inetcdf/include -g netcdf/typeSizes.f90
/usr/bin/gfortran           -m64 -c -o netcdf/netcdf.o -I. -Iinclude -Inetcdf/include -g netcdf/netcdf.f90
/usr/bin/gfortran           -m64 -c -o validate-cam.o -I. -Iinclude -Inetcdf/include -g validate-cam.f90
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/attr.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/attr.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/dim.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/dim.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/error.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/error.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-attio.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-attio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-control.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-control.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-dim.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-dim.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-genatt.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-genatt.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-geninq.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-geninq.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-genvar.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-genvar.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-lib.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-lib.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-misc.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-misc.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-v2compat.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-v2compat.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-var1io.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-var1io.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-varaio.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-varaio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-vario.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-vario.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-varmio.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-varmio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/fort-varsio.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/fort-varsio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/libvers.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/libvers.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/nc.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/nc.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/ncx.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/ncx.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/posixio.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/posixio.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/putget.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/putget.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/string.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/string.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/v1hpg.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/v1hpg.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/v2i.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/v2i.c
/usr/bin/gcc     -std=c99   -m64 -c -o netcdf/var.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  netcdf/var.c
/usr/bin/gcc     -std=c99   -m64 -c -o spec_qsort/spec_qsort.o -DSPEC -DSPEC_CPU -DNDEBUG  -DNO_SHR_VMATH -DCO2A -DPERGRO -DPLON=144 -DPLAT=96 -DPLEV=26 -DPCNST=3 -DPCOLS=4 -DPTRM=1 -DPTRN=1 -DPTRK=1 -DSTAGGERED -D_NETCDF -DNO_R16 -I. -Iinclude -Inetcdf/include -DSPEC_AUTO_SUPPRESS_OPENMP  -DSPEC_AUTO_BYTEORDER=0x12345678 -g        -DSPEC_CASE_FLAG       -DSPEC_LP64  spec_qsort/spec_qsort.c
/usr/bin/gfortran           -m64      -g     -DSPEC_CASE_FLAG     validate-cam.o netcdf/attr.o netcdf/dim.o netcdf/error.o netcdf/fort-attio.o netcdf/fort-control.o netcdf/fort-dim.o netcdf/fort-genatt.o netcdf/fort-geninq.o netcdf/fort-genvar.o netcdf/fort-lib.o netcdf/fort-misc.o netcdf/fort-v2compat.o netcdf/fort-var1io.o netcdf/fort-varaio.o netcdf/fort-vario.o netcdf/fort-varmio.o netcdf/fort-varsio.o netcdf/libvers.o netcdf/nc.o netcdf/ncx.o netcdf/posixio.o netcdf/putget.o netcdf/string.o netcdf/v1hpg.o netcdf/v2i.o netcdf/var.o netcdf/typeSizes.o netcdf/netcdf.o spec_qsort/spec_qsort.o                      -o cam4_validate_527  
