 /*@@
   @file    InitSymBound.F
   @date    March 1999
   @author  Gerd Lanfermann
   @desc
            Sets the symmetries for the Einstein grid functions
   @enddesc
 @@*/

#include "cctk.h"
#include "cctk_Arguments.h"

#include "Symmetry.h"

static const char *rcsid = "$Header: /CCT/Projects/XiRel/SPEC2006/CactusBSSN/arrangements/CactusEinstein/ADMBase/src/InitSymBound.c,v 1.1.1.1 2009/02/03 01:02:30 jtao Exp $";

CCTK_FILEVERSION(CactusEinstein_Einstein_InitSymBound_c)

void Einstein_InitSymBound(CCTK_ARGUMENTS);

 /*@@
   @routine    Einstein_InitSymBound
   @date       March 1999
   @author     Gerd Lanfermann
   @desc 
               Sets the symmetries for the Einstein grid functions
   @enddesc 
   @calls     
   @calledby   
   @history 
 
   @endhistory 

@@*/

void Einstein_InitSymBound(CCTK_ARGUMENTS)
{
      
  DECLARE_CCTK_ARGUMENTS 
      
  int one;
  int sym[3];

  one = 1;
  
  sym[0] =  one;
  sym[1] =  one;
  sym[2] =  one;
  SetCartSymVN(cctkGH, sym,"admbase::gxx");
  SetCartSymVN(cctkGH, sym,"admbase::gyy");
  SetCartSymVN(cctkGH, sym,"admbase::gzz");
  sym[0] = -one;
  sym[1] = -one;
  sym[2] =  one;
  SetCartSymVN(cctkGH, sym,"admbase::gxy");
  sym[0] = -one;
  sym[1] =  one;
  sym[2] = -one;
  SetCartSymVN(cctkGH, sym,"admbase::gxz");
  sym[0] =  one;
  sym[1] = -one;
  sym[2] = -one;
  SetCartSymVN(cctkGH, sym,"admbase::gyz");
  
  sym[0] =  one;
  sym[1] =  one;
  sym[2] =  one;
  SetCartSymVN(cctkGH, sym,"admbase::kxx");
  SetCartSymVN(cctkGH, sym,"admbase::kyy");
  SetCartSymVN(cctkGH, sym,"admbase::kzz");
  sym[0] = -one;
  sym[1] = -one;
  sym[2] =  one;
  SetCartSymVN(cctkGH, sym,"admbase::kxy");
  sym[0] = -one;
  sym[1] =  one;
  sym[2] = -one;
  SetCartSymVN(cctkGH, sym,"admbase::kxz");
  sym[0] =  one;
  sym[1] = -one;
  sym[2] = -one;
  SetCartSymVN(cctkGH, sym,"admbase::kyz");
  
  sym[0] =  one;
  sym[1] =  one;
  sym[2] =  one;
  SetCartSymVN(cctkGH, sym,"admbase::alp");

  sym[0] = -one;
  sym[1] =  one;
  sym[2] =  one;
  SetCartSymVN(cctkGH, sym,"admbase::betax");
  sym[0] =  one;
  sym[1] = -one;
  sym[2] =  one;
  SetCartSymVN(cctkGH, sym,"admbase::betay");
  sym[0] =  one;
  sym[1] =  one;
  sym[2] = -one;
  SetCartSymVN(cctkGH, sym,"admbase::betaz");
  
  sym[0] =  one;
  sym[1] =  one;
  sym[2] =  one;
  SetCartSymVN(cctkGH, sym,"admbase::dtalp");

  sym[0] = -one;
  sym[1] =  one;
  sym[2] =  one;
  SetCartSymVN(cctkGH, sym,"admbase::dtbetax");
  sym[0] =  one;
  sym[1] = -one;
  sym[2] =  one;
  SetCartSymVN(cctkGH, sym,"admbase::dtbetay");
  sym[0] =  one;
  sym[1] =  one;
  sym[2] = -one;
  SetCartSymVN(cctkGH, sym,"admbase::dtbetaz");

  return;
}
