/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import org.jfree.util.Configuration;
import org.jfree.util.DefaultConfiguration;
import org.jfree.xml.CommentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class FrontendDefaultHandler
extends DefaultHandler
implements Configuration {
    public static final String CONTENTBASE_KEY = "content-base";
    private DefaultConfiguration parserConfiguration = new DefaultConfiguration();
    private Locator locator;
    private final CommentHandler commentHandler = new CommentHandler();

    protected FrontendDefaultHandler() {
    }

    public CommentHandler getCommentHandler() {
        return this.commentHandler;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public Locator getLocator() {
        return this.locator;
    }

    public String getConfigProperty(String key) {
        return this.getConfigProperty(key, null);
    }

    public String getConfigProperty(String key, String defaultValue) {
        return this.parserConfiguration.getConfigProperty(key, defaultValue);
    }

    public void setConfigProperty(String key, String value) {
        if (value == null) {
            this.parserConfiguration.remove((Object)key);
        } else {
            this.parserConfiguration.setProperty(key, value);
        }
    }

    public Enumeration getConfigProperties() {
        return this.parserConfiguration.getConfigProperties();
    }

    public abstract FrontendDefaultHandler newInstance();

    public Iterator findPropertyKeys(String prefix) {
        return this.parserConfiguration.findPropertyKeys(prefix);
    }

    public abstract Object getResult() throws SAXException;

    public URL getContentBase() {
        String contentBase = this.getConfigProperty(CONTENTBASE_KEY);
        if (contentBase == null) {
            return null;
        }
        try {
            return new URL(contentBase);
        }
        catch (MalformedURLException mfe) {
            throw new IllegalStateException("Content Base is illegal." + contentBase);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FrontendDefaultHandler o = (FrontendDefaultHandler)super.clone();
        o.parserConfiguration = (DefaultConfiguration)this.parserConfiguration.clone();
        return o;
    }
}

