/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.writer.coretypes;

import java.awt.Font;
import java.io.IOException;
import org.jfree.xml.writer.AbstractXmlWriteHandler;
import org.jfree.xml.writer.AttributeList;
import org.jfree.xml.writer.XMLWriter;
import org.jfree.xml.writer.XMLWriterException;

public class FontWriteHandler
extends AbstractXmlWriteHandler {
    @Override
    public void write(String tagName, Object object, XMLWriter writer, String mPlexAttribute, String mPlexValue) throws IOException, XMLWriterException {
        Font font = (Font)object;
        AttributeList attribs = new AttributeList();
        if (mPlexAttribute != null) {
            attribs.setAttribute(mPlexAttribute, mPlexValue);
        }
        attribs.setAttribute("family", font.getFamily());
        attribs.setAttribute("size", String.valueOf(font.getSize()));
        attribs.setAttribute("style", String.valueOf(this.getFontStyle(font)));
        writer.writeTag(tagName, attribs, true);
    }

    private String getFontStyle(Font font) {
        if (font.isBold() && font.isItalic()) {
            return "bold-italic";
        }
        if (font.isBold()) {
            return "bold";
        }
        if (font.isItalic()) {
            return "italic";
        }
        return "plain";
    }
}

