/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.demo;

import com.orsoncharts.data.AbstractDataset3D;
import com.orsoncharts.data.xyz.XYZDataset;
import java.util.ArrayList;
import java.util.List;

public class SampleXYZDataset
extends AbstractDataset3D
implements XYZDataset {
    private double[][] xValues;
    private double[][] yValues;
    private double[][] zValues;

    public SampleXYZDataset(int n, int n2) {
        this.xValues = new double[n][n2];
        this.yValues = new double[n][n2];
        this.zValues = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.xValues[i][j] = Math.random() * 10.0;
                this.yValues[i][j] = Math.random() * 20000.0;
                this.zValues[i][j] = Math.random() * 0.005;
            }
        }
    }

    public int getSeriesCount() {
        return this.xValues.length;
    }

    public int getItemCount(int n) {
        return this.xValues[n].length;
    }

    public double getX(int n, int n2) {
        return this.xValues[n][n2];
    }

    public double getY(int n, int n2) {
        return this.yValues[n][n2];
    }

    public double getZ(int n, int n2) {
        return this.zValues[n][n2];
    }

    public List<Comparable> getSeriesKeys() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            arrayList.add((Comparable)((Object)("S" + i)));
        }
        return arrayList;
    }

    public int getSeriesIndex(Comparable comparable) {
        return this.getSeriesKeys().indexOf(comparable);
    }
}

