/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.DemoPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYDataImageAnnotation;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.panel.CrosshairOverlay;
import org.jfree.chart.plot.Crosshair;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.GrayPaintScale;
import org.jfree.data.Range;
import org.jfree.data.general.DefaultHeatMapDataset;
import org.jfree.data.general.HeatMapDataset;
import org.jfree.data.general.HeatMapUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RefineryUtilities;

public class CrossSectionDemo1
extends ApplicationFrame {
    public CrossSectionDemo1(String string) {
        super(string);
        JPanel jPanel = CrossSectionDemo1.createDemoPanel();
        this.setContentPane(jPanel);
    }

    private static HeatMapDataset createMapDataset() {
        DefaultHeatMapDataset defaultHeatMapDataset = new DefaultHeatMapDataset(501, 501, -250.0, 250.0, -250.0, 250.0);
        for (int i = 0; i < 501; ++i) {
            for (int j = 0; j < 501; ++j) {
                defaultHeatMapDataset.setZValue(i, j, Math.sin(Math.sqrt(i * j) / 10.0));
            }
        }
        return defaultHeatMapDataset;
    }

    public static JPanel createDemoPanel() {
        return new MyDemoPanel();
    }

    public static void main(String[] stringArray) {
        CrossSectionDemo1 crossSectionDemo1 = new CrossSectionDemo1("JFreeChart: CrossSectionDemo1");
        crossSectionDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)crossSectionDemo1));
        crossSectionDemo1.setVisible(true);
    }

    static class MyDemoPanel
    extends DemoPanel
    implements ChangeListener,
    ChartChangeListener {
        private HeatMapDataset dataset;
        private JFreeChart mainChart;
        private JFreeChart subchart1;
        private JFreeChart subchart2;
        private JSlider slider1;
        private JSlider slider2;
        private Crosshair crosshair1;
        private Crosshair crosshair2;
        private Range lastXRange;
        private Range lastYRange;

        public MyDemoPanel() {
            super(new BorderLayout());
            ChartPanel chartPanel = (ChartPanel)this.createMainPanel();
            chartPanel.setPreferredSize(new Dimension(500, 270));
            CrosshairOverlay crosshairOverlay = new CrosshairOverlay();
            this.crosshair1 = new Crosshair(0.0);
            this.crosshair1.setPaint(Color.red);
            this.crosshair2 = new Crosshair(0.0);
            this.crosshair2.setPaint(Color.blue);
            crosshairOverlay.addDomainCrosshair(this.crosshair1);
            crosshairOverlay.addRangeCrosshair(this.crosshair2);
            chartPanel.addOverlay(crosshairOverlay);
            this.crosshair1.setLabelVisible(true);
            this.crosshair1.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
            this.crosshair1.setLabelBackgroundPaint(new Color(255, 255, 0, 100));
            this.crosshair2.setLabelVisible(true);
            this.crosshair2.setLabelBackgroundPaint(new Color(255, 255, 0, 100));
            this.add(chartPanel);
            JPanel jPanel = new JPanel(new BorderLayout());
            XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
            this.subchart1 = ChartFactory.createXYLineChart("Cross-section A", "Y", "Z", xYSeriesCollection, PlotOrientation.HORIZONTAL, false, false, false);
            XYPlot xYPlot = (XYPlot)this.subchart1.getPlot();
            xYPlot.getDomainAxis().setLowerMargin(0.0);
            xYPlot.getDomainAxis().setUpperMargin(0.0);
            xYPlot.setDomainAxisLocation(AxisLocation.BOTTOM_OR_RIGHT);
            ChartPanel chartPanel2 = new ChartPanel(this.subchart1);
            chartPanel2.setMinimumDrawWidth(0);
            chartPanel2.setMinimumDrawHeight(0);
            chartPanel2.setPreferredSize(new Dimension(200, 150));
            this.slider1 = new JSlider(-250, 250, 0);
            this.slider1.addChangeListener(this);
            this.slider1.setOrientation(1);
            jPanel.add(chartPanel2);
            jPanel.add((Component)this.slider1, "West");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            XYSeriesCollection xYSeriesCollection2 = new XYSeriesCollection();
            this.subchart2 = ChartFactory.createXYLineChart("Cross-section B", "X", "Z", xYSeriesCollection2, PlotOrientation.VERTICAL, false, false, false);
            XYPlot xYPlot2 = (XYPlot)this.subchart2.getPlot();
            xYPlot2.getDomainAxis().setLowerMargin(0.0);
            xYPlot2.getDomainAxis().setUpperMargin(0.0);
            xYPlot2.getRenderer().setSeriesPaint(0, Color.blue);
            ChartPanel chartPanel3 = new ChartPanel(this.subchart2);
            chartPanel3.setMinimumDrawWidth(0);
            chartPanel3.setMinimumDrawHeight(0);
            chartPanel3.setPreferredSize(new Dimension(200, 150));
            JPanel jPanel3 = new JPanel();
            jPanel3.setPreferredSize(new Dimension(200, 10));
            jPanel2.add((Component)jPanel3, "East");
            this.slider2 = new JSlider(-250, 250, 0);
            this.slider2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 200));
            this.slider2.addChangeListener(this);
            jPanel2.add(chartPanel3);
            jPanel2.add((Component)this.slider2, "North");
            this.add((Component)jPanel, "East");
            this.add((Component)jPanel2, "South");
            this.mainChart.setNotify(true);
        }

        public JPanel createMainPanel() {
            this.mainChart = this.createChart(new XYSeriesCollection());
            this.mainChart.addChangeListener(this);
            ChartPanel chartPanel = new ChartPanel(this.mainChart);
            chartPanel.setFillZoomRectangle(true);
            chartPanel.setMouseWheelEnabled(true);
            return chartPanel;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            if (changeEvent.getSource() == this.slider1) {
                this.crosshair2.setValue(this.slider1.getValue());
                int n = this.slider1.getValue() - this.slider1.getMinimum();
                XYDataset xYDataset = HeatMapUtilities.extractColumnFromHeatMapDataset(this.dataset, n, (Comparable)((Object)"Y1"));
                this.subchart2.getXYPlot().setDataset(xYDataset);
            } else if (changeEvent.getSource() == this.slider2) {
                this.crosshair1.setValue(this.slider2.getValue());
                int n = this.slider2.getValue() - this.slider2.getMinimum();
                XYDataset xYDataset = HeatMapUtilities.extractRowFromHeatMapDataset(this.dataset, n, (Comparable)((Object)"Y2"));
                this.subchart1.getXYPlot().setDataset(xYDataset);
            }
        }

        @Override
        public void chartChanged(ChartChangeEvent chartChangeEvent) {
            XYPlot xYPlot;
            XYPlot xYPlot2 = (XYPlot)this.mainChart.getPlot();
            if (!xYPlot2.getDomainAxis().getRange().equals(this.lastXRange)) {
                this.lastXRange = xYPlot2.getDomainAxis().getRange();
                xYPlot = (XYPlot)this.subchart2.getPlot();
                xYPlot.getDomainAxis().setRange(this.lastXRange);
            }
            if (!xYPlot2.getRangeAxis().getRange().equals(this.lastYRange)) {
                this.lastYRange = xYPlot2.getRangeAxis().getRange();
                xYPlot = (XYPlot)this.subchart1.getPlot();
                xYPlot.getDomainAxis().setRange(this.lastYRange);
            }
        }

        private JFreeChart createChart(XYDataset xYDataset) {
            JFreeChart jFreeChart = ChartFactory.createScatterPlot("CrossSectionDemo1", "X", "Y", xYDataset, PlotOrientation.VERTICAL, true, false, false);
            this.dataset = CrossSectionDemo1.createMapDataset();
            GrayPaintScale grayPaintScale = new GrayPaintScale(-1.0, 1.0, 128);
            BufferedImage bufferedImage = HeatMapUtilities.createHeatMapImage(this.dataset, grayPaintScale);
            XYDataImageAnnotation xYDataImageAnnotation = new XYDataImageAnnotation(bufferedImage, -250.5, -250.5, 501.0, 501.0, true);
            XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
            xYPlot.setDomainPannable(true);
            xYPlot.setRangePannable(true);
            xYPlot.getRenderer().addAnnotation(xYDataImageAnnotation, Layer.BACKGROUND);
            NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
            numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            numberAxis.setLowerMargin(0.0);
            numberAxis.setUpperMargin(0.0);
            NumberAxis numberAxis2 = (NumberAxis)xYPlot.getRangeAxis();
            numberAxis2.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            numberAxis2.setLowerMargin(0.0);
            numberAxis2.setUpperMargin(0.0);
            return jFreeChart;
        }
    }
}

