/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.text.NumberFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.AbstractCategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class ItemLabelDemo1
extends ApplicationFrame {
    public ItemLabelDemo1(String string) {
        super(string);
        JPanel jPanel = ItemLabelDemo1.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(11.0, (Comparable)((Object)"S1"), (Comparable)((Object)"C1"));
        defaultCategoryDataset.addValue(44.3, (Comparable)((Object)"S1"), (Comparable)((Object)"C2"));
        defaultCategoryDataset.addValue(93.0, (Comparable)((Object)"S1"), (Comparable)((Object)"C3"));
        defaultCategoryDataset.addValue(35.6, (Comparable)((Object)"S1"), (Comparable)((Object)"C4"));
        defaultCategoryDataset.addValue(75.1, (Comparable)((Object)"S1"), (Comparable)((Object)"C5"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart("Item Label Demo 1", "Category", "Value", categoryDataset, PlotOrientation.VERTICAL, false, true, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setRangePannable(true);
        categoryPlot.setRangeZeroBaselineVisible(true);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setUpperMargin(0.15);
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setBaseItemLabelGenerator(new LabelGenerator(50.0));
        categoryItemRenderer.setBaseItemLabelFont(new Font("Serif", 0, 20));
        categoryItemRenderer.setBaseItemLabelsVisible(true);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = ItemLabelDemo1.createChart(ItemLabelDemo1.createDataset());
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setMouseWheelEnabled(true);
        return chartPanel;
    }

    public static void main(String[] stringArray) {
        ItemLabelDemo1 itemLabelDemo1 = new ItemLabelDemo1("JFreeChart: ItemLabelDemo1.java");
        itemLabelDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)itemLabelDemo1));
        itemLabelDemo1.setVisible(true);
    }

    static class LabelGenerator
    extends AbstractCategoryItemLabelGenerator
    implements CategoryItemLabelGenerator {
        private double threshold;

        public LabelGenerator(double d) {
            super("", NumberFormat.getInstance());
            this.threshold = d;
        }

        @Override
        public String generateLabel(CategoryDataset categoryDataset, int n, int n2) {
            double d;
            String string = null;
            Number number = categoryDataset.getValue(n, n2);
            if (number != null && (d = number.doubleValue()) > this.threshold) {
                string = number.toString();
            }
            return string;
        }
    }
}

