/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class PieChartDemo7
extends ApplicationFrame {
    public PieChartDemo7(String string) {
        super(string);
        this.setContentPane(PieChartDemo7.createDemoPanel());
    }

    private static PieDataset createDataset(int n) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        for (int i = 0; i < n; ++i) {
            double d = 100.0 * Math.random();
            defaultPieDataset.setValue((Comparable)((Object)("Section " + i)), d);
        }
        return defaultPieDataset;
    }

    public static JPanel createDemoPanel() {
        PieDataset pieDataset = PieChartDemo7.createDataset(14);
        JFreeChart jFreeChart = ChartFactory.createPieChart("Pie Chart Demo 7", pieDataset, false, true, false);
        PiePlot piePlot = (PiePlot)jFreeChart.getPlot();
        piePlot.setCircular(true);
        piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator("{0} = {2}", NumberFormat.getNumberInstance(), NumberFormat.getPercentInstance()));
        piePlot.setNoDataMessage("No data available");
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        Rotator rotator = new Rotator(piePlot);
        rotator.start();
        return chartPanel;
    }

    public static void main(String[] stringArray) {
        PieChartDemo7 pieChartDemo7 = new PieChartDemo7("JFreeChart: PieChartDemo7.java");
        pieChartDemo7.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)pieChartDemo7));
        pieChartDemo7.setVisible(true);
    }

    static class Rotator
    extends Timer
    implements ActionListener {
        private PiePlot plot;
        private int angle = 270;

        Rotator(PiePlot piePlot) {
            super(50, null);
            this.plot = piePlot;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.plot.setStartAngle(this.angle);
            ++this.angle;
            if (this.angle == 360) {
                this.angle = 0;
            }
        }
    }
}

