/*
 * Decompiled with CFR 0.152.
 */
package demo;

import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.XYDataset;

public class SampleXYDataset
extends AbstractXYDataset
implements XYDataset {
    private double translate = 0.0;

    public double getTranslate() {
        return this.translate;
    }

    public void setTranslate(double d) {
        this.translate = d;
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    @Override
    public Number getX(int n, int n2) {
        return new Double(-10.0 + this.translate + (double)n2 / 10.0);
    }

    @Override
    public Number getY(int n, int n2) {
        if (n == 0) {
            return new Double(Math.cos(-10.0 + this.translate + (double)n2 / 10.0));
        }
        return new Double(2.0 * Math.sin(-10.0 + this.translate + (double)n2 / 10.0));
    }

    @Override
    public int getSeriesCount() {
        return 2;
    }

    @Override
    public Comparable getSeriesKey(int n) {
        if (n == 0) {
            return "y = cosine(x)";
        }
        if (n == 1) {
            return "y = 2*sine(x)";
        }
        return "Error";
    }

    @Override
    public int getItemCount(int n) {
        return 200;
    }
}

