/*
 * Decompiled with CFR 0.152.
 */
package demo.orsoncharts;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.ChartPanel3D;
import com.orsoncharts.axis.ValueAxis3D;
import com.orsoncharts.data.DefaultKeyedValues;
import com.orsoncharts.data.KeyedValues;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.data.category.StandardCategoryDataset3D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.graphics3d.swing.Panel3D;
import com.orsoncharts.plot.CategoryPlot3D;
import demo.orsoncharts.DemoPanel;
import demo.orsoncharts.OrsonChartsDemo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Dimension2D;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxisRangeDemo1
extends JFrame {
    public AxisRangeDemo1(String string) {
        super(string);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.getContentPane().add(AxisRangeDemo1.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        CustomDemoPanel customDemoPanel = new CustomDemoPanel(new BorderLayout());
        customDemoPanel.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        CategoryDataset3D categoryDataset3D = AxisRangeDemo1.createDataset();
        Chart3D chart3D = Chart3DFactory.createAreaChart((String)"AxisRangeDemo1", (String)"A test for rendering with a restricted value range", (CategoryDataset3D)categoryDataset3D, (String)"Row", (String)"Category", (String)"Value");
        chart3D.setChartBoxColor(new Color(255, 255, 255, 128));
        chart3D.setViewPoint(ViewPoint3D.createAboveLeftViewPoint((double)40.0));
        chart3D.getLegendBuilder().setItemFont(new Font("Dialog", 2, 12));
        CategoryPlot3D categoryPlot3D = (CategoryPlot3D)chart3D.getPlot();
        categoryPlot3D.getValueAxis().setRange(-500.0, 500.0);
        categoryPlot3D.getRowAxis().setVisible(false);
        ChartPanel3D chartPanel3D = new ChartPanel3D(chart3D);
        customDemoPanel.setChartPanel(chartPanel3D);
        customDemoPanel.add((Component)new DisplayPanel3D((Panel3D)chartPanel3D));
        chartPanel3D.zoomToFit((Dimension2D)OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        return customDemoPanel;
    }

    private static CategoryDataset3D createDataset() {
        StandardCategoryDataset3D standardCategoryDataset3D = new StandardCategoryDataset3D();
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.put((Comparable)((Object)"A"), (Object)-500);
        defaultKeyedValues.put((Comparable)((Object)"B"), (Object)-200);
        defaultKeyedValues.put((Comparable)((Object)"C"), (Object)-400);
        defaultKeyedValues.put((Comparable)((Object)"D"), (Object)-150);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"All Negative"), (KeyedValues)defaultKeyedValues);
        DefaultKeyedValues defaultKeyedValues2 = new DefaultKeyedValues();
        defaultKeyedValues2.put((Comparable)((Object)"A"), (Object)-500);
        defaultKeyedValues2.put((Comparable)((Object)"B"), (Object)500);
        defaultKeyedValues2.put((Comparable)((Object)"C"), (Object)0);
        defaultKeyedValues2.put((Comparable)((Object)"D"), (Object)-150);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"Alternating 1"), (KeyedValues)defaultKeyedValues2);
        DefaultKeyedValues defaultKeyedValues3 = new DefaultKeyedValues();
        defaultKeyedValues3.put((Comparable)((Object)"A"), (Object)500);
        defaultKeyedValues3.put((Comparable)((Object)"B"), (Object)-500);
        defaultKeyedValues3.put((Comparable)((Object)"C"), (Object)0);
        defaultKeyedValues3.put((Comparable)((Object)"D"), (Object)150);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"Alternating 2"), (KeyedValues)defaultKeyedValues3);
        DefaultKeyedValues defaultKeyedValues4 = new DefaultKeyedValues();
        defaultKeyedValues4.put((Comparable)((Object)"A"), (Object)500);
        defaultKeyedValues4.put((Comparable)((Object)"B"), (Object)200);
        defaultKeyedValues4.put((Comparable)((Object)"C"), (Object)400);
        defaultKeyedValues4.put((Comparable)((Object)"D"), (Object)150);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"All Positive"), (KeyedValues)defaultKeyedValues4);
        return standardCategoryDataset3D;
    }

    public static void main(String[] stringArray) {
        AxisRangeDemo1 axisRangeDemo1 = new AxisRangeDemo1("OrsonCharts: AreaChart3DDemo3.java");
        axisRangeDemo1.pack();
        axisRangeDemo1.setVisible(true);
    }

    static class CustomDemoPanel
    extends DemoPanel
    implements ChangeListener {
        private JSlider slider1 = new JSlider(-1000, 0);
        private JSlider slider2;

        public CustomDemoPanel(LayoutManager layoutManager) {
            super(layoutManager);
            this.slider1.setValue(-500);
            this.slider2 = new JSlider(0, 1000);
            this.slider2.setValue(500);
            this.slider1.addChangeListener(this);
            this.slider2.addChangeListener(this);
            JPanel jPanel = new JPanel(new FlowLayout());
            jPanel.add(new JLabel("Value axis lower bound: "));
            jPanel.add(this.slider1);
            jPanel.add(new JLabel("Upper bound: "));
            jPanel.add(this.slider2);
            this.add((Component)jPanel, "South");
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n;
            Chart3D chart3D = (Chart3D)this.getChartPanel().getDrawable();
            CategoryPlot3D categoryPlot3D = (CategoryPlot3D)chart3D.getPlot();
            ValueAxis3D valueAxis3D = categoryPlot3D.getValueAxis();
            int n2 = this.slider1.getValue();
            if (n2 != (n = this.slider2.getValue())) {
                valueAxis3D.setRange((double)n2, (double)n);
            }
        }
    }
}

