/*
 * Decompiled with CFR 0.152.
 */
package demo.orsoncharts;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.ChartPanel3D;
import com.orsoncharts.data.DefaultKeyedValues;
import com.orsoncharts.data.KeyedValues;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.data.category.StandardCategoryDataset3D;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.graphics3d.swing.Panel3D;
import com.orsoncharts.legend.LegendAnchor;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.renderer.category.BarRenderer3D;
import com.orsoncharts.renderer.category.CategoryColorSource;
import com.orsoncharts.renderer.category.StandardCategoryColorSource;
import demo.orsoncharts.DemoPanel;
import demo.orsoncharts.OrsonChartsDemo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Dimension2D;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class BarChart3DDemo1
extends JFrame {
    public BarChart3DDemo1(String string) {
        super(string);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.getContentPane().add(BarChart3DDemo1.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        DemoPanel demoPanel = new DemoPanel(new BorderLayout());
        demoPanel.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        CategoryDataset3D categoryDataset3D = BarChart3DDemo1.createDataset();
        Chart3D chart3D = Chart3DFactory.createBarChart((String)"Quarterly Revenues", (String)"For some large IT companies", (CategoryDataset3D)categoryDataset3D, null, (String)"Quarter", (String)"$billion Revenues");
        chart3D.setChartBoxColor(new Color(255, 255, 255, 127));
        chart3D.setLegendAnchor(LegendAnchor.BOTTOM_RIGHT);
        CategoryPlot3D categoryPlot3D = (CategoryPlot3D)chart3D.getPlot();
        categoryPlot3D.setGridlinePaintForValues((Paint)Color.BLACK);
        BarRenderer3D barRenderer3D = (BarRenderer3D)categoryPlot3D.getRenderer();
        barRenderer3D.setColorSource((CategoryColorSource)new StandardCategoryColorSource(new Color[]{new Color(1742401), new Color(10934634), new Color(16625249), new Color(0xFFFFBF)}));
        ChartPanel3D chartPanel3D = new ChartPanel3D(chart3D);
        demoPanel.setChartPanel(chartPanel3D);
        chartPanel3D.zoomToFit((Dimension2D)OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        demoPanel.add((Component)new DisplayPanel3D((Panel3D)chartPanel3D));
        return demoPanel;
    }

    private static CategoryDataset3D createDataset() {
        StandardCategoryDataset3D standardCategoryDataset3D = new StandardCategoryDataset3D();
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        defaultKeyedValues.put((Comparable)((Object)"Q1/11"), (Object)8.58);
        defaultKeyedValues.put((Comparable)((Object)"Q2/11"), (Object)9.03);
        defaultKeyedValues.put((Comparable)((Object)"Q3/11"), (Object)9.72);
        defaultKeyedValues.put((Comparable)((Object)"Q4/11"), (Object)10.58);
        defaultKeyedValues.put((Comparable)((Object)"Q1/12"), (Object)10.65);
        defaultKeyedValues.put((Comparable)((Object)"Q2/12"), (Object)12.214);
        defaultKeyedValues.put((Comparable)((Object)"Q3/12"), (Object)14.101);
        defaultKeyedValues.put((Comparable)((Object)"Q4/12"), (Object)14.419);
        defaultKeyedValues.put((Comparable)((Object)"Q1/13"), (Object)13.969);
        defaultKeyedValues.put((Comparable)((Object)"Q2/13"), (Object)14.105);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"Google"), (KeyedValues)defaultKeyedValues);
        DefaultKeyedValues defaultKeyedValues2 = new DefaultKeyedValues();
        defaultKeyedValues2.put((Comparable)((Object)"Q1/11"), (Object)16.43);
        defaultKeyedValues2.put((Comparable)((Object)"Q2/11"), (Object)17.37);
        defaultKeyedValues2.put((Comparable)((Object)"Q3/11"), (Object)17.37);
        defaultKeyedValues2.put((Comparable)((Object)"Q4/11"), (Object)20.89);
        defaultKeyedValues2.put((Comparable)((Object)"Q1/12"), (Object)17.41);
        defaultKeyedValues2.put((Comparable)((Object)"Q2/12"), (Object)18.06);
        defaultKeyedValues2.put((Comparable)((Object)"Q3/12"), (Object)16.008);
        defaultKeyedValues2.put((Comparable)((Object)"Q4/12"), (Object)21.456);
        defaultKeyedValues2.put((Comparable)((Object)"Q1/13"), (Object)20.489);
        defaultKeyedValues2.put((Comparable)((Object)"Q2/13"), (Object)19.896);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"Microsoft"), (KeyedValues)defaultKeyedValues2);
        DefaultKeyedValues defaultKeyedValues3 = new DefaultKeyedValues();
        defaultKeyedValues3.put((Comparable)((Object)"Q1/11"), (Object)24.67);
        defaultKeyedValues3.put((Comparable)((Object)"Q2/11"), (Object)28.57);
        defaultKeyedValues3.put((Comparable)((Object)"Q3/11"), (Object)28.27);
        defaultKeyedValues3.put((Comparable)((Object)"Q4/11"), (Object)46.33);
        defaultKeyedValues3.put((Comparable)((Object)"Q1/12"), (Object)39.2);
        defaultKeyedValues3.put((Comparable)((Object)"Q2/12"), (Object)35.0);
        defaultKeyedValues3.put((Comparable)((Object)"Q3/12"), (Object)36.0);
        defaultKeyedValues3.put((Comparable)((Object)"Q4/12"), (Object)54.5);
        defaultKeyedValues3.put((Comparable)((Object)"Q1/13"), (Object)43.6);
        defaultKeyedValues3.put((Comparable)((Object)"Q2/13"), (Object)35.323);
        standardCategoryDataset3D.addSeriesAsRow((Comparable)((Object)"Apple"), (KeyedValues)defaultKeyedValues3);
        return standardCategoryDataset3D;
    }

    public static void main(String[] stringArray) {
        BarChart3DDemo1 barChart3DDemo1 = new BarChart3DDemo1("OrsonCharts: BarChart3DDemo1.java");
        barChart3DDemo1.pack();
        barChart3DDemo1.setVisible(true);
    }
}

