/*
 * Decompiled with CFR 0.152.
 */
package demo.orsoncharts;

import demo.orsoncharts.AreaChart3DDemo1;
import demo.orsoncharts.DemoDescription;
import demo.orsoncharts.DemoPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class OrsonChartsDemo
extends JFrame
implements ActionListener,
TreeSelectionListener {
    public static final Dimension DEFAULT_CONTENT_SIZE = new Dimension(760, 480);
    public JPanel chartContainer = new JPanel(new BorderLayout());
    private JTextPane chartDescriptionPane;
    private TreePath defaultChartPath;

    public OrsonChartsDemo(String string) {
        super(string);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setJMenuBar(this.createMenuBar());
        this.add(this.createContent());
    }

    private JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.createFileMenu("File"));
        return jMenuBar;
    }

    private JMenu createFileMenu(String string) {
        JMenu jMenu = new JMenu(string);
        JMenuItem jMenuItem = new JMenuItem("Exit");
        jMenuItem.setActionCommand("EXIT");
        jMenuItem.addActionListener(this);
        jMenu.add(jMenuItem);
        return jMenu;
    }

    public JComponent createContent() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JTree jTree = new JTree(this.createTreeModel());
        jTree.addTreeSelectionListener(this);
        jTree.setSelectionPath(this.defaultChartPath);
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jScrollPane.setPreferredSize(new Dimension(300, 580));
        jSplitPane.add(jScrollPane);
        jSplitPane.add(this.createChartComponent());
        jTabbedPane.add("Demos", jSplitPane);
        jTabbedPane.add("About", this.createAboutPanel());
        return jTabbedPane;
    }

    private JPanel createAboutPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        URL uRL = OrsonChartsDemo.class.getResource("about.html");
        try {
            jTextPane.setPage(uRL);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        JScrollPane jScrollPane = new JScrollPane(jTextPane);
        jPanel.add(jScrollPane);
        return jPanel;
    }

    private JComponent createChartComponent() {
        JSplitPane jSplitPane = new JSplitPane(0);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(Color.DARK_GRAY));
        DemoPanel demoPanel = AreaChart3DDemo1.createDemoPanel();
        demoPanel.setBorder(compoundBorder);
        this.chartContainer.add(demoPanel);
        jSplitPane.add(this.chartContainer);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(Color.BLACK)));
        this.chartDescriptionPane = new JTextPane();
        this.chartDescriptionPane.setPreferredSize(new Dimension(400, 200));
        this.chartDescriptionPane.setEditable(false);
        this.chartDescriptionPane.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.chartDescriptionPane.setText("No chart description available.");
        jPanel.add(this.chartDescriptionPane);
        jSplitPane.add(jPanel);
        return jSplitPane;
    }

    private TreeModel createTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Orson Charts");
        defaultMutableTreeNode.add(this.createCategoryChartsNode(defaultMutableTreeNode));
        defaultMutableTreeNode.add(this.createPieChartsNode());
        defaultMutableTreeNode.add(this.createXYZChartsNode());
        defaultMutableTreeNode.add(this.createAxisRangeTestNode());
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    private MutableTreeNode createNode(String string, String string2) {
        return new DefaultMutableTreeNode(new DemoDescription(string, string2));
    }

    private MutableTreeNode createCategoryChartsNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Category Charts");
        MutableTreeNode mutableTreeNode = this.createNode("demo.orsoncharts.AreaChart3DDemo1", "AreaChart3DDemo1.java");
        this.defaultChartPath = new TreePath(new Object[]{defaultMutableTreeNode, defaultMutableTreeNode2, mutableTreeNode});
        defaultMutableTreeNode2.add(mutableTreeNode);
        defaultMutableTreeNode2.add(this.createNode("demo.orsoncharts.AreaChart3DDemo2", "AreaChart3DDemo2.java"));
        defaultMutableTreeNode2.add(this.createNode("demo.orsoncharts.BarChart3DDemo1", "BarChart3DDemo1.java"));
        defaultMutableTreeNode2.add(this.createNode("demo.orsoncharts.BarChart3DDemo2", "BarChart3DDemo2.java"));
        defaultMutableTreeNode2.add(this.createNode("demo.orsoncharts.LineChart3DDemo1", "LineChart3DDemo1.java"));
        defaultMutableTreeNode2.add(this.createNode("demo.orsoncharts.LineChart3DDemo2", "LineChart3DDemo2.java"));
        defaultMutableTreeNode2.add(this.createNode("demo.orsoncharts.StackedBarChart3DDemo1", "StackedBarChart3DDemo1.java"));
        defaultMutableTreeNode2.add(this.createNode("demo.orsoncharts.StackedBarChart3DDemo2", "StackedBarChart3DDemo2.java"));
        return defaultMutableTreeNode2;
    }

    private MutableTreeNode createPieChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Pie Charts");
        defaultMutableTreeNode.add(this.createNode("demo.orsoncharts.PieChart3DDemo1", "PieChart3DDemo1.java"));
        defaultMutableTreeNode.add(this.createNode("demo.orsoncharts.PieChart3DDemo2", "PieChart3DDemo2.java"));
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createXYZChartsNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("XYZ Charts");
        defaultMutableTreeNode.add(this.createNode("demo.orsoncharts.ScatterPlot3DDemo1", "ScatterPlot3DDemo1.java"));
        defaultMutableTreeNode.add(this.createNode("demo.orsoncharts.ScatterPlot3DDemo2", "ScatterPlot3DDemo2.java"));
        defaultMutableTreeNode.add(this.createNode("demo.orsoncharts.XYZBarChart3DDemo1", "XYZBarChart3DDemo1.java"));
        return defaultMutableTreeNode;
    }

    private MutableTreeNode createAxisRangeTestNode() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Axis Range Tests");
        defaultMutableTreeNode.add(this.createNode("demo.orsoncharts.AxisRangeDemo1", "AxisRangeDemo1.java"));
        defaultMutableTreeNode.add(this.createNode("demo.orsoncharts.AxisRangeDemo2", "AxisRangeDemo2.java"));
        defaultMutableTreeNode.add(this.createNode("demo.orsoncharts.AxisRangeDemo3", "AxisRangeDemo3.java"));
        defaultMutableTreeNode.add(this.createNode("demo.orsoncharts.AxisRangeDemo4", "AxisRangeDemo4.java"));
        defaultMutableTreeNode.add(this.createNode("demo.orsoncharts.AxisRangeDemo5", "AxisRangeDemo5.java"));
        return defaultMutableTreeNode;
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getPath();
        Object object = treePath.getLastPathComponent();
        if (object != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            Object object2 = defaultMutableTreeNode.getUserObject();
            if (object2 instanceof DemoDescription) {
                DemoDescription demoDescription = (DemoDescription)object2;
                SwingUtilities.invokeLater(new DisplayDemo(this, demoDescription));
            } else {
                this.chartContainer.removeAll();
                this.chartContainer.add(this.createNoDemoSelectedPanel());
                this.chartContainer.validate();
                URL uRL = OrsonChartsDemo.class.getResource("select.html");
                if (uRL != null) {
                    try {
                        this.chartDescriptionPane.setPage(uRL);
                    }
                    catch (IOException iOException) {
                        System.err.println("Attempted to read a bad URL: " + uRL);
                    }
                }
            }
        }
    }

    private JComponent createNoDemoSelectedPanel() {
        return new JButton("No demo selected.");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("EXIT".equals(actionEvent.getActionCommand())) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                    if (!"Nimbus".equals(lookAndFeelInfo.getName())) continue;
                    try {
                        UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                    }
                    catch (Exception exception) {
                        try {
                            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                }
                OrsonChartsDemo orsonChartsDemo = new OrsonChartsDemo("Orson Charts Demo 1.0");
                orsonChartsDemo.pack();
                orsonChartsDemo.setVisible(true);
            }
        });
    }

    static class DisplayDemo
    implements Runnable {
        private OrsonChartsDemo app;
        private DemoDescription demoDescription;

        public DisplayDemo(OrsonChartsDemo orsonChartsDemo, DemoDescription demoDescription) {
            this.app = orsonChartsDemo;
            this.demoDescription = demoDescription;
        }

        @Override
        public void run() {
            try {
                String string;
                URL uRL;
                Object object;
                Class<?> clazz = Class.forName(this.demoDescription.getClassName());
                Method method = clazz.getDeclaredMethod("createDemoPanel", null);
                JPanel jPanel = (JPanel)method.invoke(null, (Object[])null);
                jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createLineBorder(Color.BLACK)));
                this.app.chartContainer.removeAll();
                this.app.chartContainer.add(jPanel);
                this.app.chartContainer.validate();
                if (jPanel instanceof DemoPanel) {
                    object = (DemoPanel)jPanel;
                    ((DemoPanel)object).getChartPanel().zoomToFit();
                }
                if ((uRL = OrsonChartsDemo.class.getResource(string = ((String)(object = this.demoDescription.getFileName())).substring(0, ((String)object).indexOf(46)) + ".html")) != null) {
                    try {
                        this.app.chartDescriptionPane.setPage(uRL);
                    }
                    catch (IOException iOException) {
                        System.err.println("Attempted to read a bad URL: " + uRL);
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
    }
}

