/*
 * Decompiled with CFR 0.152.
 */
package demo.orsoncharts;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.ChartPanel3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZSeries;
import com.orsoncharts.data.xyz.XYZSeriesCollection;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.graphics3d.swing.Panel3D;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.xyz.ScatterXYZRenderer;
import demo.orsoncharts.DemoPanel;
import demo.orsoncharts.OrsonChartsDemo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Dimension2D;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ScatterPlot3DDemo1
extends JFrame {
    public ScatterPlot3DDemo1(String string) {
        super(string);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.getContentPane().add(ScatterPlot3DDemo1.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        DemoPanel demoPanel = new DemoPanel(new BorderLayout());
        demoPanel.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        XYZDataset xYZDataset = ScatterPlot3DDemo1.createDataset();
        Chart3D chart3D = Chart3DFactory.createScatterChart((String)"ScatterPlot3DDemo1", (String)"Chart created with Orson Charts", (XYZDataset)xYZDataset, (String)"X", (String)"Y", (String)"Z");
        XYZPlot xYZPlot = (XYZPlot)chart3D.getPlot();
        xYZPlot.setDimensions(new Dimension3D(10.0, 4.0, 4.0));
        ScatterXYZRenderer scatterXYZRenderer = (ScatterXYZRenderer)xYZPlot.getRenderer();
        scatterXYZRenderer.setSize(0.15);
        chart3D.setViewPoint(ViewPoint3D.createAboveLeftViewPoint((double)40.0));
        ChartPanel3D chartPanel3D = new ChartPanel3D(chart3D);
        demoPanel.setChartPanel(chartPanel3D);
        chartPanel3D.zoomToFit((Dimension2D)OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        demoPanel.add((Component)new DisplayPanel3D((Panel3D)chartPanel3D));
        return demoPanel;
    }

    private static XYZDataset createDataset() {
        XYZSeries xYZSeries = ScatterPlot3DDemo1.createRandomSeries("S1", 10);
        XYZSeries xYZSeries2 = ScatterPlot3DDemo1.createRandomSeries("S2", 50);
        XYZSeries xYZSeries3 = ScatterPlot3DDemo1.createRandomSeries("S3", 150);
        XYZSeriesCollection xYZSeriesCollection = new XYZSeriesCollection();
        xYZSeriesCollection.add(xYZSeries);
        xYZSeriesCollection.add(xYZSeries2);
        xYZSeriesCollection.add(xYZSeries3);
        return xYZSeriesCollection;
    }

    private static XYZSeries createRandomSeries(String string, int n) {
        XYZSeries xYZSeries = new XYZSeries((Comparable)((Object)string));
        for (int i = 0; i < n; ++i) {
            xYZSeries.add(Math.random() * 100.0, Math.random() / 100.0, Math.random() * 100.0);
        }
        return xYZSeries;
    }

    public static void main(String[] stringArray) {
        ScatterPlot3DDemo1 scatterPlot3DDemo1 = new ScatterPlot3DDemo1("OrsonCharts : ScatterPlot3DDemo1.java");
        scatterPlot3DDemo1.pack();
        scatterPlot3DDemo1.setVisible(true);
    }
}

