/*
 * Decompiled with CFR 0.152.
 */
package demo.orsoncharts;

import com.orsoncharts.Chart3D;
import com.orsoncharts.Chart3DFactory;
import com.orsoncharts.ChartPanel3D;
import com.orsoncharts.data.function.Function3D;
import com.orsoncharts.data.xyz.XYZDataset;
import com.orsoncharts.data.xyz.XYZDatasetUtils;
import com.orsoncharts.graphics3d.Dimension3D;
import com.orsoncharts.graphics3d.ViewPoint3D;
import com.orsoncharts.graphics3d.swing.DisplayPanel3D;
import com.orsoncharts.graphics3d.swing.Panel3D;
import com.orsoncharts.plot.XYZPlot;
import com.orsoncharts.renderer.xyz.ScatterXYZRenderer;
import demo.orsoncharts.DemoPanel;
import demo.orsoncharts.OrsonChartsDemo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Dimension2D;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ScatterPlot3DDemo2
extends JFrame {
    public ScatterPlot3DDemo2(String string) {
        super(string);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.getContentPane().add(ScatterPlot3DDemo2.createDemoPanel());
    }

    public static JPanel createDemoPanel() {
        DemoPanel demoPanel = new DemoPanel(new BorderLayout());
        demoPanel.setPreferredSize(OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        XYZDataset xYZDataset = ScatterPlot3DDemo2.createDataset();
        Chart3D chart3D = Chart3DFactory.createScatterChart((String)"ScatterPlot3DDemo2", (String)"Chart created with Orson Charts", (XYZDataset)xYZDataset, (String)"X", (String)"Y", (String)"Z");
        XYZPlot xYZPlot = (XYZPlot)chart3D.getPlot();
        xYZPlot.setDimensions(new Dimension3D(10.0, 4.0, 10.0));
        ScatterXYZRenderer scatterXYZRenderer = (ScatterXYZRenderer)xYZPlot.getRenderer();
        scatterXYZRenderer.setSize(0.05);
        chart3D.setViewPoint(ViewPoint3D.createAboveLeftViewPoint((double)40.0));
        ChartPanel3D chartPanel3D = new ChartPanel3D(chart3D);
        demoPanel.setChartPanel(chartPanel3D);
        chartPanel3D.zoomToFit((Dimension2D)OrsonChartsDemo.DEFAULT_CONTENT_SIZE);
        demoPanel.add((Component)new DisplayPanel3D((Panel3D)chartPanel3D));
        return demoPanel;
    }

    private static XYZDataset createDataset() {
        Function3D function3D = new Function3D(){

            public double getValue(double d, double d2) {
                return Math.cos(d) * Math.sin(d2);
            }
        };
        XYZDataset xYZDataset = XYZDatasetUtils.sampleFunction((Function3D)function3D, (String)"y = cos(x) * sin(z)", (double)0.0, (double)(Math.PI * 2), (double)50.0, (double)0.0, (double)(Math.PI * 2), (double)50.0);
        return xYZDataset;
    }

    public static void main(String[] stringArray) {
        ScatterPlot3DDemo2 scatterPlot3DDemo2 = new ScatterPlot3DDemo2("OrsonCharts : ScatterPlot3DDemo2.java");
        scatterPlot3DDemo2.pack();
        scatterPlot3DDemo2.setVisible(true);
    }
}

