/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.axis;

import com.orsoncharts.Range;
import com.orsoncharts.axis.AbstractAxis3D;
import com.orsoncharts.axis.CategoryAxis3D;
import com.orsoncharts.axis.TickData;
import com.orsoncharts.graphics3d.Utils2D;
import com.orsoncharts.plot.CategoryPlot3D;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import com.orsoncharts.util.SerialUtils;
import com.orsoncharts.util.TextAnchor;
import com.orsoncharts.util.TextUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class StandardCategoryAxis3D
extends AbstractAxis3D
implements CategoryAxis3D,
Serializable {
    private boolean visible = true;
    private List<Comparable> categories = new ArrayList<Comparable>();
    private Range range = new Range(0.0, 1.0);
    private double lowerMargin = 0.05;
    private double upperMargin = 0.05;
    private boolean firstCategoryHalfWidth = false;
    private boolean lastCategoryHalfWidth = false;
    private double tickMarkLength = 3.0;
    private transient Stroke tickMarkStroke;
    private transient Paint tickMarkPaint = Color.GRAY;
    private double tickLabelOffset = 5.0;

    public StandardCategoryAxis3D() {
        this(null);
    }

    public StandardCategoryAxis3D(String label) {
        super(label);
        this.tickMarkStroke = new BasicStroke(0.5f);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.fireChangeEvent();
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public void setRange(double lowerBound, double upperBound) {
        this.setRange(new Range(lowerBound, upperBound));
    }

    @Override
    public void setRange(Range range) {
        ArgChecks.nullNotPermitted(range, "range");
        this.range = range;
        this.fireChangeEvent();
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double margin) {
        this.lowerMargin = margin;
        this.fireChangeEvent();
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double margin) {
        this.upperMargin = margin;
        this.fireChangeEvent();
    }

    public boolean isFirstCategoryHalfWidth() {
        return this.firstCategoryHalfWidth;
    }

    public void setFirstCategoryHalfWidth(boolean half) {
        this.firstCategoryHalfWidth = half;
        this.fireChangeEvent();
    }

    public boolean isLastCategoryHalfWidth() {
        return this.lastCategoryHalfWidth;
    }

    public void setLastCategoryHalfWidth(boolean half) {
        this.lastCategoryHalfWidth = half;
        this.fireChangeEvent();
    }

    public double getTickMarkLength() {
        return this.tickMarkLength;
    }

    public void setTickMarkLength(double length) {
        this.tickMarkLength = length;
        this.fireChangeEvent();
    }

    public Paint getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    public void setTickMarkPaint(Paint paint) {
        ArgChecks.nullNotPermitted(paint, "paint");
        this.tickMarkPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getTickMarkStroke() {
        return this.tickMarkStroke;
    }

    public void setTickMarkStroke(Stroke stroke) {
        ArgChecks.nullNotPermitted(stroke, "stroke");
        this.tickMarkStroke = stroke;
        this.fireChangeEvent();
    }

    public double getTickLabelOffset() {
        return this.tickLabelOffset;
    }

    public void setTickLabelOffset(double offset) {
        this.tickLabelOffset = offset;
        this.fireChangeEvent();
    }

    @Override
    public double getCategoryWidth() {
        double length = this.range.getLength();
        double start = this.range.getMin() + this.lowerMargin * length;
        double end = this.range.getMax() - this.upperMargin * length;
        double available = end - start;
        return available / (double)this.categories.size();
    }

    @Override
    public void configureAsRowAxis(CategoryPlot3D plot) {
        ArgChecks.nullNotPermitted(plot, "plot");
        this.categories = plot.getDataset().getRowKeys();
    }

    @Override
    public void configureAsColumnAxis(CategoryPlot3D plot) {
        ArgChecks.nullNotPermitted(plot, "plot");
        this.categories = plot.getDataset().getColumnKeys();
    }

    @Override
    public double getCategoryValue(Comparable category) {
        int index = this.categories.indexOf(category);
        if (index < 0) {
            return Double.NaN;
        }
        double length = this.range.getLength();
        double start = this.range.getMin() + this.lowerMargin * length;
        double end = this.range.getMax() - this.upperMargin * length;
        double available = end - start;
        double categoryCount = this.categories.size();
        if (this.firstCategoryHalfWidth) {
            categoryCount -= 0.5;
        }
        if (this.lastCategoryHalfWidth) {
            categoryCount -= 0.5;
        }
        double categoryWidth = 0.0;
        if (categoryCount > 0.0) {
            categoryWidth = available / categoryCount;
        }
        double adj = this.firstCategoryHalfWidth ? 0.0 : 0.5;
        return start + (adj + (double)index) * categoryWidth;
    }

    @Override
    public double translateToWorld(double value, double length) {
        return length * (value - this.range.getMin()) / this.range.getLength();
    }

    @Override
    public void draw(Graphics2D g2, Point2D pt0, Point2D pt1, Point2D opposingPt, boolean labels, List<TickData> tickData) {
        if (!this.isVisible()) {
            return;
        }
        g2.setStroke(this.getLineStroke());
        g2.setPaint(this.getLineColor());
        Line2D.Float axisLine = new Line2D.Float(pt0, pt1);
        g2.draw(axisLine);
        double maxTickLabelWidth = 0.0;
        for (TickData t : tickData) {
            Line2D perpLine = Utils2D.createPerpendicularLine((Line2D)axisLine, t.getAnchorPt(), this.tickMarkLength + this.tickLabelOffset, opposingPt);
            if (this.tickMarkLength > 0.0) {
                Line2D tickLine = Utils2D.createPerpendicularLine((Line2D)axisLine, t.getAnchorPt(), this.tickMarkLength, opposingPt);
                g2.setPaint(this.tickMarkPaint);
                g2.setStroke(this.tickMarkStroke);
                g2.draw(tickLine);
            }
            if (!this.getTickLabelsVisible()) continue;
            double perpTheta = Utils2D.calculateTheta(perpLine);
            TextAnchor textAnchor = TextAnchor.CENTER_LEFT;
            if (perpTheta >= 1.5707963267948966) {
                perpTheta -= Math.PI;
                textAnchor = TextAnchor.CENTER_RIGHT;
            } else if (perpTheta <= -1.5707963267948966) {
                perpTheta += Math.PI;
                textAnchor = TextAnchor.CENTER_RIGHT;
            }
            g2.setFont(this.getTickLabelFont());
            g2.setPaint(this.getTickLabelPaint());
            String tickLabel = t.getKey().toString();
            maxTickLabelWidth = Math.max(maxTickLabelWidth, (double)g2.getFontMetrics().stringWidth(tickLabel));
            TextUtils.drawRotatedString(tickLabel, g2, (float)perpLine.getX2(), (float)perpLine.getY2(), textAnchor, perpTheta, textAnchor);
        }
        if (this.getLabel() != null) {
            g2.setFont(this.getLabelFont());
            g2.setPaint(this.getLabelPaint());
            Line2D labelPosLine = Utils2D.createPerpendicularLine((Line2D)axisLine, 0.5, this.tickMarkLength + this.tickLabelOffset + maxTickLabelWidth + 10.0, opposingPt);
            double theta = Utils2D.calculateTheta(axisLine);
            if (theta < -1.5707963267948966) {
                theta += Math.PI;
            }
            if (theta > 1.5707963267948966) {
                theta -= Math.PI;
            }
            TextUtils.drawRotatedString(this.getLabel(), g2, (float)labelPosLine.getX2(), (float)labelPosLine.getY2(), TextAnchor.CENTER, theta, TextAnchor.CENTER);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardCategoryAxis3D)) {
            return false;
        }
        StandardCategoryAxis3D that = (StandardCategoryAxis3D)obj;
        if (this.visible != that.visible) {
            return false;
        }
        if (this.lowerMargin != that.lowerMargin) {
            return false;
        }
        if (this.upperMargin != that.upperMargin) {
            return false;
        }
        if (this.firstCategoryHalfWidth != that.firstCategoryHalfWidth) {
            return false;
        }
        if (this.lastCategoryHalfWidth != that.lastCategoryHalfWidth) {
            return false;
        }
        if (this.tickMarkLength != that.tickMarkLength) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.tickMarkPaint, that.tickMarkPaint)) {
            return false;
        }
        if (!this.tickMarkStroke.equals(that.tickMarkStroke)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public List<TickData> generateTickData() {
        ArrayList<TickData> result = new ArrayList<TickData>(this.categories.size());
        for (Comparable key : this.categories) {
            double pos = this.range.percent(this.getCategoryValue(key));
            result.add(new TickData(pos, key));
        }
        return result;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writePaint(this.tickMarkPaint, stream);
        SerialUtils.writeStroke(this.tickMarkStroke, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.tickMarkPaint = SerialUtils.readPaint(stream);
        this.tickMarkStroke = SerialUtils.readStroke(stream);
    }
}

