/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data;

import com.orsoncharts.data.KeyedValue;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import java.io.Serializable;

public final class DefaultKeyedValue<T>
implements KeyedValue,
Serializable {
    private Comparable key;
    private T value;

    public DefaultKeyedValue(Comparable key, T value) {
        ArgChecks.nullNotPermitted(key, "key");
        this.key = key;
        this.value = value;
    }

    @Override
    public Comparable getKey() {
        return this.key;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DefaultKeyedValue)) {
            return false;
        }
        DefaultKeyedValue that = (DefaultKeyedValue)obj;
        if (!this.key.equals(that.key)) {
            return false;
        }
        return ObjectUtils.equals(this.value, that.value);
    }

    public String toString() {
        return "(" + this.key.toString() + ", " + this.value + ")";
    }
}

