/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.legend;

import com.orsoncharts.legend.LegendBuilder;
import com.orsoncharts.legend.LegendItemInfo;
import com.orsoncharts.plot.Plot3D;
import com.orsoncharts.table.FlowElement;
import com.orsoncharts.table.GridElement;
import com.orsoncharts.table.HAlign;
import com.orsoncharts.table.ShapeElement;
import com.orsoncharts.table.TableElement;
import com.orsoncharts.table.TextElement;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;

public final class StandardLegendBuilder
implements LegendBuilder,
Serializable {
    public static final Font DEFAULT_HEADER_FONT = new Font("Dialog", 1, 14);
    public static final Font DEFAULT_FOOTER_FONT = new Font("Dialog", 0, 10);
    public static final Font DEFAULT_ITEM_FONT = new Font("Dialog", 0, 12);
    private static final Shape DEFAULT_LEGEND_SHAPE = new Rectangle2D.Double(-6.0, -4.0, 12.0, 8.0);
    private String header = null;
    private Font headerFont = DEFAULT_HEADER_FONT;
    private HAlign headerAlignment = HAlign.LEFT;
    private String footer = null;
    private Font footerFont = DEFAULT_FOOTER_FONT;
    private HAlign footerAlignment = HAlign.RIGHT;
    private Font itemFont = DEFAULT_ITEM_FONT;

    public StandardLegendBuilder() {
        this(null, null);
    }

    public StandardLegendBuilder(String header, String footer) {
    }

    public String getHeader() {
        return this.header;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public Font getHeaderFont() {
        return this.headerFont;
    }

    public void setHeaderFont(Font font) {
        ArgChecks.nullNotPermitted(font, "font");
        this.headerFont = font;
    }

    public HAlign getHeaderAlignment() {
        return this.headerAlignment;
    }

    public void setHeaderAlignment(HAlign align) {
        ArgChecks.nullNotPermitted((Object)align, "align");
        this.headerAlignment = align;
    }

    public String getFooter() {
        return this.footer;
    }

    public void setFooter(String footer) {
        this.footer = footer;
    }

    public Font getFooterFont() {
        return this.footerFont;
    }

    public void setFooterFont(Font font) {
        ArgChecks.nullNotPermitted(font, "font");
        this.footerFont = font;
    }

    public HAlign getFooterAlignment() {
        return this.footerAlignment;
    }

    public void setFooterAlignment(HAlign align) {
        ArgChecks.nullNotPermitted((Object)align, "align");
        this.footerAlignment = align;
    }

    @Override
    public Font getItemFont() {
        return this.itemFont;
    }

    @Override
    public void setItemFont(Font font) {
        ArgChecks.nullNotPermitted(font, "font");
        this.itemFont = font;
    }

    @Override
    public TableElement createLegend(Plot3D plot) {
        TableElement legend = this.createSimpleLegend(plot.getLegendInfo());
        if (this.header != null || this.footer != null) {
            GridElement compositeLegend = new GridElement();
            if (this.header != null) {
                TextElement he = new TextElement(this.header, this.headerFont);
                he.setHorizontalAligment(this.headerAlignment);
                compositeLegend.setElement(he, (Comparable)((Object)"R0"), (Comparable)((Object)"C1"));
            }
            compositeLegend.setElement(legend, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
            if (this.footer != null) {
                TextElement fe = new TextElement(this.footer, this.footerFont);
                fe.setHorizontalAligment(this.footerAlignment);
                compositeLegend.setElement(fe, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
            }
            return compositeLegend;
        }
        return legend;
    }

    private TableElement createSimpleLegend(List<LegendItemInfo> items) {
        ArgChecks.nullNotPermitted(items, "items");
        FlowElement legend = new FlowElement();
        for (LegendItemInfo item : items) {
            Shape shape = item.getShape();
            if (shape == null) {
                shape = DEFAULT_LEGEND_SHAPE;
            }
            legend.addElement(this.createLegendItem(item.getLabel(), this.itemFont, shape, item.getPaint()));
        }
        return legend;
    }

    private TableElement createLegendItem(String text, Font font, Shape shape, Paint color) {
        ShapeElement se = new ShapeElement(shape, color);
        TextElement te = new TextElement(text, font);
        GridElement ge = new GridElement();
        ge.setElement(se, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        ge.setElement(te, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        return ge;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardLegendBuilder)) {
            return false;
        }
        StandardLegendBuilder that = (StandardLegendBuilder)obj;
        if (!ObjectUtils.equals(this.header, that.header)) {
            return false;
        }
        if (this.headerAlignment != that.headerAlignment) {
            return false;
        }
        if (!this.headerFont.equals(that.headerFont)) {
            return false;
        }
        if (!ObjectUtils.equals(this.footer, that.footer)) {
            return false;
        }
        if (this.footerAlignment != that.footerAlignment) {
            return false;
        }
        if (!this.footerFont.equals(that.footerFont)) {
            return false;
        }
        return this.itemFont.equals(that.itemFont);
    }
}

