/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.renderer;

import com.orsoncharts.plot.Plot3DChangeListener;
import com.orsoncharts.renderer.Renderer3D;
import com.orsoncharts.renderer.Renderer3DChangeEvent;
import com.orsoncharts.renderer.Renderer3DChangeListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractRenderer3D
implements Renderer3D {
    private transient EventListenerList listenerList = new EventListenerList();
    private boolean notify = true;

    protected AbstractRenderer3D() {
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
        if (notify) {
            this.fireChangeEvent();
        }
    }

    @Override
    public void addChangeListener(Renderer3DChangeListener listener) {
        this.listenerList.add(Renderer3DChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(Renderer3DChangeListener listener) {
        this.listenerList.remove(Renderer3DChangeListener.class, listener);
    }

    public void notifyListeners(Renderer3DChangeEvent event) {
        if (!this.notify) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Plot3DChangeListener.class) continue;
            ((Renderer3DChangeListener)listeners[i + 1]).rendererChanged(event);
        }
    }

    protected void fireChangeEvent() {
        this.notifyListeners(new Renderer3DChangeEvent(this));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractRenderer3D)) {
            return false;
        }
        AbstractRenderer3D that = (AbstractRenderer3D)obj;
        return this.notify == that.notify;
    }
}

