/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.table;

import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;

public abstract class AbstractTableElement {
    private Insets insets = new Insets(2, 2, 2, 2);
    private Paint foregroundPaint = Color.BLACK;
    private Paint backgroundPaint = new Color(255, 255, 255, 127);

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        ArgChecks.nullNotPermitted(insets, "insets");
        this.insets = insets;
    }

    public Paint getForegroundPaint() {
        return this.foregroundPaint;
    }

    public void setForegroundPaint(Paint paint) {
        ArgChecks.nullNotPermitted(paint, "paint");
        this.foregroundPaint = paint;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        ArgChecks.nullNotPermitted(paint, "paint");
        this.backgroundPaint = paint;
    }

    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds) {
        return this.preferredSize(g2, bounds, null);
    }

    public abstract Dimension2D preferredSize(Graphics2D var1, Rectangle2D var2, Map<String, Object> var3);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractTableElement)) {
            return false;
        }
        AbstractTableElement that = (AbstractTableElement)obj;
        if (!this.insets.equals(that.insets)) {
            return false;
        }
        if (!ObjectUtils.equalsPaint(this.backgroundPaint, that.backgroundPaint)) {
            return false;
        }
        return ObjectUtils.equalsPaint(this.foregroundPaint, that.foregroundPaint);
    }
}

