/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.util;

import com.orsoncharts.graphics3d.Offset2D;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.RefPt2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public final class Anchor2D
implements Serializable {
    private RefPt2D refPt;
    private Offset2D offset;

    public Anchor2D() {
        this(RefPt2D.TOP_LEFT);
    }

    public Anchor2D(RefPt2D refPt) {
        this(refPt, new Offset2D(4.0, 4.0));
    }

    public Anchor2D(RefPt2D refPt, Offset2D offset) {
        ArgChecks.nullNotPermitted((Object)refPt, "refPt");
        ArgChecks.nullNotPermitted(offset, "offset");
        this.refPt = refPt;
        this.offset = offset;
    }

    public RefPt2D getRefPt() {
        return this.refPt;
    }

    public Offset2D getOffset() {
        return this.offset;
    }

    public Point2D getAnchorPoint(Rectangle2D rect) {
        ArgChecks.nullNotPermitted(rect, "rect");
        double x = 0.0;
        double y = 0.0;
        if (this.refPt.isLeft()) {
            x = rect.getX() + this.offset.getDX();
        } else if (this.refPt.isHorizontalCenter()) {
            x = rect.getCenterX();
        } else if (this.refPt.isRight()) {
            x = rect.getMaxX() - this.offset.getDX();
        }
        if (this.refPt.isTop()) {
            y = rect.getMinY();
        } else if (this.refPt.isVerticalCenter()) {
            y = rect.getCenterY();
        } else if (this.refPt.isBottom()) {
            y = rect.getMaxY();
        }
        return new Point2D.Double(x, y);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Anchor2D)) {
            return false;
        }
        Anchor2D that = (Anchor2D)obj;
        if (!this.refPt.equals((Object)that.refPt)) {
            return false;
        }
        return this.offset.equals(that.offset);
    }
}

