/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data;

import com.orsoncharts.data.ItemKey;
import com.orsoncharts.util.ArgChecks;
import com.orsoncharts.util.ObjectUtils;
import java.io.Serializable;

public class KeyedValues3DItemKey<S extends Comparable<S>, R extends Comparable<R>, C extends Comparable<C>>
implements ItemKey,
Comparable<KeyedValues3DItemKey<S, R, C>>,
Serializable {
    S seriesKey;
    R rowKey;
    C columnKey;

    public KeyedValues3DItemKey(S seriesKey, R rowKey, C columnKey) {
        ArgChecks.nullNotPermitted(seriesKey, "seriesKey");
        ArgChecks.nullNotPermitted(rowKey, "rowKey");
        ArgChecks.nullNotPermitted(columnKey, "columnKey");
        this.seriesKey = seriesKey;
        this.rowKey = rowKey;
        this.columnKey = columnKey;
    }

    public S getSeriesKey() {
        return this.seriesKey;
    }

    public R getRowKey() {
        return this.rowKey;
    }

    public C getColumnKey() {
        return this.columnKey;
    }

    @Override
    public int compareTo(KeyedValues3DItemKey<S, R, C> key) {
        int result = this.seriesKey.compareTo(key.getSeriesKey());
        if (result == 0 && (result = this.rowKey.compareTo(key.rowKey)) == 0) {
            result = this.columnKey.compareTo(key.columnKey);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof KeyedValues3DItemKey)) {
            return false;
        }
        KeyedValues3DItemKey that = (KeyedValues3DItemKey)obj;
        if (!this.seriesKey.equals(that.seriesKey)) {
            return false;
        }
        if (!this.rowKey.equals(that.rowKey)) {
            return false;
        }
        return this.columnKey.equals(that.columnKey);
    }

    public int hashCode() {
        int hash = 3;
        hash = 17 * hash + ObjectUtils.hashCode(this.seriesKey);
        hash = 17 * hash + ObjectUtils.hashCode(this.rowKey);
        hash = 17 * hash + ObjectUtils.hashCode(this.columnKey);
        return hash;
    }

    @Override
    public String toJSONString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"seriesKey\": \"").append(this.seriesKey.toString());
        sb.append("\", ");
        sb.append("\"rowKey\": \"").append(this.rowKey.toString());
        sb.append("\", ");
        sb.append("\"columnKey\": \"").append(this.columnKey.toString());
        sb.append("\"}");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Values3DItemKey[series=");
        sb.append(this.seriesKey.toString()).append(",row=");
        sb.append(this.rowKey.toString()).append(",column=");
        sb.append(this.columnKey.toString());
        sb.append("]");
        return sb.toString();
    }
}

