/*
 * Decompiled with CFR 0.152.
 */
package com.orsoncharts.data.category;

import com.orsoncharts.data.AbstractDataset3D;
import com.orsoncharts.data.DefaultKeyedValues3D;
import com.orsoncharts.data.JSONUtils;
import com.orsoncharts.data.KeyedValues;
import com.orsoncharts.data.category.CategoryDataset3D;
import com.orsoncharts.util.ArgChecks;
import java.io.Serializable;
import java.util.List;

public final class StandardCategoryDataset3D
extends AbstractDataset3D
implements CategoryDataset3D,
Serializable {
    private DefaultKeyedValues3D<Number> data = new DefaultKeyedValues3D();

    @Override
    public int getSeriesCount() {
        return this.data.getSeriesCount();
    }

    @Override
    public int getRowCount() {
        return this.data.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    @Override
    public Comparable<?> getSeriesKey(int seriesIndex) {
        return this.data.getSeriesKey(seriesIndex);
    }

    @Override
    public Comparable<?> getRowKey(int rowIndex) {
        return this.data.getRowKey(rowIndex);
    }

    @Override
    public Comparable<?> getColumnKey(int columnIndex) {
        return this.data.getColumnKey(columnIndex);
    }

    @Override
    public int getSeriesIndex(Comparable<?> serieskey) {
        return this.data.getSeriesIndex(serieskey);
    }

    @Override
    public int getRowIndex(Comparable<?> rowkey) {
        return this.data.getRowIndex(rowkey);
    }

    @Override
    public int getColumnIndex(Comparable<?> columnkey) {
        return this.data.getColumnIndex(columnkey);
    }

    @Override
    public List<Comparable<?>> getSeriesKeys() {
        return this.data.getSeriesKeys();
    }

    @Override
    public List<Comparable<?>> getRowKeys() {
        return this.data.getRowKeys();
    }

    @Override
    public List<Comparable<?>> getColumnKeys() {
        return this.data.getColumnKeys();
    }

    @Override
    public Number getValue(Comparable<?> seriesKey, Comparable<?> rowKey, Comparable<?> columnKey) {
        return this.data.getValue(seriesKey, rowKey, columnKey);
    }

    @Override
    public Number getValue(int seriesIndex, int rowIndex, int columnIndex) {
        return this.data.getValue(seriesIndex, rowIndex, columnIndex);
    }

    public void setValue(Number n, Comparable<?> seriesKey, Comparable<?> rowKey, Comparable<?> columnKey) {
        this.data.setValue(n, seriesKey, rowKey, columnKey);
        this.fireDatasetChanged();
    }

    public void addValue(Number n, Comparable<?> seriesKey, Comparable<?> rowKey, Comparable<?> columnKey) {
        this.setValue(n, seriesKey, rowKey, columnKey);
    }

    @Override
    public double getDoubleValue(int seriesIndex, int rowIndex, int columnIndex) {
        return this.data.getDoubleValue(seriesIndex, rowIndex, columnIndex);
    }

    public void addSeriesAsRow(Comparable<?> seriesKey, KeyedValues<? extends Number> data) {
        this.addSeriesAsRow(seriesKey, seriesKey, data);
    }

    public void addSeriesAsRow(Comparable<?> seriesKey, Comparable<?> rowKey, KeyedValues<? extends Number> data) {
        ArgChecks.nullNotPermitted(seriesKey, "seriesKey");
        ArgChecks.nullNotPermitted(data, "data");
        for (Comparable<?> key : data.getKeys()) {
            this.setValue(data.getValue(key), seriesKey, rowKey, key);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardCategoryDataset3D)) {
            return false;
        }
        StandardCategoryDataset3D that = (StandardCategoryDataset3D)obj;
        return this.data.equals(that.data);
    }

    public String toString() {
        return JSONUtils.writeKeyedValues3D(this);
    }
}

