/*
 * Decompiled with CFR 0.152.
 */
package com.orsonpdf;

import com.orsonpdf.Dictionary;
import com.orsonpdf.FunctionType;
import com.orsonpdf.PDFObject;
import com.orsonpdf.PDFUtils;
import com.orsonpdf.util.Args;

public abstract class Function
extends PDFObject {
    private FunctionType functionType;
    private double[] domain;
    protected Dictionary dictionary;

    protected Function(int number, FunctionType functionType) {
        super(number);
        Args.nullNotPermitted((Object)functionType, "functionType");
        this.functionType = functionType;
        this.domain = new double[]{0.0, 1.0};
        this.dictionary = new Dictionary();
        this.dictionary.put("/Domain", PDFUtils.toPDFArray(this.domain));
        this.dictionary.put("/FunctionType", String.valueOf(functionType.getNumber()));
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public double[] getDomain() {
        return (double[])this.domain.clone();
    }

    public void setDomain(double[] domain) {
        Args.nullNotPermitted(domain, "domain");
        this.domain = (double[])domain.clone();
        this.dictionary.put("/Domain", PDFUtils.toPDFArray(this.domain));
    }

    @Override
    public byte[] getObjectBytes() {
        return this.dictionary.toPDFBytes();
    }
}

