/*
 * Decompiled with CFR 0.152.
 */
package com.orsonpdf;

import com.orsonpdf.Dictionary;
import com.orsonpdf.PDFObject;
import com.orsonpdf.PDFUtils;
import com.orsonpdf.shading.Shading;
import com.orsonpdf.util.Args;
import java.awt.geom.AffineTransform;

public abstract class Pattern
extends PDFObject {
    protected Dictionary dictionary = new Dictionary("/Pattern");

    protected Pattern(int number) {
        super(number);
    }

    @Override
    public byte[] getObjectBytes() {
        return this.dictionary.toPDFBytes();
    }

    public static final class ShadingPattern
    extends Pattern {
        private Shading shading;

        public ShadingPattern(int number, Shading shading, AffineTransform t) {
            super(number);
            this.dictionary.put("/PatternType", "2");
            this.dictionary.put("/Matrix", PDFUtils.transformToPDF(t));
            this.setShading(shading);
        }

        public Shading getShading() {
            return this.shading;
        }

        public void setShading(Shading shading) {
            Args.nullNotPermitted(shading, "shading");
            this.shading = shading;
            this.dictionary.put("/Shading", this.shading);
        }
    }
}

