/*
 * Decompiled with CFR 0.152.
 */
package com.orsonpdf.font;

import com.orsonpdf.font.TableInfo;
import com.orsonpdf.font.TrueTypeTable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class TrueTypeFont {
    private List<TableInfo> tableInfoList = new ArrayList<TableInfo>();

    private static TrueTypeTable readcmapTable(TableInfo info, FileInputStream in) throws IOException {
        System.out.println("Reading cmap table...");
        FileChannel channel = in.getChannel();
        channel.position(info.getOffset());
        int version = TrueTypeFont.readUInt2(in);
        System.out.println("version = " + version);
        int numTables = TrueTypeFont.readUInt2(in);
        System.out.println("numTables=" + numTables);
        for (int i = 0; i < numTables; ++i) {
            int platformID = TrueTypeFont.readUInt2(in);
            int encodingID = TrueTypeFont.readUInt2(in);
            int offset = TrueTypeFont.readInt4(in);
            long savePosition = channel.position();
            System.out.println("subtable: platformID=" + platformID + ", encodingID=" + encodingID + ", offset=" + offset);
            channel.position(info.getOffset() + offset);
            TrueTypeFont.readcmapSubTable(info, in);
            channel.position(savePosition);
        }
        return null;
    }

    private static Object readcmapSubTable(TableInfo info, FileInputStream in) throws IOException {
        int format = TrueTypeFont.readUInt2(in);
        System.out.println("format=" + format);
        int length = TrueTypeFont.readUInt2(in);
        System.out.println("length=" + length);
        int language = TrueTypeFont.readUInt2(in);
        System.out.println("language=" + language);
        if (format == 0) {
            for (int i = 0; i < 256; ++i) {
                int index = TrueTypeFont.readByte(in);
                System.out.print(index + " ");
            }
            System.out.println();
        } else if (format == 4) {
            int i;
            int segCountX2 = TrueTypeFont.readUInt2(in);
            int segCount = segCountX2 / 2;
            System.out.println("segCountX2=" + segCountX2);
            int searchRange = TrueTypeFont.readUInt2(in);
            System.out.println("searchRange=" + searchRange);
            int entrySelector = TrueTypeFont.readUInt2(in);
            System.out.println("entrySelector=" + entrySelector);
            int rangeShift = TrueTypeFont.readUInt2(in);
            System.out.println("rangeShift=" + rangeShift);
            for (int i2 = 0; i2 < segCount; ++i2) {
                int end = TrueTypeFont.readUInt2(in);
                System.out.print(end + " ");
            }
            System.out.println();
            int reservePad = TrueTypeFont.readUInt2(in);
            for (i = 0; i < segCount; ++i) {
                int start = TrueTypeFont.readUInt2(in);
                System.out.print(start + " ");
            }
            System.out.println();
            for (i = 0; i < segCount; ++i) {
                int idDelta = TrueTypeFont.readInt2(in);
                System.out.print(idDelta + " ");
            }
            System.out.println();
            for (i = 0; i < segCount; ++i) {
                int idRangeOffset = TrueTypeFont.readUInt2(in);
                System.out.print(idRangeOffset + " ");
            }
            System.out.println();
            System.out.println("Remains: " + length + "-16-8x" + segCount + "=");
            int entryCount = (length - 16 - 8 * segCount) / 2;
            System.out.println(entryCount);
            for (int i3 = 0; i3 < entryCount; ++i3) {
                int entry = TrueTypeFont.readUInt2(in);
                System.out.print(entry + " ");
            }
            System.out.println();
        }
        return null;
    }

    private static TrueTypeTable readhheaTable(TableInfo info, FileInputStream in) throws IOException {
        FileChannel channel = in.getChannel();
        channel.position(info.getOffset());
        int v1 = TrueTypeFont.readUInt2(in);
        int v2 = TrueTypeFont.readUInt2(in);
        System.out.println("Version " + v1 + "." + v2);
        int ascender = TrueTypeFont.readWord2(in);
        System.out.println("ascender=" + ascender);
        int descender = TrueTypeFont.readWord2(in);
        System.out.println("descender=" + descender);
        int lineGap = TrueTypeFont.readWord2(in);
        System.out.println("lineGap=" + lineGap);
        int advanceWidthMax = TrueTypeFont.readUInt2(in);
        System.out.println("advanceWidthMax=" + advanceWidthMax);
        int minLeftSideBearing = TrueTypeFont.readWord2(in);
        System.out.println("minLeftSideBearing=" + minLeftSideBearing);
        int minRightSideBearing = TrueTypeFont.readWord2(in);
        System.out.println("minRightSideBearing=" + minRightSideBearing);
        int xMaxExtent = TrueTypeFont.readWord2(in);
        System.out.println("xMaxExtent=" + xMaxExtent);
        int caretSlopeRise = TrueTypeFont.readInt2(in);
        System.out.println("caretSlopeRise=" + caretSlopeRise);
        int caretSlopeRun = TrueTypeFont.readInt2(in);
        System.out.println("caretSlopeRun=" + caretSlopeRun);
        int caretOffset = TrueTypeFont.readInt2(in);
        System.out.println("caretOffset=" + caretOffset);
        int ignore = TrueTypeFont.readInt2(in);
        ignore = TrueTypeFont.readInt2(in);
        ignore = TrueTypeFont.readInt2(in);
        ignore = TrueTypeFont.readInt2(in);
        int metricDataFormat = TrueTypeFont.readInt2(in);
        System.out.println("metricDataFormat=" + metricDataFormat);
        int numberOfHMetrics = TrueTypeFont.readUInt2(in);
        System.out.println("numberOfHMetrics=" + numberOfHMetrics);
        return null;
    }

    private static TrueTypeTable readhmtxTable(TableInfo info, FileInputStream in, int entries) throws IOException {
        FileChannel channel = in.getChannel();
        channel.position(info.getOffset());
        for (int i = 0; i < 3381; ++i) {
            int advanceWidth = TrueTypeFont.readInt2(in);
            int lsb = TrueTypeFont.readUInt2(in);
        }
        return null;
    }

    private static int readByte(InputStream in) throws IOException {
        byte[] data = new byte[1];
        in.read(data);
        return data[0] & 0xFF;
    }

    private static int readUInt2(InputStream in) throws IOException {
        byte[] data = new byte[2];
        in.read(data);
        return (data[0] & 0xFF) << 8 | data[1] & 0xFF;
    }

    private static int readInt2(InputStream in) throws IOException {
        byte[] data = new byte[2];
        in.read(data);
        return data[0] * 256 + data[1];
    }

    private static int readWord2(InputStream in) throws IOException {
        byte[] data = new byte[2];
        in.read(data);
        return data[0] * 256 + (data[1] & 0xFF);
    }

    private static int readInt4(InputStream in) throws IOException {
        byte[] data = new byte[4];
        in.read(data);
        int d0 = data[0] & 0xFF;
        int d1 = data[1] & 0xFF;
        int d2 = data[2] & 0xFF;
        int d3 = data[3] & 0xFF;
        return 0x1000000 * d0 + 65536 * d1 + 256 * d2 + d3;
    }

    private static String readTag(InputStream in) throws IOException {
        byte[] b = new byte[4];
        in.read(b);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            sb.append((char)b[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrueTypeFont createFont(File file) throws FileNotFoundException, IOException {
        TrueTypeFont font = new TrueTypeFont();
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] version = new byte[4];
            fis.read(version);
            int tableCount = TrueTypeFont.readUInt2(fis);
            int ignore1 = TrueTypeFont.readUInt2(fis);
            int ignore2 = TrueTypeFont.readUInt2(fis);
            int ignore3 = TrueTypeFont.readUInt2(fis);
            for (int i = 0; i < tableCount; ++i) {
                String tag = TrueTypeFont.readTag(fis);
                System.out.println(tag);
                int checksum = TrueTypeFont.readInt4(fis);
                int offset = TrueTypeFont.readInt4(fis);
                int length = TrueTypeFont.readInt4(fis);
                TableInfo tableInfo = new TableInfo(tag, checksum, offset, length);
                font.addTableInfo(tableInfo);
            }
            TableInfo cmapInfo = font.getTableInfo("cmap");
            System.out.println(cmapInfo);
            TrueTypeFont.readcmapTable(cmapInfo, fis);
            TableInfo info = font.getTableInfo("hhea");
            System.out.println(info);
            TrueTypeTable t = TrueTypeFont.readhheaTable(info, fis);
            info = font.getTableInfo("hmtx");
            System.out.println(info);
            TrueTypeTable t2 = TrueTypeFont.readhmtxTable(info, fis, 0);
        }
        finally {
            fis.close();
        }
        return font;
    }

    private TrueTypeFont() {
    }

    public void addTableInfo(TableInfo tableInfo) {
        this.tableInfoList.add(tableInfo);
    }

    public TableInfo getTableInfo(String tag) {
        for (TableInfo ti : this.tableInfoList) {
            if (!tag.equals(ti.getTag())) continue;
            return ti;
        }
        return null;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        File f = new File("/Library/Fonts/Arial.ttf");
        TrueTypeFont font = TrueTypeFont.createFont(f);
    }
}

