/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test;

import java.security.Key;
import java.security.Provider;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class KeySelectorTest
extends Assert {
    private Key key = new MyOwnKey("test", new byte[16]);
    private KeySelector selector1 = KeySelector.singletonKeySelector(this.key);

    @Test
    public void testselect() throws Exception {
        KeyInfoFactory keyInfoFactory = KeyInfoFactory.getInstance("DOM", (Provider)new XMLDSigRI());
        X509Data x509Data = keyInfoFactory.newX509Data(Collections.singletonList("CN=foo"));
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(x509Data));
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
        SignatureMethod signatureMethod = xMLSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
        SignatureMethod signatureMethod2 = xMLSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        KeySelectorTest.assertTrue((boolean)KeySelectorTest.compareKey(this.key, this.selector1.select(keyInfo, KeySelector.Purpose.VERIFY, signatureMethod, null).getKey()));
        KeySelectorTest.assertTrue((boolean)KeySelectorTest.compareKey(this.key, this.selector1.select(keyInfo, KeySelector.Purpose.VERIFY, signatureMethod2, null).getKey()));
    }

    private static boolean compareKey(Object object, Key key) {
        boolean bl = false;
        if (object instanceof MyOwnKey) {
            bl = (MyOwnKey)object == key;
        } else if (object instanceof X509Certificate) {
            bl = ((X509Certificate)object).getPublicKey().equals(key);
        }
        return bl;
    }

    private class MyOwnKey
    implements Key {
        private static final long serialVersionUID = -3288147894137347920L;
        private String algo;
        private byte[] val;

        MyOwnKey(String string, byte[] byArray) {
            this.algo = string;
            this.val = (byte[])byArray.clone();
        }

        public String getAlgorithm() {
            return this.algo;
        }

        public byte[] getEncoded() {
            return this.val;
        }

        public String getFormat() {
            return "RAW";
        }
    }
}

