/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.LocalHttpCacheURIDereferencer;
import javax.xml.crypto.test.dsig.SignatureValidator;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class Baltimore18Test
extends Assert {
    private SignatureValidator validator;
    private File dir;
    private KeySelector cks;
    private URIDereferencer ud;

    public Baltimore18Test() {
        String string = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        String string2 = System.getProperty("file.separator");
        this.dir = new File(string + string2 + "src/test/resources" + string2 + "ie" + string2 + "baltimore" + string2 + "merlin-examples", "merlin-xmldsig-eighteen");
        this.validator = new SignatureValidator(this.dir);
        this.cks = new KeySelectors.CollectionKeySelector(this.dir);
        this.ud = new LocalHttpCacheURIDereferencer();
    }

    @Test
    public void testSignatureKeyname() throws Exception {
        String string = "signature-keyname.xml";
        boolean bl = this.validator.validate(string, this.cks, this.ud);
        Baltimore18Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void testSignatureRetrievalmethodRawx509crt() throws Exception {
        String string = "signature-retrievalmethod-rawx509crt.xml";
        boolean bl = this.validator.validate(string, this.cks, this.ud);
        Baltimore18Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void testSignatureX509CrtCrl() throws Exception {
        String string = "signature-x509-crt-crl.xml";
        boolean bl = this.validator.validate(string, this.cks, this.ud);
        Baltimore18Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void testSignatureX509Crt() throws Exception {
        String string = "signature-x509-crt.xml";
        boolean bl = this.validator.validate(string, this.cks, this.ud);
        Baltimore18Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void testSignatureX509Is() throws Exception {
        String string = "signature-x509-is.xml";
        boolean bl = this.validator.validate(string, this.cks, this.ud);
        Baltimore18Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void testSignatureX509Ski() throws Exception {
        String string = "signature-x509-ski.xml";
        boolean bl = this.validator.validate(string, this.cks, this.ud);
        Baltimore18Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    @Test
    public void testSignatureX509Sn() throws Exception {
        String string = "signature-x509-sn.xml";
        boolean bl = this.validator.validate(string, this.cks, this.ud);
        Baltimore18Test.assertTrue((String)"Signature failed core validation", (boolean)bl);
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

