/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.security.Provider;
import java.security.Security;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.SignatureValidator;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class C14N11Test
extends Assert {
    private SignatureValidator validator;
    private File dir;
    private KeySelector sks;
    private static String[] vendors = new String[]{"IAIK", "IBM", "ORCL", "SUN", "UPC"};

    public C14N11Test() throws Exception {
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        this.dir = new File(string2 + string + "src/test/resources" + string + "org" + string + "w3c" + string + "www" + string + "interop" + string + "xmldsig" + string + "c14n11");
        this.validator = new SignatureValidator(this.dir);
        this.sks = new KeySelectors.SecretKeySelector("secret".getBytes("ASCII"));
    }

    @Test
    public void test_xmlid_1() throws Exception {
        this.test_c14n11("xmlid-1");
    }

    @Test
    public void test_xmlid_2() throws Exception {
        this.test_c14n11("xmlid-2");
    }

    @Test
    public void test_xmlspace_1() throws Exception {
        this.test_c14n11("xmlspace-1");
    }

    @Test
    public void test_xmlspace_2() throws Exception {
        this.test_c14n11("xmlspace-2");
    }

    @Test
    public void test_xmlspace_3() throws Exception {
        this.test_c14n11("xmlspace-3");
    }

    @Test
    public void test_xmlspace_4() throws Exception {
        this.test_c14n11("xmlspace-4");
    }

    @Test
    public void test_xmllang_1() throws Exception {
        this.test_c14n11("xmllang-1");
    }

    @Test
    public void test_xmllang_2() throws Exception {
        this.test_c14n11("xmllang-2");
    }

    @Test
    public void test_xmllang_3() throws Exception {
        this.test_c14n11("xmllang-3");
    }

    @Test
    public void test_xmllang_4() throws Exception {
        this.test_c14n11("xmllang-4");
    }

    @Test
    public void test_xmlbase_prop_1() throws Exception {
        this.test_c14n11("xmlbase-prop-1");
    }

    @Test
    public void test_xmlbase_prop_2() throws Exception {
        this.test_c14n11("xmlbase-prop-2");
    }

    @Test
    public void test_xmlbase_prop_3() throws Exception {
        this.test_c14n11("xmlbase-prop-3");
    }

    @Test
    public void test_xmlbase_prop_4() throws Exception {
        this.test_c14n11("xmlbase-prop-4");
    }

    @Test
    public void test_xmlbase_prop_5() throws Exception {
        this.test_c14n11("xmlbase-prop-5");
    }

    @Test
    public void test_xmlbase_prop_6() throws Exception {
        this.test_c14n11("xmlbase-prop-6");
    }

    @Test
    public void test_xmlbase_prop_7() throws Exception {
        this.test_c14n11("xmlbase-prop-7");
    }

    @Test
    public void test_xmlbase_c14n11spec_102() throws Exception {
        String[] stringArray = new String[]{"IAIK", "IBM", "ORCL", "SUN", "UPC"};
        this.test_c14n11("xmlbase-c14n11spec-102", stringArray);
    }

    @Test
    public void test_xmlbase_c14n11spec2_102() throws Exception {
        String[] stringArray = new String[]{"IAIK", "IBM", "ORCL", "SUN"};
        this.test_c14n11("xmlbase-c14n11spec2-102", stringArray);
    }

    @Test
    public void test_xmlbase_c14n11spec3_103() throws Exception {
        String[] stringArray = new String[]{"IAIK", "IBM", "ORCL", "SUN", "UPC"};
        this.test_c14n11("xmlbase-c14n11spec3-103", stringArray);
    }

    private void test_c14n11(String string) throws Exception {
        for (int i = 0; i < vendors.length; ++i) {
            String string2 = string + "-" + vendors[i] + ".xml";
            boolean bl = this.validator.validate(string2, this.sks);
            C14N11Test.assertTrue((String)(string2 + " failed core validation"), (boolean)bl);
        }
    }

    private void test_c14n11(String string, String[] stringArray) throws Exception {
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + "-" + stringArray[i] + ".xml";
            boolean bl = this.validator.validate(string2, this.sks);
            C14N11Test.assertTrue((String)(string2 + " failed core validation"), (boolean)bl);
        }
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

