/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.crypto.test.dsig.TestUtils;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class CanonicalizationMethodTest
extends Assert {
    XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    private static final String[] C14N_ALGOS;

    @Test
    public void testIsFeatureSupported() throws Exception {
        for (int i = 0; i < C14N_ALGOS.length; ++i) {
            String string = C14N_ALGOS[i];
            ExcC14NParameterSpec excC14NParameterSpec = null;
            if (i >= 2) {
                excC14NParameterSpec = new ExcC14NParameterSpec();
            }
            CanonicalizationMethod canonicalizationMethod = this.factory.newCanonicalizationMethod(string, excC14NParameterSpec);
            try {
                canonicalizationMethod.isFeatureSupported(null);
                CanonicalizationMethodTest.fail((String)"Should raise a NPE for null feature");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            CanonicalizationMethodTest.assertTrue((!canonicalizationMethod.isFeatureSupported("not supported") ? 1 : 0) != 0);
        }
    }

    @Test
    public void testConstructor() throws Exception {
        CanonicalizationMethod canonicalizationMethod;
        for (int i = 0; i < C14N_ALGOS.length; ++i) {
            String string = C14N_ALGOS[i];
            canonicalizationMethod = this.factory.newCanonicalizationMethod(string, (C14NMethodParameterSpec)null);
            CanonicalizationMethodTest.assertNotNull((Object)canonicalizationMethod);
            CanonicalizationMethodTest.assertEquals((Object)canonicalizationMethod.getAlgorithm(), (Object)string);
            CanonicalizationMethodTest.assertNull((Object)canonicalizationMethod.getParameterSpec());
            try {
                canonicalizationMethod = this.factory.newCanonicalizationMethod(string, new TestUtils.MyOwnC14nParameterSpec());
                CanonicalizationMethodTest.fail((String)"Should raise an IAPE for invalid c14n parameters");
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            }
            catch (Exception exception) {
                CanonicalizationMethodTest.fail((String)("Should raise a IAPE instead of " + exception));
            }
            if (!string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") && !string.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) continue;
            canonicalizationMethod = this.factory.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", new ExcC14NParameterSpec());
            AlgorithmParameterSpec algorithmParameterSpec = canonicalizationMethod.getParameterSpec();
            CanonicalizationMethodTest.assertNotNull((Object)algorithmParameterSpec);
            CanonicalizationMethodTest.assertTrue((boolean)(algorithmParameterSpec instanceof ExcC14NParameterSpec));
        }
        try {
            canonicalizationMethod = this.factory.newCanonicalizationMethod(null, (C14NMethodParameterSpec)null);
            CanonicalizationMethodTest.fail((String)"Should raise a NPE for null algo");
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            CanonicalizationMethodTest.fail((String)("Should raise a NPE instead of " + exception));
        }
        try {
            canonicalizationMethod = this.factory.newCanonicalizationMethod("non-existent", (C14NMethodParameterSpec)null);
            CanonicalizationMethodTest.fail((String)"Should raise an NSAE for non-existent algos");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (Exception exception) {
            CanonicalizationMethodTest.fail((String)("Should raise an NSAE instead of " + exception));
        }
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
        C14N_ALGOS = new String[]{"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "http://www.w3.org/2001/10/xml-exc-c14n#WithComments", "http://www.w3.org/2001/10/xml-exc-c14n#"};
    }
}

