/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.junit.Assert;
import org.junit.Test;

public class ClassLoaderTest
extends Assert {
    private static Log log = LogFactory.getLog(ClassLoaderTest.class);

    @Test
    public void testMultipleLoaders() throws Exception {
        String string = System.getProperty("basedir");
        String string2 = System.getProperty("file.separator");
        File file = new File(string + string2 + "build" + string2 + "classes" + string2);
        File file2 = new File(string + string2 + "build" + string2 + "test" + string2);
        URL[] uRLArray = new URL[]{file.toURI().toURL(), file2.toURI().toURL()};
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
        URLClassLoader uRLClassLoader2 = new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
        Class<?> clazz = uRLClassLoader.loadClass("javax.xml.crypto.test.dsig.Driver");
        Class<?> clazz2 = uRLClassLoader2.loadClass("javax.xml.crypto.test.dsig.Driver");
        Object obj = clazz.newInstance();
        Object obj2 = clazz2.newInstance();
        Method method = clazz.getMethod("dsig", null);
        Method method2 = clazz2.getMethod("dsig", null);
        method.invoke(obj, (Object[])null);
        method2.invoke(obj2, (Object[])null);
    }

    @Test
    public void testProviderMultipleLoaders() throws Exception {
        String string = System.getProperty("basedir");
        String string2 = System.getProperty("file.separator");
        File file = new File(string + string2 + "build" + string2 + "classes" + string2);
        File file2 = new File(string + string2 + "build" + string2 + "test" + string2);
        URL[] uRLArray = new URL[]{file.toURI().toURL(), file2.toURI().toURL()};
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
        XMLDSigRI xMLDSigRI = new XMLDSigRI();
        AccessController.doPrivileged(new PrivilegedAction<Object>((Provider)xMLDSigRI){
            final /* synthetic */ Provider val$provider;
            {
                this.val$provider = provider;
            }

            @Override
            public Object run() {
                Security.addProvider(this.val$provider);
                return null;
            }
        });
        String string3 = "javax.xml.crypto.dsig.XMLSignatureFactory";
        Class<?> clazz = uRLClassLoader.loadClass(string3);
        Method method = clazz.getDeclaredMethod("getInstance", String.class);
        Class<?> clazz2 = uRLClassLoader.loadClass("javax.xml.crypto.dsig.spec.C14NMethodParameterSpec");
        Method method2 = clazz.getDeclaredMethod("newCanonicalizationMethod", String.class, clazz2);
        Object object = method.invoke(null, "DOM");
        long l = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            method2.invoke(object, "http://www.w3.org/2001/10/xml-exc-c14n#", null);
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Elapsed: " + l3));
        }
    }

    @Test
    public void testProviderMultipleLoadersTwo() throws Exception {
        String string = System.getProperty("basedir");
        String string2 = System.getProperty("file.separator");
        File file = new File(string + string2 + "build" + string2 + "classes" + string2);
        File file2 = new File(string + string2 + "build" + string2 + "test" + string2);
        URL[] uRLArray = new URL[]{file.toURI().toURL(), file2.toURI().toURL()};
        URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
        URLClassLoader uRLClassLoader2 = new URLClassLoader(uRLArray, Thread.currentThread().getContextClassLoader());
        Class<?> clazz = uRLClassLoader.loadClass("javax.xml.crypto.test.dsig.AppA");
        Class<?> clazz2 = uRLClassLoader2.loadClass("javax.xml.crypto.test.dsig.AppB");
        Object obj = clazz.newInstance();
        Object obj2 = clazz2.newInstance();
        Method method = clazz.getMethod("dsig", null);
        Method method2 = clazz2.getMethod("dsig", null);
        method.invoke(obj, (Object[])null);
        method2.invoke(obj2, (Object[])null);
    }
}

