/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.HMACParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import javax.xml.crypto.dsig.spec.XSLTTransformParameterSpec;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.LocalHttpCacheURIDereferencer;
import javax.xml.crypto.test.dsig.SignatureValidator;
import javax.xml.crypto.test.dsig.TestUtils;
import javax.xml.crypto.test.dsig.X509KeySelector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class CreateBaltimore23Test
extends Assert {
    private XMLSignatureFactory fac;
    private KeyInfoFactory kifac;
    private DocumentBuilder db;
    private CanonicalizationMethod withoutComments;
    private Transform withComments;
    private SignatureMethod dsaSha1;
    private SignatureMethod rsaSha1;
    private DigestMethod sha1;
    private KeyInfo dsa;
    private KeyInfo rsa;
    private KeySelector kvks = new KeySelectors.KeyValueKeySelector();
    private KeySelector sks;
    private Key signingKey;
    private PublicKey validatingKey;
    private Certificate signingCert;
    private KeyStore ks;
    private final URIDereferencer ud;

    public CreateBaltimore23Test() throws Exception {
        this.fac = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
        this.kifac = this.fac.getKeyInfoFactory();
        this.db = XMLUtils.createDocumentBuilder((boolean)false);
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        FileInputStream fileInputStream = new FileInputStream(string2 + string + "src/test/resources" + string + "test.jks");
        this.ks = KeyStore.getInstance("JKS");
        this.ks.load(fileInputStream, "changeit".toCharArray());
        this.signingKey = this.ks.getKey("mullan", "changeit".toCharArray());
        this.signingCert = this.ks.getCertificate("mullan");
        this.validatingKey = this.signingCert.getPublicKey();
        this.withoutComments = this.fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null);
        this.withComments = this.fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (TransformParameterSpec)null);
        this.dsaSha1 = this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
        this.sha1 = this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        this.dsa = this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newKeyValue(this.validatingKey)));
        this.rsa = this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newKeyValue(TestUtils.getPublicKey("RSA"))));
        this.rsaSha1 = this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        this.sks = new KeySelectors.SecretKeySelector("secret".getBytes("ASCII"));
        this.ud = new LocalHttpCacheURIDereferencer();
    }

    @Test
    public void test_create_signature_enveloped_dsa() throws Exception {
        SignedInfo signedInfo = this.fac.newSignedInfo(this.withoutComments, this.dsaSha1, Collections.singletonList(this.fac.newReference("", this.sha1, Collections.singletonList(this.fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null)));
        XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, this.dsa);
        Document document = this.db.newDocument();
        Element element = document.createElementNS("http://example.org/envelope", "Envelope");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://example.org/envelope");
        document.appendChild(element);
        DOMSignContext dOMSignContext = new DOMSignContext(this.signingKey, (Node)element);
        xMLSignature.sign(dOMSignContext);
        DOMValidateContext dOMValidateContext = new DOMValidateContext(this.kvks, element.getFirstChild());
        XMLSignature xMLSignature2 = this.fac.unmarshalXMLSignature(dOMValidateContext);
        CreateBaltimore23Test.assertTrue((boolean)xMLSignature.equals(xMLSignature2));
        CreateBaltimore23Test.assertTrue((boolean)xMLSignature2.validate(dOMValidateContext));
    }

    @Test
    public void test_create_signature_enveloping_b64_dsa() throws Exception {
        this.test_create_signature_enveloping(this.dsaSha1, this.dsa, this.signingKey, this.kvks, true);
    }

    @Test
    public void test_create_signature_enveloping_dsa() throws Exception {
        this.test_create_signature_enveloping(this.dsaSha1, this.dsa, this.signingKey, this.kvks, false);
    }

    @Test
    public void test_create_signature_enveloping_hmac_sha1_40() throws Exception {
        SignatureMethod signatureMethod = this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#hmac-sha1", new HMACParameterSpec(40));
        try {
            this.test_create_signature_enveloping(signatureMethod, null, TestUtils.getSecretKey("secret".getBytes("ASCII")), this.sks, false);
            CreateBaltimore23Test.fail((String)"Expected HMACOutputLength Exception");
        }
        catch (XMLSignatureException xMLSignatureException) {
            System.out.println(xMLSignatureException.getMessage());
        }
    }

    @Test
    public void test_create_signature_enveloping_hmac_sha1() throws Exception {
        SignatureMethod signatureMethod = this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#hmac-sha1", null);
        this.test_create_signature_enveloping(signatureMethod, null, TestUtils.getSecretKey("secret".getBytes("ASCII")), this.sks, false);
    }

    @Test
    public void test_create_signature_enveloping_rsa() throws Exception {
        this.test_create_signature_enveloping(this.rsaSha1, this.rsa, TestUtils.getPrivateKey("RSA"), this.kvks, false);
    }

    @Test
    public void test_create_signature_external_b64_dsa() throws Exception {
        this.test_create_signature_external(this.dsaSha1, this.dsa, this.signingKey, this.kvks, true);
    }

    @Test
    public void test_create_signature_external_dsa() throws Exception {
        this.test_create_signature_external(this.dsaSha1, this.dsa, this.signingKey, this.kvks, false);
    }

    @Test
    public void test_create_signature_keyname() throws Exception {
        KeyInfo keyInfo = this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newKeyName("mullan")));
        this.test_create_signature_external(this.dsaSha1, keyInfo, this.signingKey, new X509KeySelector(this.ks), false);
    }

    @Test
    public void test_create_signature_retrievalmethod_rawx509crt() throws Exception {
        KeyInfo keyInfo = this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newRetrievalMethod("certs/mullan.crt", "http://www.w3.org/2000/09/xmldsig#rawX509Certificate", null)));
        this.test_create_signature_external(this.dsaSha1, keyInfo, this.signingKey, new X509KeySelector(this.ks), false);
    }

    @Test
    public void test_create_signature_x509_crt_crl() throws Exception {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        arrayList.add(this.signingCert);
        String string = System.getProperty("file.separator");
        String string2 = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        FileInputStream fileInputStream = new FileInputStream(string2 + string + "src/test/resources" + string + "ie" + string + "baltimore" + string + "merlin-examples" + string + "merlin-xmldsig-twenty-three" + string + "certs" + string + "crl");
        X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL(fileInputStream);
        fileInputStream.close();
        arrayList.add(x509CRL);
        KeyInfo keyInfo = this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newX509Data(arrayList)));
        this.test_create_signature_external(this.dsaSha1, keyInfo, this.signingKey, new X509KeySelector(this.ks), false);
    }

    @Test
    public void test_create_signature_x509_crt() throws Exception {
        KeyInfo keyInfo = this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newX509Data(Collections.singletonList(this.signingCert))));
        this.test_create_signature_external(this.dsaSha1, keyInfo, this.signingKey, new X509KeySelector(this.ks), false);
    }

    @Test
    public void test_create_signature_x509_is() throws Exception {
        KeyInfo keyInfo = this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newX509Data(Collections.singletonList(this.kifac.newX509IssuerSerial("CN=Sean Mullan,DC=sun,DC=com", new BigInteger("47cdb772", 16))))));
        this.test_create_signature_external(this.dsaSha1, keyInfo, this.signingKey, new X509KeySelector(this.ks), false);
    }

    @Test
    public void test_create_signature_x509_ski() throws Exception {
        KeyInfo keyInfo = this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newX509Data(Collections.singletonList("keyid".getBytes("ASCII")))));
        this.test_create_signature_external(this.dsaSha1, keyInfo, this.signingKey, KeySelector.singletonKeySelector(this.validatingKey), false);
    }

    @Test
    public void test_create_signature_x509_sn() throws Exception {
        KeyInfo keyInfo = this.kifac.newKeyInfo(Collections.singletonList(this.kifac.newX509Data(Collections.singletonList("CN=Sean Mullan,DC=sun,DC=com"))));
        this.test_create_signature_external(this.dsaSha1, keyInfo, this.signingKey, new X509KeySelector(this.ks), false);
    }

    @Test
    public void test_create_signature() throws Exception {
        Transform transform = this.fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
        ArrayList<Reference> arrayList = new ArrayList<Reference>();
        arrayList.add(this.fac.newReference("http://www.w3.org/TR/xml-stylesheet", this.sha1));
        arrayList.add(this.fac.newReference("http://www.w3.org/Signature/2002/04/xml-stylesheet.b64", this.sha1, Collections.singletonList(this.fac.newTransform("http://www.w3.org/2000/09/xmldsig#base64", (TransformParameterSpec)null)), null, null));
        arrayList.add(this.fac.newReference("#object-1", this.sha1, Collections.singletonList(this.fac.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", new XPathFilterParameterSpec("self::text()"))), "http://www.w3.org/2000/09/xmldsig#Object", null));
        String string = "\n ancestor-or-self::dsig:SignedInfo\t\t\t \n  and                                               \n count(ancestor-or-self::dsig:Reference |\t\t \n\t   here()/ancestor::dsig:Reference[1]) >\t \n count(ancestor-or-self::dsig:Reference)\t\t \n  or                                                \n count(ancestor-or-self::node() |\t\t\t \n\t   id('notaries')) =\t\t\t\t \n count(ancestor-or-self::node())\t\t\t \n";
        new XPathFilterParameterSpec(string, Collections.singletonMap("dsig", "http://www.w3.org/2000/09/xmldsig#"));
        arrayList.add(this.fac.newReference("#object-2", this.sha1, Collections.singletonList(this.fac.newTransform("http://www.w3.org/2000/09/xmldsig#base64", (TransformParameterSpec)null)), "http://www.w3.org/2000/09/xmldsig#Object", null));
        arrayList.add(this.fac.newReference("#manifest-1", this.sha1, null, "http://www.w3.org/2000/09/xmldsig#Manifest", null));
        arrayList.add(this.fac.newReference("#signature-properties-1", this.sha1, null, "http://www.w3.org/2000/09/xmldsig#SignatureProperties", null));
        ArrayList<Transform> arrayList2 = new ArrayList<Transform>();
        arrayList2.add(transform);
        arrayList.add(this.fac.newReference("", this.sha1, arrayList2, null, null));
        arrayList2.add(this.withComments);
        arrayList.add(this.fac.newReference("", this.sha1, arrayList2, null, null));
        arrayList.add(this.fac.newReference("#xpointer(/)", this.sha1, Collections.singletonList(transform), null, null));
        arrayList.add(this.fac.newReference("#xpointer(/)", this.sha1, arrayList2, null, null));
        arrayList.add(this.fac.newReference("#object-3", this.sha1, null, "http://www.w3.org/2000/09/xmldsig#Object", null));
        arrayList.add(this.fac.newReference("#object-3", this.sha1, Collections.singletonList(this.withComments), "http://www.w3.org/2000/09/xmldsig#Object", null));
        arrayList.add(this.fac.newReference("#xpointer(id('object-3'))", this.sha1, null, "http://www.w3.org/2000/09/xmldsig#Object", null));
        arrayList.add(this.fac.newReference("#xpointer(id('object-3'))", this.sha1, Collections.singletonList(this.withComments), "http://www.w3.org/2000/09/xmldsig#Object", null));
        arrayList.add(this.fac.newReference("#reference-2", this.sha1));
        arrayList.add(this.fac.newReference("#manifest-reference-1", this.sha1, null, null, "reference-1"));
        arrayList.add(this.fac.newReference("#reference-1", this.sha1, null, null, "reference-2"));
        SignedInfo signedInfo = this.fac.newSignedInfo(this.withoutComments, this.dsaSha1, arrayList);
        XPathFilterParameterSpec xPathFilterParameterSpec = new XPathFilterParameterSpec("ancestor-or-self::dsig:X509Data", Collections.singletonMap("dsig", "http://www.w3.org/2000/09/xmldsig#"));
        RetrievalMethod retrievalMethod = this.kifac.newRetrievalMethod("#object-4", "http://www.w3.org/2000/09/xmldsig#X509Data", Collections.singletonList(this.fac.newTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xPathFilterParameterSpec)));
        KeyInfo keyInfo = this.kifac.newKeyInfo(Collections.singletonList(retrievalMethod), null);
        Document document = this.db.newDocument();
        ArrayList<XMLObject> arrayList3 = new ArrayList<XMLObject>();
        arrayList3.add(this.fac.newXMLObject(Collections.singletonList(new DOMStructure(document.createTextNode("I am the text."))), "object-1", "text/plain", null));
        arrayList3.add(this.fac.newXMLObject(Collections.singletonList(new DOMStructure(document.createTextNode("SSBhbSB0aGUgdGV4dC4="))), "object-2", "text/plain", "http://www.w3.org/2000/09/xmldsig#base64"));
        Element element = document.createElementNS(null, "NonCommentandus");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        element.appendChild(document.createComment(" Commentandum "));
        arrayList3.add(this.fac.newXMLObject(Collections.singletonList(new DOMStructure(element)), "object-3", null, null));
        ArrayList<Reference> arrayList4 = new ArrayList<Reference>();
        arrayList4.add(this.fac.newReference("http://www.w3.org/TR/xml-stylesheet", this.sha1, null, null, "manifest-reference-1"));
        arrayList4.add(this.fac.newReference("#reference-1", this.sha1));
        ArrayList<Transform> arrayList5 = new ArrayList<Transform>();
        String string2 = "<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform'\n\t\t xmlns='http://www.w3.org/TR/xhtml1/strict' \n\t\t exclude-result-prefixes='foo' \n\t\t version='1.0'>\n  <xsl:output encoding='UTF-8' \n\t\tindent='no' \n\t\tmethod='xml' />\n  <xsl:template match='/'>\n    <html>\n\t<head>\n\t <title>Notaries</title>\n\t</head>\n\t<body>\n\t <table>\n\t   <xsl:for-each select='Notaries/Notary'>\n\t\t<tr>\n\t\t<th>\n\t\t <xsl:value-of select='@name' />\n\t\t</th>\n\t\t</tr>\n\t   </xsl:for-each>\n\t </table>\n\t</body>\n    </html>\n  </xsl:template>\n</xsl:stylesheet>\n";
        Document document2 = this.db.parse(new ByteArrayInputStream(string2.getBytes()));
        Element element2 = document2.getDocumentElement();
        arrayList5.add(this.fac.newTransform("http://www.w3.org/TR/1999/REC-xslt-19991116", new XSLTTransformParameterSpec(new DOMStructure(element2))));
        arrayList5.add(this.fac.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (TransformParameterSpec)null));
        arrayList3.add(this.fac.newXMLObject(Collections.singletonList(this.fac.newManifest(arrayList4, "manifest-1")), null, null, null));
        Element element3 = document.createElementNS("urn:demo", "SignerAddress");
        element3.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:demo");
        Element element4 = document.createElementNS("urn:demo", "IP");
        element4.appendChild(document.createTextNode("192.168.21.138"));
        element3.appendChild(element4);
        SignatureProperty signatureProperty = this.fac.newSignatureProperty(Collections.singletonList(new DOMStructure(element3)), "#signature", null);
        SignatureProperties signatureProperties = this.fac.newSignatureProperties(Collections.singletonList(signatureProperty), "signature-properties-1");
        arrayList3.add(this.fac.newXMLObject(Collections.singletonList(signatureProperties), null, null, null));
        ArrayList<Object> arrayList6 = new ArrayList<Object>();
        arrayList6.add("CN=Sean Mullan,DC=sun,DC=com");
        arrayList6.add(this.kifac.newX509IssuerSerial("CN=Sean Mullan,DC=sun,DC=com", new BigInteger("47cdb772", 16)));
        arrayList6.add(this.signingCert);
        arrayList3.add(this.fac.newXMLObject(Collections.singletonList(this.kifac.newX509Data(arrayList6)), "object-4", null, null));
        XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, keyInfo, arrayList3, "signature", null);
        Element element5 = document.createElementNS("http://example.org/usps", "Envelope");
        element5.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://example.org/usps");
        element5.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:foo", "http://example.org/foo");
        document.appendChild(element5);
        Element element6 = document.createElementNS("http://example.org/usps", "DearSir");
        element6.appendChild(document.createTextNode("foo"));
        element5.appendChild(element6);
        Element element7 = document.createElementNS("http://example.org/usps", "Body");
        element7.appendChild(document.createTextNode("bar"));
        element5.appendChild(element7);
        Element element8 = document.createElementNS("http://example.org/usps", "YoursSincerely");
        element5.appendChild(element8);
        Element element9 = document.createElementNS("http://example.org/usps", "PostScript");
        element9.appendChild(document.createTextNode("bar"));
        element5.appendChild(element9);
        Element element10 = document.createElementNS(null, "Notaries");
        element10.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        element10.setAttributeNS(null, "Id", "notaries");
        Element element11 = document.createElementNS(null, "Notary");
        element11.setAttributeNS(null, "name", "Great, A. T.");
        Element element12 = document.createElementNS(null, "Notary");
        element12.setAttributeNS(null, "name", "Hun, A. T.");
        element10.appendChild(element11);
        element10.appendChild(element12);
        element5.appendChild(element10);
        element5.appendChild(document.createComment(" Commentary "));
        DOMSignContext dOMSignContext = new DOMSignContext(this.signingKey, (Node)element8);
        dOMSignContext.setIdAttributeNS(element10, null, "Id");
        dOMSignContext.setURIDereferencer(this.ud);
        xMLSignature.sign(dOMSignContext);
        StringWriter stringWriter = new StringWriter();
        this.dumpDocument(document, stringWriter);
        try {
            document = XMLUtils.createDocumentBuilder((boolean)false).parse(new InputSource(new StringReader(stringWriter.toString())));
        }
        catch (SAXParseException sAXParseException) {
            System.err.println("line:" + sAXParseException.getLineNumber());
            System.err.println("xml:" + stringWriter.toString());
        }
        Element element13 = SignatureValidator.getSignatureElement(document);
        if (element13 == null) {
            throw new Exception("Couldn't find signature Element");
        }
        DOMValidateContext dOMValidateContext = new DOMValidateContext(new X509KeySelector(this.ks), (Node)element13);
        File file = new File(System.getProperty("dir.test.vector.baltimore") + System.getProperty("file.separator") + "merlin-xmldsig-twenty-three" + System.getProperty("file.separator"));
        dOMValidateContext.setBaseURI(file.toURI().toString());
        dOMValidateContext.setURIDereferencer(this.ud);
        XMLSignature xMLSignature2 = this.fac.unmarshalXMLSignature(dOMValidateContext);
        CreateBaltimore23Test.assertTrue((boolean)xMLSignature.equals(xMLSignature2));
        CreateBaltimore23Test.assertTrue((boolean)xMLSignature2.validate(dOMValidateContext));
    }

    private void dumpDocument(Document document, Writer writer) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(new DOMSource(document), new StreamResult(writer));
    }

    private void test_create_signature_external(SignatureMethod signatureMethod, KeyInfo keyInfo, Key key, KeySelector keySelector, boolean bl) throws Exception {
        Reference reference = bl ? this.fac.newReference("http://www.w3.org/Signature/2002/04/xml-stylesheet.b64", this.sha1, Collections.singletonList(this.fac.newTransform("http://www.w3.org/2000/09/xmldsig#base64", (TransformParameterSpec)null)), null, null) : this.fac.newReference("http://www.w3.org/Signature/2002/04/xml-stylesheet.b64", this.sha1);
        SignedInfo signedInfo = this.fac.newSignedInfo(this.withoutComments, signatureMethod, Collections.singletonList(reference));
        Document document = this.db.newDocument();
        XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, keyInfo);
        DOMSignContext dOMSignContext = new DOMSignContext(key, (Node)document);
        dOMSignContext.setURIDereferencer(this.ud);
        xMLSignature.sign(dOMSignContext);
        DOMValidateContext dOMValidateContext = new DOMValidateContext(keySelector, (Node)document.getDocumentElement());
        String string = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        String string2 = System.getProperty("file.separator");
        File file = new File(string + string2 + "src/test/resources" + string2 + "ie" + string2 + "baltimore" + string2 + "merlin-examples" + string2 + "merlin-xmldsig-twenty-three" + string2);
        dOMValidateContext.setBaseURI(file.toURI().toString());
        dOMValidateContext.setURIDereferencer(this.ud);
        XMLSignature xMLSignature2 = this.fac.unmarshalXMLSignature(dOMValidateContext);
        CreateBaltimore23Test.assertTrue((boolean)xMLSignature.equals(xMLSignature2));
        CreateBaltimore23Test.assertTrue((boolean)xMLSignature2.validate(dOMValidateContext));
    }

    private void test_create_signature_enveloping(SignatureMethod signatureMethod, KeyInfo keyInfo, Key key, KeySelector keySelector, boolean bl) throws Exception {
        Reference reference = bl ? this.fac.newReference("#object", this.sha1, Collections.singletonList(this.fac.newTransform("http://www.w3.org/2000/09/xmldsig#base64", (TransformParameterSpec)null)), null, null) : this.fac.newReference("#object", this.sha1);
        SignedInfo signedInfo = this.fac.newSignedInfo(this.withoutComments, signatureMethod, Collections.singletonList(reference));
        Document document = this.db.newDocument();
        XMLObject xMLObject = this.fac.newXMLObject(Collections.singletonList(new DOMStructure(document.createTextNode("some text"))), "object", null, null);
        XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, keyInfo, Collections.singletonList(xMLObject), null, null);
        DOMSignContext dOMSignContext = new DOMSignContext(key, (Node)document);
        xMLSignature.sign(dOMSignContext);
        DOMValidateContext dOMValidateContext = new DOMValidateContext(keySelector, (Node)document.getDocumentElement());
        XMLSignature xMLSignature2 = this.fac.unmarshalXMLSignature(dOMValidateContext);
        CreateBaltimore23Test.assertTrue((boolean)xMLSignature.equals(xMLSignature2));
        CreateBaltimore23Test.assertTrue((boolean)xMLSignature2.validate(dOMValidateContext));
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

