/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collections;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.parsers.DocumentBuilder;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CreateInteropExcC14NTest
extends Assert {
    private XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    private KeyInfoFactory kifac = this.fac.getKeyInfoFactory();
    private DocumentBuilder db = XMLUtils.createDocumentBuilder((boolean)false);
    private KeyStore ks;
    private Key signingKey;
    private PublicKey validatingKey;

    public CreateInteropExcC14NTest() throws Exception {
        String string = System.getProperty("basedir") == null ? "./" : System.getProperty("basedir");
        String string2 = System.getProperty("file.separator");
        FileInputStream fileInputStream = new FileInputStream(string + string2 + "src/test/resources" + string2 + "test.jks");
        this.ks = KeyStore.getInstance("JKS");
        this.ks.load(fileInputStream, "changeit".toCharArray());
        Certificate certificate = this.ks.getCertificate("mullan");
        this.signingKey = this.ks.getKey("mullan", "changeit".toCharArray());
        this.validatingKey = certificate.getPublicKey();
    }

    @Test
    public void test_create_Y1() throws Exception {
        ArrayList<Reference> arrayList = new ArrayList<Reference>(4);
        arrayList.add(this.fac.newReference("#xpointer(id('to-be-signed'))", this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(this.fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", (TransformParameterSpec)null)), null, null));
        ArrayList<String> arrayList2 = new ArrayList<String>(2);
        arrayList2.add("bar");
        arrayList2.add("#default");
        ExcC14NParameterSpec excC14NParameterSpec = new ExcC14NParameterSpec(arrayList2);
        arrayList.add(this.fac.newReference("#xpointer(id('to-be-signed'))", this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(this.fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#", excC14NParameterSpec)), null, null));
        arrayList.add(this.fac.newReference("#xpointer(id('to-be-signed'))", this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(this.fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", (TransformParameterSpec)null)), null, null));
        arrayList2 = new ArrayList(2);
        arrayList2.add("bar");
        arrayList2.add("#default");
        excC14NParameterSpec = new ExcC14NParameterSpec(arrayList2);
        arrayList.add(this.fac.newReference("#xpointer(id('to-be-signed'))", this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(this.fac.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", excC14NParameterSpec)), null, null));
        SignedInfo signedInfo = this.fac.newSignedInfo(this.fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null), this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null), arrayList);
        ArrayList<KeyValue> arrayList3 = new ArrayList<KeyValue>(2);
        arrayList3.add(this.kifac.newKeyValue(this.validatingKey));
        KeyInfo keyInfo = this.kifac.newKeyInfo(arrayList3);
        Document document = this.db.newDocument();
        Element element = document.createElementNS("urn:bar", "bar:Baz");
        Comment comment = document.createComment(" comment ");
        element.appendChild(comment);
        XMLObject xMLObject = this.fac.newXMLObject(Collections.singletonList(new DOMStructure(element)), "to-be-signed", null, null);
        XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, keyInfo, Collections.singletonList(xMLObject), null, null);
        Element element2 = document.createElementNS("urn:foo", "Foo");
        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:foo");
        element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:bar", "urn:bar");
        document.appendChild(element2);
        DOMSignContext dOMSignContext = new DOMSignContext(this.signingKey, (Node)element2);
        dOMSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "dsig");
        xMLSignature.sign(dOMSignContext);
        DOMValidateContext dOMValidateContext = new DOMValidateContext(new KeySelectors.KeyValueKeySelector(), element2.getLastChild());
        XMLSignature xMLSignature2 = this.fac.unmarshalXMLSignature(dOMValidateContext);
        CreateInteropExcC14NTest.assertTrue((boolean)xMLSignature.equals(xMLSignature2));
        CreateInteropExcC14NTest.assertTrue((boolean)xMLSignature2.validate(dOMValidateContext));
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

