/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.util.Collections;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.TestUtils;
import javax.xml.parsers.DocumentBuilder;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CreateInteropXMLDSig11Test
extends Assert {
    private KeySelector kvks;
    private KeySelector sks;
    private CanonicalizationMethod withoutComments;
    private DigestMethod sha1;
    private DigestMethod sha256;
    private DigestMethod sha384;
    private DigestMethod sha512;
    private SignatureMethod ecdsaSha1;
    private SignatureMethod ecdsaSha256;
    private SignatureMethod ecdsaSha384;
    private SignatureMethod ecdsaSha512;
    private SignatureMethod rsaSha256;
    private SignatureMethod rsaSha384;
    private SignatureMethod rsaSha512;
    private SignatureMethod hmacSha256;
    private SignatureMethod hmacSha384;
    private SignatureMethod hmacSha512;
    private KeyInfo p256ki;
    private KeyInfo p384ki;
    private KeyInfo p521ki;
    private KeyInfo rsaki;
    private KeyInfo rsa2048ki;
    private XMLSignatureFactory fac;
    private DocumentBuilder db;
    private KeyPair p256;
    private KeyPair p384;
    private KeyPair p521;
    private KeyPair rsa2048;
    private boolean ecSupport = true;

    public CreateInteropXMLDSig11Test() throws Exception {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("EC");
            keyPairGenerator.initialize(new ECGenParameterSpec("1.2.840.10045.3.1.7"));
            this.p256 = keyPairGenerator.generateKeyPair();
            keyPairGenerator.initialize(new ECGenParameterSpec("1.3.132.0.34"));
            this.p384 = keyPairGenerator.generateKeyPair();
            keyPairGenerator.initialize(new ECGenParameterSpec("1.3.132.0.35"));
            this.p521 = keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.ecSupport = false;
        }
        keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048);
        this.rsa2048 = keyPairGenerator.generateKeyPair();
        this.db = XMLUtils.createDocumentBuilder((boolean)false);
        this.fac = XMLSignatureFactory.getInstance();
        KeyInfoFactory keyInfoFactory = this.fac.getKeyInfoFactory();
        this.withoutComments = this.fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null);
        this.sha1 = this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        this.sha256 = this.fac.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", null);
        this.sha384 = this.fac.newDigestMethod("http://www.w3.org/2001/04/xmldsig-more#sha384", null);
        this.sha512 = this.fac.newDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512", null);
        if (this.ecSupport) {
            this.p256ki = keyInfoFactory.newKeyInfo(Collections.singletonList(keyInfoFactory.newKeyValue(this.p256.getPublic())));
            this.p384ki = keyInfoFactory.newKeyInfo(Collections.singletonList(keyInfoFactory.newKeyValue(this.p384.getPublic())));
            this.p521ki = keyInfoFactory.newKeyInfo(Collections.singletonList(keyInfoFactory.newKeyValue(this.p521.getPublic())));
            this.ecdsaSha1 = this.fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", null);
            this.ecdsaSha256 = this.fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", null);
            this.ecdsaSha384 = this.fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", null);
            this.ecdsaSha512 = this.fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", null);
        }
        this.rsaki = keyInfoFactory.newKeyInfo(Collections.singletonList(keyInfoFactory.newKeyValue(TestUtils.getPublicKey("RSA"))));
        this.rsa2048ki = keyInfoFactory.newKeyInfo(Collections.singletonList(keyInfoFactory.newKeyValue(this.rsa2048.getPublic())));
        this.rsaSha256 = this.fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", null);
        this.rsaSha384 = this.fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", null);
        this.rsaSha512 = this.fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", null);
        this.hmacSha256 = this.fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", null);
        this.hmacSha384 = this.fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384", null);
        this.hmacSha512 = this.fac.newSignatureMethod("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512", null);
        this.kvks = new KeySelectors.KeyValueKeySelector();
        this.sks = new KeySelectors.SecretKeySelector("testkey".getBytes("ASCII"));
    }

    @Test
    public void test_create_enveloping_p256_sha1() throws Exception {
        if (this.ecSupport) {
            this.test_create_signature_enveloping(this.ecdsaSha1, this.sha1, this.p256ki, this.p256.getPrivate(), this.kvks);
        }
    }

    @Test
    public void test_create_enveloping_p256_sha256() throws Exception {
        if (this.ecSupport) {
            this.test_create_signature_enveloping(this.ecdsaSha256, this.sha256, this.p256ki, this.p256.getPrivate(), this.kvks);
        }
    }

    @Test
    public void test_create_enveloping_p256_sha384() throws Exception {
        if (this.ecSupport) {
            this.test_create_signature_enveloping(this.ecdsaSha384, this.sha384, this.p256ki, this.p256.getPrivate(), this.kvks);
        }
    }

    @Test
    public void test_create_enveloping_p256_sha512() throws Exception {
        if (this.ecSupport) {
            this.test_create_signature_enveloping(this.ecdsaSha512, this.sha512, this.p256ki, this.p256.getPrivate(), this.kvks);
        }
    }

    @Test
    public void test_create_enveloping_p384_sha1() throws Exception {
        if (this.ecSupport) {
            this.test_create_signature_enveloping(this.ecdsaSha1, this.sha1, this.p384ki, this.p384.getPrivate(), this.kvks);
        }
    }

    @Test
    public void test_create_enveloping_p384_sha256() throws Exception {
        if (this.ecSupport) {
            this.test_create_signature_enveloping(this.ecdsaSha256, this.sha256, this.p384ki, this.p384.getPrivate(), this.kvks);
        }
    }

    @Test
    public void test_create_enveloping_p384_sha384() throws Exception {
        if (this.ecSupport) {
            this.test_create_signature_enveloping(this.ecdsaSha384, this.sha384, this.p384ki, this.p384.getPrivate(), this.kvks);
        }
    }

    @Test
    public void test_create_enveloping_p384_sha512() throws Exception {
        if (this.ecSupport) {
            this.test_create_signature_enveloping(this.ecdsaSha512, this.sha512, this.p384ki, this.p384.getPrivate(), this.kvks);
        }
    }

    @Test
    public void test_create_enveloping_p521_sha1() throws Exception {
        if (this.ecSupport) {
            this.test_create_signature_enveloping(this.ecdsaSha1, this.sha1, this.p521ki, this.p521.getPrivate(), this.kvks);
        }
    }

    @Test
    public void test_create_enveloping_p521_sha256() throws Exception {
        if (this.ecSupport) {
            this.test_create_signature_enveloping(this.ecdsaSha256, this.sha256, this.p521ki, this.p521.getPrivate(), this.kvks);
        }
    }

    @Test
    public void test_create_enveloping_p521_sha384() throws Exception {
        if (this.ecSupport) {
            this.test_create_signature_enveloping(this.ecdsaSha384, this.sha384, this.p521ki, this.p521.getPrivate(), this.kvks);
        }
    }

    @Test
    public void test_create_enveloping_p521_sha512() throws Exception {
        if (this.ecSupport) {
            this.test_create_signature_enveloping(this.ecdsaSha512, this.sha512, this.p521ki, this.p521.getPrivate(), this.kvks);
        }
    }

    @Test
    public void test_create_enveloping_rsa_sha256() throws Exception {
        this.test_create_signature_enveloping(this.rsaSha256, this.sha1, this.rsaki, TestUtils.getPrivateKey("RSA"), this.kvks);
    }

    @Test
    public void test_create_enveloping_rsa_sha384() throws Exception {
        this.test_create_signature_enveloping(this.rsaSha384, this.sha1, this.rsa2048ki, this.rsa2048.getPrivate(), this.kvks);
    }

    @Test
    public void test_create_enveloping_rsa_sha512() throws Exception {
        this.test_create_signature_enveloping(this.rsaSha512, this.sha1, this.rsa2048ki, this.rsa2048.getPrivate(), this.kvks);
    }

    @Test
    public void test_create_enveloping_sha256_rsa_sha256() throws Exception {
        this.test_create_signature_enveloping(this.rsaSha256, this.sha256, this.rsaki, TestUtils.getPrivateKey("RSA"), this.kvks);
    }

    @Test
    public void test_create_enveloping_sha384_rsa_sha256() throws Exception {
        this.test_create_signature_enveloping(this.rsaSha256, this.sha384, this.rsaki, TestUtils.getPrivateKey("RSA"), this.kvks);
    }

    @Test
    public void test_create_enveloping_sha512_rsa_sha256() throws Exception {
        this.test_create_signature_enveloping(this.rsaSha256, this.sha512, this.rsaki, TestUtils.getPrivateKey("RSA"), this.kvks);
    }

    @Test
    public void test_create_enveloping_hmac_sha256() throws Exception {
        this.test_create_signature_enveloping(this.hmacSha256, this.sha1, this.rsaki, TestUtils.getSecretKey("testkey".getBytes("ASCII")), this.sks);
    }

    @Test
    public void test_create_enveloping_hmac_sha384() throws Exception {
        this.test_create_signature_enveloping(this.hmacSha384, this.sha1, this.rsaki, TestUtils.getSecretKey("testkey".getBytes("ASCII")), this.sks);
    }

    @Test
    public void test_create_enveloping_hmac_sha512() throws Exception {
        this.test_create_signature_enveloping(this.hmacSha512, this.sha1, this.rsaki, TestUtils.getSecretKey("testkey".getBytes("ASCII")), this.sks);
    }

    private void test_create_signature_enveloping(SignatureMethod signatureMethod, DigestMethod digestMethod, KeyInfo keyInfo, Key key, KeySelector keySelector) throws Exception {
        Reference reference = this.fac.newReference("#DSig.Object_1", digestMethod, null, "http://www.w3.org/2000/09/xmldsig#Object", null);
        SignedInfo signedInfo = this.fac.newSignedInfo(this.withoutComments, signatureMethod, Collections.singletonList(reference));
        Document document = this.db.newDocument();
        Element element = document.createElementNS(null, "Web");
        Text text = document.createTextNode("up up and away");
        element.appendChild(text);
        XMLObject xMLObject = this.fac.newXMLObject(Collections.singletonList(new DOMStructure(element)), "DSig.Object_1", "text/xml", null);
        XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, keyInfo, Collections.singletonList(xMLObject), null, null);
        DOMSignContext dOMSignContext = new DOMSignContext(key, (Node)document);
        dOMSignContext.setDefaultNamespacePrefix("dsig");
        xMLSignature.sign(dOMSignContext);
        DOMValidateContext dOMValidateContext = new DOMValidateContext(keySelector, (Node)document.getDocumentElement());
        XMLSignature xMLSignature2 = this.fac.unmarshalXMLSignature(dOMValidateContext);
        CreateInteropXMLDSig11Test.assertTrue((boolean)xMLSignature.equals(xMLSignature2));
        CreateInteropXMLDSig11Test.assertTrue((boolean)xMLSignature2.validate(dOMValidateContext));
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

