/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.HMACParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.crypto.test.KeySelectors;
import javax.xml.crypto.test.dsig.LocalHttpCacheURIDereferencer;
import javax.xml.parsers.DocumentBuilder;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CreatePhaosXMLDSig3Test
extends Assert {
    private XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
    private DocumentBuilder db = XMLUtils.createDocumentBuilder((boolean)false);

    @Test
    public void test_create_hmac_sha1_exclusive_c14n_comments_detached() throws Exception {
        this.test_create_hmac_sha1_exclusive_c14n_comments_detached(false);
    }

    @Test
    public void test_create_hmac_sha1_40_exclusive_c14n_comments_detached() throws Exception {
        try {
            this.test_create_hmac_sha1_exclusive_c14n_comments_detached(true);
            CreatePhaosXMLDSig3Test.fail((String)"Expected HMACOutputLength Exception");
        }
        catch (XMLSignatureException xMLSignatureException) {
            System.out.println(xMLSignatureException.getMessage());
        }
    }

    private void test_create_hmac_sha1_exclusive_c14n_comments_detached(boolean bl) throws Exception {
        Reference reference = this.fac.newReference("http://www.ietf.org/rfc/rfc3161.txt", this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
        HMACParameterSpec hMACParameterSpec = null;
        if (bl) {
            hMACParameterSpec = new HMACParameterSpec(40);
        }
        SignedInfo signedInfo = this.fac.newSignedInfo(this.fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", (C14NMethodParameterSpec)null), this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#hmac-sha1", hMACParameterSpec), Collections.singletonList(reference));
        XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, null);
        Document document = this.db.newDocument();
        DOMSignContext dOMSignContext = new DOMSignContext(new KeySelectors.SecretKeySelector("test".getBytes("ASCII")), (Node)document);
        dOMSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "dsig");
        LocalHttpCacheURIDereferencer localHttpCacheURIDereferencer = new LocalHttpCacheURIDereferencer();
        dOMSignContext.setURIDereferencer(localHttpCacheURIDereferencer);
        xMLSignature.sign(dOMSignContext);
        DOMValidateContext dOMValidateContext = new DOMValidateContext(new KeySelectors.SecretKeySelector("test".getBytes("ASCII")), (Node)document);
        dOMValidateContext.setURIDereferencer(localHttpCacheURIDereferencer);
        XMLSignature xMLSignature2 = this.fac.unmarshalXMLSignature(dOMValidateContext);
        CreatePhaosXMLDSig3Test.assertTrue((boolean)xMLSignature.equals(xMLSignature2));
        CreatePhaosXMLDSig3Test.assertTrue((boolean)xMLSignature2.validate(dOMValidateContext));
    }

    @Test
    public void test_create_hmac_sha1_exclusive_c14n_enveloped() throws Exception {
        Reference reference = this.fac.newReference("", this.fac.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null), Collections.singletonList(this.fac.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null)), null, null);
        SignedInfo signedInfo = this.fac.newSignedInfo(this.fac.newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null), this.fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#hmac-sha1", null), Collections.singletonList(reference));
        XMLSignature xMLSignature = this.fac.newXMLSignature(signedInfo, null);
        Document document = this.db.newDocument();
        Element element = document.createElementNS(null, "player");
        element.setAttributeNS(null, "bats", "left");
        element.setAttributeNS(null, "id", "10012");
        element.setAttributeNS(null, "throws", "right");
        Element element2 = document.createElementNS(null, "name");
        element2.appendChild(document.createTextNode("Alfonso Soriano"));
        Element element3 = document.createElementNS(null, "position");
        element3.appendChild(document.createTextNode("2B"));
        Element element4 = document.createElementNS(null, "team");
        element4.appendChild(document.createTextNode("New York Yankees"));
        element.appendChild(document.createComment(" Here's a comment "));
        element.appendChild(element2);
        element.appendChild(element3);
        element.appendChild(element4);
        document.appendChild(element);
        DOMSignContext dOMSignContext = new DOMSignContext(new KeySelectors.SecretKeySelector("test".getBytes("ASCII")), (Node)element);
        dOMSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "dsig");
        xMLSignature.sign(dOMSignContext);
        DOMValidateContext dOMValidateContext = new DOMValidateContext(new KeySelectors.SecretKeySelector("test".getBytes("ASCII")), element.getLastChild());
        XMLSignature xMLSignature2 = this.fac.unmarshalXMLSignature(dOMValidateContext);
        CreatePhaosXMLDSig3Test.assertTrue((boolean)xMLSignature.equals(xMLSignature2));
        CreatePhaosXMLDSig3Test.assertTrue((boolean)xMLSignature2.validate(dOMValidateContext));
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

