/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.test.dsig;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collections;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.test.dsig.LocalHttpCacheURIDereferencer;
import org.apache.jcp.xml.dsig.internal.dom.XMLDSigRI;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DetachedTest
extends Assert {
    @Test
    public void test() {
        try {
            XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)new XMLDSigRI());
            Reference reference = xMLSignatureFactory.newReference("http://www.w3.org/TR/xml-stylesheet", xMLSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA");
            keyPairGenerator.initialize(1024, new SecureRandom("not so random bytes".getBytes()));
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            KeyInfoFactory keyInfoFactory = xMLSignatureFactory.getKeyInfoFactory();
            KeyValue keyValue = keyInfoFactory.newKeyValue(keyPair.getPublic());
            KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(keyValue));
            SignedInfo signedInfo = xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null), xMLSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null), Collections.singletonList(reference));
            XMLSignature xMLSignature = xMLSignatureFactory.newXMLSignature(signedInfo, keyInfo, null, null, null);
            Document document = XMLUtils.createDocumentBuilder((boolean)false).newDocument();
            DOMSignContext dOMSignContext = new DOMSignContext(keyPair.getPrivate(), (Node)document);
            dOMSignContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds");
            LocalHttpCacheURIDereferencer localHttpCacheURIDereferencer = new LocalHttpCacheURIDereferencer();
            dOMSignContext.setURIDereferencer(localHttpCacheURIDereferencer);
            xMLSignature.sign(dOMSignContext);
            DOMValidateContext dOMValidateContext = new DOMValidateContext(keyPair.getPublic(), (Node)document.getDocumentElement());
            dOMValidateContext.setURIDereferencer(localHttpCacheURIDereferencer);
            boolean bl = xMLSignature.validate(dOMValidateContext);
            if (!bl) {
                for (Reference reference2 : xMLSignature.getSignedInfo().getReferences()) {
                    reference2.validate(dOMValidateContext);
                }
                DetachedTest.fail((String)"Signature failed core validation");
            }
            xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(dOMValidateContext);
            bl = xMLSignature.validate(dOMValidateContext);
            DetachedTest.assertTrue((String)"Core validity of unmarshalled XMLSignature is false", (boolean)bl);
        }
        catch (Exception exception) {
            DetachedTest.fail((String)("Exception: " + exception));
        }
    }

    static {
        Security.insertProviderAt((Provider)new XMLDSigRI(), 1);
    }
}

